/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.dao;

import com.centit.core.dao.BaseDaoImpl;
import com.centit.core.utils.PageDesc;
import com.centit.sys.po.FUserunit;
import com.centit.sys.po.FUserunitId;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class UserUnitDao
extends BaseDaoImpl<FUserunit> {
    private static final long serialVersionUID = 1L;

    public List<FUserunit> getSysUnitsByUserId(String userId) {
        List ls = this.getHibernateTemplate().find("FROM FUserunit fUserunit where fUserunit.id.usercode=?", (Object)userId);
        return ls;
    }

    public List<FUserunit> getSysUsersByUnitId(String unitCode) {
        List ls = this.getHibernateTemplate().find("FROM FUserunit fUserunit where fUserunit.id.unitcode=?", (Object)unitCode);
        return ls;
    }

    public List<FUserunit> getSysUsersByRoleAndUnit(String roleType, String roleCode, String unitCode) {
        List ls = null;
        if (unitCode != null && !"".equals(unitCode)) {
            if ("gw".equals(roleType)) {
                ls = this.getHibernateTemplate().find("FROM FUserunit fUserunit where fUserunit.id.unitcode=? and fUserunit.id.userstation=? ", new Object[]{unitCode, roleCode});
            } else if ("xz".equals(roleType)) {
                ls = this.getHibernateTemplate().find("FROM FUserunit fUserunit where fUserunit.id.unitcode=? and fUserunit.id.userrank=? ", new Object[]{unitCode, roleCode});
            }
        } else if ("gw".equals(roleType)) {
            ls = this.getHibernateTemplate().find("FROM FUserunit fUserunit where fUserunit.id.userstation=? ", (Object)roleCode);
        } else if ("xz".equals(roleType)) {
            ls = this.getHibernateTemplate().find("FROM FUserunit fUserunit where fUserunit.id.userrank=? ", (Object)roleCode);
        }
        return ls;
    }

    public FUserunit getUserunitByUserid(String userid) {
        List list = this.getHibernateTemplate().find("FROM FUserunit fUserunit where fUserunit.isprimary = 'T' and fUserunit.id.usercode=? ", (Object)userid);
        if (list != null) {
            return (FUserunit)list.get(0);
        }
        return null;
    }

    public List<FUserunit> getSysUsersByUnitId(String unitCode, PageDesc pageDesc, Map<String, Object> filterMap) {
        StringBuffer hql = new StringBuffer("FROM FUserunit fUserunit where fUserunit.id.unitcode=? ");
        if (null != filterMap && null != filterMap.get("ORDER_BY")) {
            hql.append("order by " + (String)filterMap.get("ORDER_BY"));
        }
        return super.listObjects(hql.toString(), (Object)unitCode, pageDesc);
    }

    public <T> void deleteAll(Class<T> clazz) {
        String hql = "delete from " + clazz.getName();
        super.doExecuteHql(hql);
    }

    public void batchSave(List<FUserunit> userunits) {
        for (int i = 0; i < userunits.size(); ++i) {
            super.saveObject((Object)userunits.get(i));
            if (0 != i % 20) continue;
            super.getHibernateTemplate().flush();
            super.getHibernateTemplate().clear();
        }
    }

    public List<FUserunit> listUserunitByIds(List<FUserunitId> ids) {
        return super.getHibernateTemplate().findByCriteria(DetachedCriteria.forClass(FUserunit.class).add(Restrictions.in((String)"id", ids)));
    }

    public void batchMerge(List<FUserunit> userunits) {
        for (int i = 0; i < userunits.size(); ++i) {
            this.getHibernateTemplate().merge((Object)userunits.get(i));
            if (19 != i % 20) continue;
            super.getHibernateTemplate().flush();
            super.getHibernateTemplate().clear();
        }
    }

    public void updateUserPrimaryUnit(String usercode) {
        String hql = "update FUserunit un set un.isprimary = 'F' where un.usercode = ?";
        super.doExecuteHql("update FUserunit un set un.isprimary = 'F' where un.usercode = ?", (Object)usercode);
    }
}

