/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.security;

import com.centit.sys.dao.UserRoleDao;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FRoleinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.Usersetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;

public class FUserDetail
extends FUserinfo
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private UserRoleDao sysusrodao;
    private Date lastUpdateRoleTime = null;
    private Collection<GrantedAuthority> arrayAuths = null;
    Usersetting userSetting;
    List<FOptinfo> userFuncs;
    Map<String, String> userOptList;

    public void setSysusrodao(UserRoleDao sysusrodao) {
        this.sysusrodao = sysusrodao;
    }

    public Map<String, String> getUserOptList() {
        return this.userOptList;
    }

    public void setUserOptList(Map<String, String> userOptList) {
        this.userOptList = userOptList;
    }

    public FUserDetail(FUserinfo user) {
        super(user.getUsercode(), user.getUserpin(), user.getIsvalid(), user.getLoginname(), user.getUsername(), user.getUserdesc(), user.getLogintimes(), user.getActivetime(), user.getLoginip(), user.getAddrbookid());
    }

    public FUserDetail() {
    }

    public FUserDetail(String usercode, String userstate, String loginname, String username) {
        super(usercode, userstate, loginname, username);
    }

    public FUserDetail(String usercode, String userpin, String userstate, String loginname, String username, String userdesc, Long logintimes, Date activeime, String loginip, Long addrbookid) {
        super(usercode, userpin, userstate, loginname, username, userdesc, logintimes, activeime, loginip, addrbookid);
    }

    public void setAuthoritiesByRoles(List<FRoleinfo> roles) {
        if (roles.size() < 1) {
            return;
        }
        this.arrayAuths = new ArrayList<GrantedAuthority>();
        for (FRoleinfo role : roles) {
            this.arrayAuths.add((GrantedAuthority)new GrantedAuthorityImpl("R_" + role.getRolecode()));
        }
        this.lastUpdateRoleTime = new Date(System.currentTimeMillis());
    }

    private void loadAuthoritys() {
        this.lastUpdateRoleTime = new Date(System.currentTimeMillis());
        List<FRoleinfo> roles = this.sysusrodao.getSysRolesByUsid(this.getUsercode());
        this.setAuthoritiesByRoles(roles);
    }

    public boolean isAccountNonExpired() {
        return "T".equals(this.getIsvalid());
    }

    public boolean isAccountNonLocked() {
        return "T".equals(this.getIsvalid());
    }

    public boolean isCredentialsNonExpired() {
        return !this.isCredentialsExpired();
    }

    public boolean isAccountExpired() {
        return "F".equals(this.getIsvalid());
    }

    public boolean isAccountLocked() {
        return "F".equals(this.getIsvalid());
    }

    public boolean isCredentialsExpired() {
        return this.isAccountLocked();
    }

    public Collection<GrantedAuthority> getAuthorities() {
        if (this.arrayAuths == null || this.lastUpdateRoleTime == null || new Date(System.currentTimeMillis()).getTime() - this.lastUpdateRoleTime.getTime() > 600000L) {
            this.loadAuthoritys();
        }
        return this.arrayAuths;
    }

    public Usersetting getUserSetting() {
        return this.userSetting;
    }

    public void setUserSetting(Usersetting userSetting) {
        this.userSetting = userSetting;
    }

    public List<FOptinfo> getUserFuncs() {
        return this.userFuncs;
    }

    public void setUserFuncs(List<FOptinfo> userFuncs) {
        this.userFuncs = userFuncs;
    }

    public String getPassword() {
        return this.getUserpin();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FUserDetail:");
        sb.append(super.toString());
        return sb.toString();
    }
}

