/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service;

import com.centit.core.utils.LabelValueBean;
import com.centit.support.compiler.Lexer;
import com.centit.support.utils.Algorithm;
import com.centit.sys.po.FDatadictionary;
import com.centit.sys.po.FOptdef;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FRoleinfo;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserunit;
import com.centit.sys.security.FUserDetail;
import com.centit.sys.service.CodeRepositoryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class CodeRepositoryUtil {
    public static final Integer MAXXZRANK = 100000;

    public static final String getValue(String sCatalog, String sKey) {
        try {
            if (sCatalog.equalsIgnoreCase("usercode")) {
                return CodeRepositoryManager.USERREPO.get(sKey).getUsername();
            }
            if (sCatalog.equalsIgnoreCase("userorder")) {
                return CodeRepositoryManager.USERREPO.get(sKey).getUserorder() == null ? "0" : CodeRepositoryManager.USERREPO.get(sKey).getUserorder() + "";
            }
            if (sCatalog.equalsIgnoreCase("loginName")) {
                return CodeRepositoryManager.LOGINEPO.get(sKey).getUsername();
            }
            if (sCatalog.equalsIgnoreCase("unitcode")) {
                return CodeRepositoryManager.UNITREPO.get(sKey).getUnitname();
            }
            if (sCatalog.equalsIgnoreCase("depno")) {
                return CodeRepositoryManager.DEPNO.get(sKey).getUnitname();
            }
            if (sCatalog.equalsIgnoreCase("rolecode")) {
                return CodeRepositoryManager.ROLEREPO.get(sKey).getRolename();
            }
            if (sCatalog.equalsIgnoreCase("optid")) {
                return CodeRepositoryManager.OPTREPO.get(sKey).getOptname();
            }
            if (sCatalog.equalsIgnoreCase("optcode")) {
                return CodeRepositoryManager.POWERREPO.get(sKey).getOptname();
            }
            if (sCatalog.equalsIgnoreCase("optdesc")) {
                FOptdef optdef = CodeRepositoryManager.POWERREPO.get(sKey);
                return CodeRepositoryManager.OPTREPO.get(optdef.getOptid()).getOptname() + "-" + optdef.getOptname();
            }
            FDatadictionary dictPiece = CodeRepositoryUtil.getDataPiece(sCatalog, sKey);
            if (dictPiece == null) {
                return sKey;
            }
            return dictPiece.toString();
        }
        catch (Exception e) {
            return sKey;
        }
    }

    public static final String getCode(String sCatalog, String sValue) {
        if (sValue == null || "".equals(sValue)) {
            return "";
        }
        try {
            if (sCatalog.equalsIgnoreCase("usercode")) {
                for (Map.Entry<String, FUserinfo> ent : CodeRepositoryManager.USERREPO.entrySet()) {
                    if (!sValue.equals(ent.getValue().getUsername())) continue;
                    return ent.getKey();
                }
                return sValue;
            }
            if (sCatalog.equalsIgnoreCase("loginName")) {
                for (Map.Entry<String, FUserinfo> ent : CodeRepositoryManager.LOGINEPO.entrySet()) {
                    if (!sValue.equals(ent.getValue().getUsername())) continue;
                    return ent.getKey();
                }
                return sValue;
            }
            if (sCatalog.equalsIgnoreCase("unitcode")) {
                for (Map.Entry<String, FUnitinfo> ent : CodeRepositoryManager.UNITREPO.entrySet()) {
                    if (!sValue.equals(ent.getValue().getUnitname())) continue;
                    return ent.getKey();
                }
                return sValue;
            }
            if (sCatalog.equalsIgnoreCase("depno")) {
                for (Map.Entry<String, FUnitinfo> ent : CodeRepositoryManager.UNITREPO.entrySet()) {
                    if (!sValue.equals(ent.getValue().getUnitname())) continue;
                    return ent.getValue().getDepno();
                }
                return sValue;
            }
            if (sCatalog.equalsIgnoreCase("rolecode")) {
                for (Map.Entry<String, FRoleinfo> ent : CodeRepositoryManager.ROLEREPO.entrySet()) {
                    if (!sValue.equals(ent.getValue().getRolename())) continue;
                    return ent.getKey();
                }
                return sValue;
            }
            if (sCatalog.equalsIgnoreCase("optid")) {
                for (Map.Entry<String, FOptinfo> ent : CodeRepositoryManager.OPTREPO.entrySet()) {
                    if (!sValue.equals(ent.getValue().getOptname())) continue;
                    return ent.getKey();
                }
                return sValue;
            }
            if (sCatalog.equalsIgnoreCase("optcode")) {
                for (Map.Entry<String, FOptdef> ent : CodeRepositoryManager.POWERREPO.entrySet()) {
                    if (!sValue.equals(ent.getValue().getOptname())) continue;
                    return ent.getKey();
                }
                return sValue;
            }
            FDatadictionary dictPiece = CodeRepositoryUtil.getDataPieceByValue(sCatalog, sValue);
            if (dictPiece == null) {
                return sValue;
            }
            return dictPiece.getDatacode();
        }
        catch (Exception e) {
            return sValue;
        }
    }

    public static final String transExpression(String sCatalog, String sExpression) {
        String aWord;
        StringBuilder sb = new StringBuilder();
        Lexer lex = new Lexer();
        lex.setFormula(sExpression);
        while ((aWord = lex.getAWord()) != null && !"".equals(aWord)) {
            aWord = CodeRepositoryUtil.getValue(sCatalog, aWord);
            sb.append(aWord);
        }
        return sb.toString();
    }

    public static final String getItemState(String sCatalog, String sKey) {
        try {
            if (sCatalog.equalsIgnoreCase("usercode")) {
                return CodeRepositoryManager.USERREPO.get(sKey).getIsvalid();
            }
            if (sCatalog.equalsIgnoreCase("loginName")) {
                return CodeRepositoryManager.LOGINEPO.get(sKey).getIsvalid();
            }
            if (sCatalog.equalsIgnoreCase("unitcode")) {
                return CodeRepositoryManager.UNITREPO.get(sKey).getIsvalid();
            }
            if (sCatalog.equalsIgnoreCase("rolecode")) {
                return CodeRepositoryManager.ROLEREPO.get(sKey).getIsvalid();
            }
            FDatadictionary dictPiece = CodeRepositoryUtil.getDataPiece(sCatalog, sKey);
            if (dictPiece == null) {
                return "";
            }
            return dictPiece.getState();
        }
        catch (Exception e) {
            return sKey;
        }
    }

    public static final List<FOptinfo> getOptinfoList(String sOptType) {
        ArrayList<FOptinfo> optList = new ArrayList<FOptinfo>();
        for (Map.Entry<String, FOptinfo> ent : CodeRepositoryManager.OPTREPO.entrySet()) {
            FOptinfo value = ent.getValue();
            if (sOptType.equals("P")) {
                if ("W".equals(value.getOpttype()) || CodeRepositoryUtil.getOptDefByOptID(value.getOptid()).size() <= 0) continue;
                optList.add(value);
                continue;
            }
            if (sOptType.equals("R")) {
                if ("W".equals(value.getOpttype())) continue;
                optList.add(value);
                continue;
            }
            if (!sOptType.equals("A") && !sOptType.equals(value.getOpttype())) continue;
            optList.add(value);
        }
        Collections.sort(optList, new Comparator<FOptinfo>(){

            @Override
            public int compare(FOptinfo o1, FOptinfo o2) {
                if (o2.getOrderind() == null) {
                    return 1;
                }
                if (o1.getOrderind() == null) {
                    return 0;
                }
                if (o1.getOrderind() > o2.getOrderind()) {
                    return 1;
                }
                return 0;
            }
        });
        return optList;
    }

    public static final List<FOptdef> getOptdefList() {
        ArrayList<FOptdef> optdefList = new ArrayList<FOptdef>();
        for (Map.Entry<String, FOptdef> ent : CodeRepositoryManager.POWERREPO.entrySet()) {
            FOptdef value = ent.getValue();
            optdefList.add(value);
        }
        return optdefList;
    }

    public static final List<FOptdef> getOptDefByOptID(String sOptID) {
        ArrayList<FOptdef> optList = new ArrayList<FOptdef>();
        for (Map.Entry<String, FOptdef> ent : CodeRepositoryManager.POWERREPO.entrySet()) {
            FOptdef value = ent.getValue();
            if (!sOptID.equals(value.getOptid())) continue;
            optList.add(value);
        }
        return optList;
    }

    public static final List<FOptdef> getOptDefByIsFlow(String isInFlow) {
        ArrayList<FOptdef> optList = new ArrayList<FOptdef>();
        for (Map.Entry<String, FOptdef> ent : CodeRepositoryManager.POWERREPO.entrySet()) {
            FOptdef value = ent.getValue();
            if (!isInFlow.equals(value.getIsinworkflow())) continue;
            optList.add(value);
        }
        return optList;
    }

    public static final List<FRoleinfo> getRoleinfoList(String sPrefix) {
        ArrayList<FRoleinfo> roleList = new ArrayList<FRoleinfo>();
        for (Map.Entry<String, FRoleinfo> ent : CodeRepositoryManager.ROLEREPO.entrySet()) {
            FRoleinfo value = ent.getValue();
            if (!value.getRolecode().startsWith(sPrefix) || !"T".equals(value.getIsvalid())) continue;
            roleList.add(value);
        }
        return roleList;
    }

    public static final List<FUserinfo> getAllUsers(String sState) {
        ArrayList<FUserinfo> users = new ArrayList<FUserinfo>();
        for (Map.Entry<String, FUserinfo> ent : CodeRepositoryManager.USERREPO.entrySet()) {
            FUserinfo value = ent.getValue();
            if (!"A".equals(sState) && !sState.equals(value.getIsvalid())) continue;
            users.add(value);
        }
        return users;
    }

    public static final List<FUserinfo> getSortedPrimaryUnitUsers(String unitCode) {
        ArrayList<FUserinfo> users = new ArrayList<FUserinfo>();
        FUnitinfo ui = CodeRepositoryManager.UNITREPO.get(unitCode);
        for (FUserunit uu : ui.getSubUserUnits()) {
            FUserinfo user;
            if (!"T".equals(uu.getIsprimary()) || (user = CodeRepositoryManager.USERREPO.get(uu.getUsercode())) == null || !"T".equals(user.getIsvalid()) || users.contains(user)) continue;
            users.add(user);
        }
        Collections.sort(users, new Comparator<FUserinfo>(){

            @Override
            public int compare(FUserinfo o1, FUserinfo o2) {
                if (o1.getUserorder() > o2.getUserorder()) {
                    return 1;
                }
                return 0;
            }
        });
        return users;
    }

    public static final List<FUserinfo> getSortedUnitUsers(String unitCode) {
        ArrayList<FUserinfo> users = new ArrayList<FUserinfo>();
        FUnitinfo ui = CodeRepositoryManager.UNITREPO.get(unitCode);
        for (FUserunit uu : ui.getSubUserUnits()) {
            FUserinfo user = CodeRepositoryManager.USERREPO.get(uu.getUsercode());
            if (user == null || !"T".equals(user.getIsvalid()) || users.contains(user)) continue;
            users.add(user);
        }
        Collections.sort(users, new Comparator<FUserinfo>(){

            @Override
            public int compare(FUserinfo o1, FUserinfo o2) {
                if (o1.getUserorder() > o2.getUserorder()) {
                    return 1;
                }
                return 0;
            }
        });
        return users;
    }

    public static final List<FUnitinfo> getSortedSubUnits(String unitCode, String unitType) {
        ArrayList<FUnitinfo> units = new ArrayList<FUnitinfo>();
        FUnitinfo ui = CodeRepositoryManager.UNITREPO.get(unitCode);
        for (String uu : ui.getSubUnits()) {
            FUnitinfo unit = CodeRepositoryManager.UNITREPO.get(uu);
            if (unit == null || !"T".equals(unit.getIsvalid()) || unitType != null && !"A".equals(unitType) && unitType.indexOf(unit.getUnittype()) < 0) continue;
            units.add(unit);
        }
        Collections.sort(units, new Comparator<FUnitinfo>(){

            @Override
            public int compare(FUnitinfo o1, FUnitinfo o2) {
                if (o1.getUnitorder() > o2.getUnitorder()) {
                    return 1;
                }
                return 0;
            }
        });
        return units;
    }

    public static final Set<FUserinfo> getUnitUsers(String unitCode) {
        HashSet<FUserinfo> users = new HashSet<FUserinfo>();
        FUnitinfo ui = CodeRepositoryManager.UNITREPO.get(unitCode);
        for (FUserunit uu : ui.getSubUserUnits()) {
            FUserinfo user = CodeRepositoryManager.USERREPO.get(uu.getUsercode());
            if (user == null || !"T".equals(user.getIsvalid())) continue;
            users.add(user);
        }
        return users;
    }

    public static final FUserinfo getUserInfoByCode(String userCode) {
        return CodeRepositoryManager.USERREPO.get(userCode);
    }

    public static final Integer getUserUnitXzRank(String userCode, String unitCode) {
        String rankUnitCode;
        if (userCode == null) {
            return MAXXZRANK;
        }
        FUserinfo ui = CodeRepositoryManager.USERREPO.get(userCode);
        if (ui == null) {
            return MAXXZRANK;
        }
        String string = rankUnitCode = unitCode == null ? ui.getPrimaryUnit() : unitCode;
        if (rankUnitCode == null || "".equals(rankUnitCode)) {
            return MAXXZRANK;
        }
        FUnitinfo unit = CodeRepositoryManager.UNITREPO.get(rankUnitCode);
        if (unit == null) {
            return MAXXZRANK;
        }
        int nRank = MAXXZRANK;
        for (FUserunit uu : unit.getSubUserUnits()) {
            if (!userCode.equals(uu.getUsercode()) || uu.getXzRank() >= nRank) continue;
            nRank = uu.getXzRank();
        }
        return nRank;
    }

    public static final List<FUserinfo> searchUser(String sPinyin) {
        String sPY = sPinyin.toLowerCase().trim();
        ArrayList<FUserinfo> users = new ArrayList<FUserinfo>();
        for (Map.Entry<String, FUserinfo> ent : CodeRepositoryManager.USERREPO.entrySet()) {
            FUserinfo value = ent.getValue();
            String sUserPY = value.getUsernamepinyin();
            if (!value.getIsvalid().equals("T") || (sUserPY == null || !sUserPY.startsWith(sPY)) && !value.getLoginname().startsWith(sPY) && !value.getUsercode().startsWith(sPY)) continue;
            users.add(value);
        }
        return users;
    }

    public static final Map<String, FUnitinfo> getUnitMapByParaent(String sParentUnit) {
        HashMap<String, FUnitinfo> units = new HashMap<String, FUnitinfo>();
        for (Map.Entry<String, FUnitinfo> ent : CodeRepositoryManager.UNITREPO.entrySet()) {
            FUnitinfo value = ent.getValue();
            if (!value.getIsvalid().equals("T") || !sParentUnit.equals(value.getParentunit())) continue;
            units.put(ent.getKey(), value);
        }
        return units;
    }

    public static final FUnitinfo getUnitInfoByCode(String sUnit) {
        return CodeRepositoryManager.UNITREPO.get(sUnit);
    }

    public static final List<FUnitinfo> getAllUnits(String sState) {
        ArrayList<FUnitinfo> units = new ArrayList<FUnitinfo>();
        for (Map.Entry<String, FUnitinfo> entry : CodeRepositoryManager.UNITREPO.entrySet()) {
            FUnitinfo unit = entry.getValue();
            if (!"A".equals(sState) && !sState.equals(unit.getIsvalid())) continue;
            units.add(unit);
        }
        return units;
    }

    public static final Map<String, FUnitinfo> getAllUnitMapByParaent(String sParentUnit) {
        HashMap<String, FUnitinfo> units = new HashMap<String, FUnitinfo>();
        for (Map.Entry<String, FUnitinfo> ent : CodeRepositoryManager.UNITREPO.entrySet()) {
            FUnitinfo value = ent.getValue();
            if (!sParentUnit.equals(value.getParentunit())) continue;
            units.put(ent.getKey(), value);
        }
        return units;
    }

    public static final Map<String, FUnitinfo> getUnitMapBuyParaentRecurse(String sParentUnit) {
        HashMap<String, FUnitinfo> units = new HashMap<String, FUnitinfo>();
        ArrayList<String> sParentUnits = new ArrayList<String>();
        ArrayList<String> sNewUnits = new ArrayList<String>();
        sParentUnits.add(sParentUnit);
        while (sParentUnits.size() > 0) {
            sNewUnits.clear();
            for (int i = 0; i < sParentUnits.size(); ++i) {
                String sPNC = (String)sParentUnits.get(i);
                for (Map.Entry<String, FUnitinfo> ent : CodeRepositoryManager.UNITREPO.entrySet()) {
                    FUnitinfo value = ent.getValue();
                    if (!value.getIsvalid().equals("T") || !sPNC.equals(value.getParentunit())) continue;
                    units.put(ent.getKey(), value);
                    sNewUnits.add(ent.getKey());
                }
            }
            ArrayList<String> tempList = sParentUnits;
            sParentUnits = sNewUnits;
            sNewUnits = tempList;
        }
        return units;
    }

    public static final List<FDatadictionary> getDictionary(String sCatalog) {
        return CodeRepositoryManager.REPOSITORIES.get(sCatalog);
    }

    public static final String getDictionaryAsJson(String sCatalog) {
        List<FDatadictionary> lsDictionary = CodeRepositoryManager.REPOSITORIES.get(sCatalog);
        JSONArray jarray = new JSONArray();
        int i = 0;
        for (FDatadictionary dict : lsDictionary) {
            JSONObject jobj = new JSONObject();
            jobj.accumulate("id", (Object)dict.getDatacode());
            jobj.accumulate("pId", (Object)dict.getExtracode());
            jobj.accumulate("name", (Object)dict.getDatavalue());
            jobj.accumulate("t", (Object)dict.getDatavalue());
            jobj.accumulate("right", false);
            jarray.add(i, (Object)jobj);
            ++i;
        }
        return jarray.toString();
    }

    public static final List<LabelValueBean> getDataCatalog() {
        return CodeRepositoryManager.DATACATALOG;
    }

    public static final List<FDatadictionary> getDictionaryIgnoreD(String sCatalog) {
        ArrayList<FDatadictionary> dcRetMap = new ArrayList<FDatadictionary>();
        List<FDatadictionary> dcMap = CodeRepositoryManager.REPOSITORIES.get(sCatalog);
        if (dcMap != null) {
            for (FDatadictionary value : dcMap) {
                if (value.getDatatag().equals("D")) continue;
                dcRetMap.add(value);
            }
        }
        return dcRetMap;
    }

    public static final List<LabelValueBean> getLabelValueBeans(String sCatalog) {
        ArrayList<LabelValueBean> lbvs = new ArrayList<LabelValueBean>();
        if (sCatalog.equalsIgnoreCase("usercode")) {
            for (Map.Entry<String, FUserinfo> ent : CodeRepositoryManager.USERREPO.entrySet()) {
                FUserinfo value = ent.getValue();
                if (!"T".equals(value.getIsvalid())) continue;
                lbvs.add(new LabelValueBean(value.getUsername(), ent.getKey()));
            }
            return lbvs;
        }
        if (sCatalog.equalsIgnoreCase("unitcode")) {
            for (FUnitinfo value : CodeRepositoryManager.UNITASTREE) {
                if (!"T".equals(value.getIsvalid())) continue;
                lbvs.add(new LabelValueBean(value.getUnitname(), value.getUnitcode()));
            }
            return lbvs;
        }
        if (sCatalog.equalsIgnoreCase("depno")) {
            for (Map.Entry<String, FUnitinfo> ent : CodeRepositoryManager.DEPNO.entrySet()) {
                FUnitinfo value = ent.getValue();
                if (!"T".equals(value.getIsvalid())) continue;
                lbvs.add(new LabelValueBean(value.getUnitname(), ent.getKey()));
            }
            return lbvs;
        }
        if (sCatalog.equalsIgnoreCase("rolecode")) {
            for (Map.Entry<String, FRoleinfo> ent : CodeRepositoryManager.ROLEREPO.entrySet()) {
                FRoleinfo value = ent.getValue();
                if (!"T".equals(value.getIsvalid())) continue;
                lbvs.add(new LabelValueBean(value.getRolename(), ent.getKey()));
            }
            return lbvs;
        }
        if (sCatalog.equalsIgnoreCase("optid")) {
            for (Map.Entry<String, FOptinfo> ent : CodeRepositoryManager.OPTREPO.entrySet()) {
                FOptinfo value = ent.getValue();
                lbvs.add(new LabelValueBean(value.getOptname(), ent.getKey()));
            }
            return lbvs;
        }
        if (sCatalog.equalsIgnoreCase("optcode")) {
            for (Map.Entry<String, FOptdef> ent : CodeRepositoryManager.POWERREPO.entrySet()) {
                FOptdef value = ent.getValue();
                lbvs.add(new LabelValueBean(value.getOptname(), ent.getKey()));
            }
            return lbvs;
        }
        if (sCatalog.equalsIgnoreCase("optdesc")) {
            for (Map.Entry<String, FOptdef> ent : CodeRepositoryManager.POWERREPO.entrySet()) {
                FOptdef optdef = ent.getValue();
                FOptinfo value = CodeRepositoryManager.OPTREPO.get(optdef.getOptid());
                lbvs.add(new LabelValueBean(value.getOptname() + "-" + optdef.getOptname(), ent.getKey()));
            }
            return lbvs;
        }
        List<FDatadictionary> dcMap = CodeRepositoryManager.REPOSITORIES.get(sCatalog);
        if (dcMap != null) {
            for (FDatadictionary value : dcMap) {
                if (value.getDatatag() == null || value.getDatatag().equals("D")) continue;
                lbvs.add(new LabelValueBean(value.getDatavalue(), value.getDatacode()));
            }
        }
        return lbvs;
    }

    public static final FDatadictionary getDataPiece(String sCatalog, String sKey) {
        List<FDatadictionary> dcList = CodeRepositoryManager.REPOSITORIES.get(sCatalog);
        if (dcList == null) {
            return null;
        }
        for (FDatadictionary fd : dcList) {
            if (!fd.getDatacode().equals(sKey)) continue;
            return fd;
        }
        return null;
    }

    public static final FDatadictionary getDataPieceByValue(String sCatalog, String sValue) {
        List<FDatadictionary> dcList = CodeRepositoryManager.REPOSITORIES.get(sCatalog);
        if (dcList == null) {
            return null;
        }
        for (FDatadictionary fd : dcList) {
            if (!fd.getDatavalue().equals(sValue)) continue;
            return fd;
        }
        return null;
    }

    public static final String getPrimaryUnit(String usercode) {
        FUserinfo userinfo = CodeRepositoryManager.USERREPO.get(usercode);
        return userinfo.getPrimaryUnit();
    }

    public static final String getUnitName(String unitCode) {
        FUnitinfo unitInfo = CodeRepositoryManager.DEPNO.get(unitCode);
        if (unitInfo == null) {
            return "";
        }
        return unitInfo.getUnitname();
    }

    public static final String getUnitListJSON() {
        JSONArray array = new JSONArray();
        for (Map.Entry<String, FUnitinfo> entry : CodeRepositoryManager.UNITREPO.entrySet()) {
            FUnitinfo unit = entry.getValue();
            if (!"T".equals(unit.getIsvalid())) continue;
            JSONObject obj = new JSONObject();
            obj.accumulate("unitcode", (Object)unit.getUnitcode());
            obj.accumulate("parentunit", (Object)unit.getParentunit());
            obj.accumulate("unitshortname", (Object)unit.getUnitshortname());
            obj.accumulate("depno", (Object)unit.getDepno());
            array.add((Object)obj);
        }
        return array.toString();
    }

    private static List<FUnitinfo> getSubUnits(FUnitinfo unit) {
        ArrayList<FUnitinfo> units = new ArrayList<FUnitinfo>();
        if (null == unit) {
            return units;
        }
        units.add(unit);
        Set<String> subUnitsCode = unit.getSubUnits();
        if (null != subUnitsCode && subUnitsCode.size() != 0) {
            for (String uc : subUnitsCode) {
                FUnitinfo temp = CodeRepositoryManager.UNITREPO.get(uc);
                if (temp == null || !"T".equals(temp.getIsvalid())) continue;
                units.addAll(CodeRepositoryUtil.getSubUnits(temp));
            }
        }
        return units;
    }

    public static final List<FUnitinfo> getUnitList(String unitcode) {
        ArrayList<FUnitinfo> units = new ArrayList<FUnitinfo>();
        if (!StringUtils.isBlank((String)unitcode)) {
            FUnitinfo ui = CodeRepositoryManager.UNITREPO.get(unitcode);
            if (null != ui) {
                units.addAll(CodeRepositoryUtil.getSubUnits(ui));
            }
        } else {
            for (Map.Entry<String, FUnitinfo> entry : CodeRepositoryManager.UNITREPO.entrySet()) {
                FUnitinfo unit = entry.getValue();
                if (!"T".equals(unit.getIsvalid())) continue;
                units.add(unit);
            }
        }
        Algorithm.ParentChild<FUnitinfo> c = new Algorithm.ParentChild<FUnitinfo>(){

            public boolean parentAndChild(FUnitinfo p, FUnitinfo c) {
                return p.getUnitcode().equals(c.getParentunit());
            }
        };
        Algorithm.sortAsTree(units, (Algorithm.ParentChild)c);
        return units;
    }

    public static final JSONObject getUnitsJson() {
        JSONObject result = new JSONObject();
        JSONArray city = new JSONArray();
        for (Map.Entry<String, FUnitinfo> ent : CodeRepositoryManager.UNITREPO.entrySet()) {
            FUnitinfo u = ent.getValue();
            JSONObject rs = new JSONObject();
            rs.put((Object)"MID", (Object)u.getUnitcode());
            rs.put((Object)"MText", (Object)u.getUnitname());
            rs.put((Object)"ParentID", (Object)u.getParentunit());
            city.add((Object)rs);
        }
        result.put((Object)"menuList", (Object)city);
        return result;
    }

    public static final Boolean checkUserOptPower(String optId, String optMethod) {
        Map<String, String> userOptList = ((FUserDetail)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserOptList();
        if (userOptList == null) {
            return false;
        }
        String s = userOptList.get(optId + "-" + optMethod);
        if (s == null) {
            return false;
        }
        return "T".equals(s);
    }
}

