/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service.impl;

import com.centit.core.dao.BaseDao;
import com.centit.core.service.BaseEntityManagerImpl;
import com.centit.support.utils.StringBaseOpt;
import com.centit.sys.dao.RoleInfoDao;
import com.centit.sys.po.FOptWithPower;
import com.centit.sys.po.FRoleinfo;
import com.centit.sys.po.FRolepower;
import com.centit.sys.po.FRolepowerId;
import com.centit.sys.po.VOptTree;
import com.centit.sys.service.SysRoleManager;
import java.util.ArrayList;
import java.util.List;

public class SysRoleManagerImpl
extends BaseEntityManagerImpl<FRoleinfo>
implements SysRoleManager {
    private static final long serialVersionUID = 1L;
    private RoleInfoDao sysroledao;

    public void setSysroleDao(RoleInfoDao roledao) {
        this.setBaseDao((BaseDao)roledao);
        this.sysroledao = roledao;
    }

    @Override
    public List<FRolepower> getRolePowers(String rolecode) {
        return this.sysroledao.getRolePowers(rolecode);
    }

    @Override
    public void saveRolePowers(List<FRolepower> rolePowers) {
        this.sysroledao.saveRolePowers(rolePowers);
    }

    @Override
    public List<VOptTree> getVOptTreeList() {
        return this.sysroledao.getVOptTreeList();
    }

    @Override
    public void saveRolePowers(String rolecode, String[] powerCodes) {
        ArrayList<FRolepower> rolePowers = new ArrayList<FRolepower>();
        if (powerCodes != null) {
            for (int i = 0; i < powerCodes.length; ++i) {
                if (StringBaseOpt.isNvl((String)powerCodes[i])) continue;
                FRolepower rp = new FRolepower(new FRolepowerId(rolecode, powerCodes[i].trim()));
                rolePowers.add(rp);
            }
            this.saveRolePowers(rolePowers);
        }
    }

    @Override
    public List<FOptWithPower> getOptWithPowerUnderUnit(String sUnitCode) {
        return this.sysroledao.getOptWithPowerUnderUnit(sUnitCode);
    }
}

