/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.action;

import com.centit.core.action.BaseEntityExtremeAction;
import com.centit.core.utils.ExtremeTableUtils;
import com.centit.core.utils.PageDesc;
import com.centit.support.utils.Algorithm;
import com.centit.sys.po.FOptWithPower;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FRoleinfo;
import com.centit.sys.po.FRolepower;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.security.CentitSecurityMetadata;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.CodeRepositoryUtil;
import com.centit.sys.service.FunctionManager;
import com.centit.sys.service.SysRoleManager;
import com.centit.sys.util.ISysOptLog;
import com.centit.sys.util.SysOptLogFactoryImpl;
import com.opensymphony.xwork2.Action;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.extremecomponents.table.limit.Limit;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleDefAction
extends BaseEntityExtremeAction<FRoleinfo>
implements ServletRequestAware,
Action {
    private static final long serialVersionUID = 1L;
    private SysRoleManager sysRoleManager;
    private CodeRepositoryManager codeRepositoryManager;
    private CentitSecurityMetadata roleSecurityMetadata;
    private List<FOptinfo> fOptinfos;
    private List<FOptWithPower> fOptPowers;
    private static final ISysOptLog SYS_OPT_LOG = SysOptLogFactoryImpl.getSysOptLog("ROLEMAG");
    private Map<String, String> powerlist;
    private String isPublic;

    public void setFunctionManager(FunctionManager functionManager) {
    }

    public void setFOptinfos(List<FOptinfo> fOptinfos) {
        this.fOptinfos = fOptinfos;
    }

    public List<FOptinfo> getFOptinfos() {
        return this.fOptinfos;
    }

    public List<FOptWithPower> getAllPowers() {
        return this.fOptPowers;
    }

    public void setAllPowers(List<FOptWithPower> ops) {
        this.fOptPowers = ops;
    }

    public SysRoleManager getSysRoleManager() {
        return this.sysRoleManager;
    }

    public void setSysRoleManager(SysRoleManager sysRoleManager) {
        this.sysRoleManager = sysRoleManager;
        this.setBaseEntityManager(sysRoleManager);
    }

    public void setRoleSecurityMetadata(CentitSecurityMetadata roleSecurityMetadata) {
        this.roleSecurityMetadata = roleSecurityMetadata;
    }

    public void setCodeRepositoryManager(CodeRepositoryManager codeRepositoryManager) {
        this.codeRepositoryManager = codeRepositoryManager;
    }

    public Map<String, String> getPowerlist() {
        return this.powerlist;
    }

    public void setPowerlist(Map<String, String> powerlist) {
        this.powerlist = powerlist;
    }

    public String list() {
        try {
            Map filterMap = this.convertSearchColumn(this.request.getParameterMap());
            filterMap.put("PROLECODE", "G-%");
            Limit limit = ExtremeTableUtils.getLimit((HttpServletRequest)this.request);
            PageDesc pageDesc = ExtremeTableUtils.makePageDesc((Limit)limit);
            this.objList = this.baseEntityManager.listObjects(filterMap, pageDesc);
            this.totalRows = pageDesc.getTotalRows();
            return "list";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String edit() {
        try {
            FRoleinfo ri = (FRoleinfo)this.sysRoleManager.getObjectById((Serializable)((Object)((FRoleinfo)this.object).getRolecode()));
            if (ri != null) {
                ((FRoleinfo)this.object).copyNotNullProperty(ri);
            }
            this.powerlist = new HashMap<String, String>();
            List<FRolepower> pls = this.sysRoleManager.getRolePowers(((FRoleinfo)this.object).getRolecode());
            for (FRolepower p : pls) {
                this.powerlist.put(p.getOptcode(), "1");
            }
            this.fOptinfos = CodeRepositoryUtil.getOptinfoList("P");
            return "edit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    private String getOptIndex(List<Integer> optIndex) {
        JSONObject jo = new JSONObject();
        jo.put((Object)"indexes", optIndex);
        return jo.toString();
    }

    public String newEdit() {
        FRoleinfo ri = (FRoleinfo)this.sysRoleManager.getObjectById((Serializable)((Object)((FRoleinfo)this.object).getRolecode()));
        if (ri != null) {
            ((FRoleinfo)this.object).copyNotNullProperty(ri);
            if (ri.getRolecode() != null && ri.getRolecode().startsWith("P-")) {
                this.isPublic = "T";
            }
        }
        this.powerlist = new HashMap<String, String>();
        List<FRolepower> pls = this.sysRoleManager.getRolePowers(((FRoleinfo)this.object).getRolecode());
        for (FRolepower p : pls) {
            this.powerlist.put(p.getOptcode(), "1");
        }
        this.fOptinfos = CodeRepositoryUtil.getOptinfoList("R");
        Algorithm.ParentChild<FOptinfo> c = new Algorithm.ParentChild<FOptinfo>(){

            public boolean parentAndChild(FOptinfo p, FOptinfo c) {
                return p.getOptid().equals(c.getPreoptid());
            }
        };
        Algorithm.sortAsTree(this.fOptinfos, (Algorithm.ParentChild)c);
        List optIndex = Algorithm.makeJqueryTreeIndex(this.fOptinfos, (Algorithm.ParentChild)c);
        ServletActionContext.getContext().put("INDEX", (Object)this.getOptIndex(optIndex));
        return "newEdit";
    }

    public String save() {
        try {
            if (!StringUtils.hasText((String)((FRoleinfo)this.object).getOptcodelist())) {
                return "error";
            }
            String[] optcodelist = ((FRoleinfo)this.object).getOptcodelist().split(",");
            if (0 == optcodelist.length) {
                return "error";
            }
            if (((FRoleinfo)this.object).getRolecode() == null) {
                return "edit";
            }
            if ("T".equals(this.isPublic) && !((FRoleinfo)this.object).getRolecode().startsWith("P-") && !((FRoleinfo)this.object).getRolecode().startsWith("G-")) {
                ((FRoleinfo)this.object).setRolecode("P-" + ((FRoleinfo)this.object).getRolecode());
            }
            if (!("T".equals(this.isPublic) || ((FRoleinfo)this.object).getRolecode().startsWith("G-") || ((FRoleinfo)this.object).getRolecode().startsWith("P-"))) {
                ((FRoleinfo)this.object).setRolecode("G-" + ((FRoleinfo)this.object).getRolecode());
            }
            if (((FRoleinfo)this.object).getIsvalid() == null) {
                ((FRoleinfo)this.object).setIsvalid("T");
            }
            try {
                FRoleinfo dbObject = (FRoleinfo)this.sysRoleManager.getObject(this.object);
                if (dbObject != null) {
                    dbObject.copyNotNullProperty((FRoleinfo)this.object);
                    this.object = dbObject;
                }
                this.sysRoleManager.saveObject(this.object);
                this.sysRoleManager.saveRolePowers(((FRoleinfo)this.object).getRolecode(), optcodelist);
                this.codeRepositoryManager.refresh("rolecode");
                this.roleSecurityMetadata.loadRoleSecurityMetadata();
                this.savedMessage();
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FRoleinfo)this.object).getRolecode(), ((FRoleinfo)this.object).display(), dbObject != null ? dbObject.display() : "");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "edit";
            }
            return "success";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String delete() {
        try {
            try {
                this.object = this.sysRoleManager.getObjectById((Serializable)((Object)((FRoleinfo)this.object).getRolecode()));
                this.sysRoleManager.disableObject(this.object);
                this.codeRepositoryManager.refresh("rolecode");
                this.roleSecurityMetadata.loadRoleSecurityMetadata();
                this.deletedMessage();
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FRoleinfo)this.object).getRolecode(), "\u7981\u7528\u89d2\u8272\u5b9a\u4e49 [" + ((FRoleinfo)this.object).getRolename() + "]");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "edit";
            }
            return "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(String isPublic) {
        this.isPublic = isPublic;
    }

    public String renew() {
        SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FRoleinfo)this.object).getRolecode(), "\u542f\u7528\u89d2\u8272\u5b9a\u4e49 [" + CodeRepositoryUtil.getValue("rolecode", ((FRoleinfo)this.object).getRolecode()) + "]");
        super.renew();
        return "delete";
    }
}

