/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.action;

import com.centit.core.action.BaseEntityExtremeAction;
import com.centit.core.utils.ExtremeTableUtils;
import com.centit.core.utils.PageDesc;
import com.centit.sys.po.FDatadictionary;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserPwd;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserrole;
import com.centit.sys.po.FUserroleId;
import com.centit.sys.po.FUserunit;
import com.centit.sys.po.FUserunitId;
import com.centit.sys.security.CaptchaImageUtil;
import com.centit.sys.security.FUserDetail;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.CodeRepositoryUtil;
import com.centit.sys.service.SysUnitManager;
import com.centit.sys.service.SysUserManager;
import com.centit.sys.util.ISysOptLog;
import com.centit.sys.util.SysOptLogFactoryImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.extremecomponents.table.limit.Limit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefAction
extends BaseEntityExtremeAction<FUserinfo>
implements ServletResponseAware {
    private static final long serialVersionUID = 1L;
    public static final Log log = LogFactory.getLog(UserDefAction.class);
    private static final ISysOptLog SYS_OPT_LOG = SysOptLogFactoryImpl.getSysOptLog("USERMAG");
    private SysUserManager sysUserMgr;
    private SysUnitManager sysUnitManager;
    private String casHome;
    private CodeRepositoryManager codeRepositoryManager;
    private FUserPwd userPwd;
    private List<FUserrole> userroles;
    private List<FUserunit> userunits;
    private String unitsJson;
    private String norejsp;
    private String resetUsers;
    public Integer uu_totalRows;
    public Integer ur_totalRows;
    public FUserrole userrole;
    private Date obtaindate;
    private FUserunit userUnit;
    private List<FUnitinfo> unitList;
    private InputStream inputStream;
    protected HttpServletResponse response;

    public void setCasHome(String casHome) {
        this.casHome = casHome;
    }

    public void setSysUnitManager(SysUnitManager sysUnitManager) {
        this.sysUnitManager = sysUnitManager;
    }

    public List<FUserrole> getUserroles() {
        return this.userroles;
    }

    public void setUserroles(List<FUserrole> userroles) {
        this.userroles = userroles;
    }

    public SysUserManager getSysUserMgr() {
        return this.sysUserMgr;
    }

    public void setUserunits(List<FUserunit> userunits) {
        this.userunits = userunits;
    }

    public List<FUserunit> getUserunits() {
        return this.userunits;
    }

    public void setSysUserMgr(SysUserManager sysUserMgr) {
        this.sysUserMgr = sysUserMgr;
        this.setBaseEntityManager(sysUserMgr);
    }

    public FUserPwd getUserPwd() {
        if (this.userPwd == null) {
            this.userPwd = new FUserPwd();
        }
        return this.userPwd;
    }

    public void setUserPwd(FUserPwd userPwd) {
        this.userPwd = userPwd;
    }

    public void setCodeRepositoryManager(CodeRepositoryManager codeRepositoryManager) {
        this.codeRepositoryManager = codeRepositoryManager;
    }

    public void setSysuserMgr(SysUserManager sysuserMagr) {
        this.sysUserMgr = sysuserMagr;
        this.setBaseEntityManager(sysuserMagr);
    }

    public void modifyPwd() throws IOException {
        FUserinfo loginUser = (FUserinfo)this.getLoginUser();
        if (null != loginUser) {
            ServletActionContext.getResponse().sendRedirect(this.casHome + "/support/sys/userinfo/toChangePwd");
        }
    }

    public String getUsers() {
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            PrintWriter out = response.getWriter();
            out.print(this.sysUserMgr.getJSONUsers());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getUnits() {
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            PrintWriter out = response.getWriter();
            out.print(this.sysUnitManager.getAllUnitsJSON());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getNorejsp() {
        return this.norejsp;
    }

    public void setNorejsp(String norejsp) {
        this.norejsp = norejsp;
    }

    public String resetpwd() {
        try {
            this.sysUserMgr.resetPwd(((FUserinfo)this.object).getUsercode());
            this.savedMessage();
            if ("1".equals(this.norejsp)) {
                return this.pwdlist();
            }
            return "edit";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String pwdlist() {
        try {
            Map paramMap = this.request.getParameterMap();
            this.resetPageParam(paramMap);
            Map filterMap = this.convertSearchColumn(paramMap);
            Limit limit = ExtremeTableUtils.getLimit((HttpServletRequest)this.request);
            PageDesc pageDesc = ExtremeTableUtils.makePageDesc((Limit)limit);
            this.objList = this.baseEntityManager.listObjects(filterMap, pageDesc);
            this.totalRows = pageDesc.getTotalRows();
            return "pwdlist";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String getResetUsers() {
        return this.resetUsers;
    }

    public void setResetUsers(String resetUsers) {
        this.resetUsers = resetUsers;
    }

    public String resetpwds() {
        if (!this.resetUsers.isEmpty()) {
            String[] ar;
            for (String a : ar = this.resetUsers.split(",")) {
                this.sysUserMgr.resetPwd(a);
            }
        }
        return this.pwdlist();
    }

    public Integer getUr_totalRows() {
        return this.ur_totalRows;
    }

    public void setUr_totalRows(Integer ur_totalRows) {
        this.ur_totalRows = ur_totalRows;
    }

    public Integer getUu_totalRows() {
        return this.uu_totalRows;
    }

    public void setUu_totalRows(Integer uu_totalRows) {
        this.uu_totalRows = uu_totalRows;
    }

    public String view() {
        try {
            FUserinfo ri = (FUserinfo)this.sysUserMgr.getObjectById((Serializable)((Object)((FUserinfo)this.object).getUsercode()));
            if (ri != null) {
                ((FUserinfo)this.object).copyNotNullProperty(ri);
            }
            this.userunits = this.sysUserMgr.getSysUnitsByUserId(((FUserinfo)this.object).getUsercode());
            this.uu_totalRows = this.userunits.size();
            this.userroles = this.sysUserMgr.getAllUserRoles(((FUserinfo)this.object).getUsercode(), "G-");
            List<FUserrole> list = this.sysUserMgr.getAllUserRoles(((FUserinfo)this.object).getUsercode(), "P-");
            if (list != null) {
                this.userroles.addAll(list);
            }
            this.ur_totalRows = this.userroles.size();
            return "view";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String viewUnderUnit() {
        try {
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserMgr.getUserPrimaryUnit(user.getUsercode());
            FUserinfo ri = (FUserinfo)this.sysUserMgr.getObjectById((Serializable)((Object)((FUserinfo)this.object).getUsercode()));
            if (ri != null) {
                ((FUserinfo)this.object).copyNotNullProperty(ri);
            }
            this.userunits = this.sysUserMgr.getSysUnitsByUserId(((FUserinfo)this.object).getUsercode());
            this.uu_totalRows = this.userunits.size();
            this.userroles = this.sysUserMgr.getAllUserRoles(((FUserinfo)this.object).getUsercode(), dept.getUnitcode() + "-");
            List<FUserrole> list = this.sysUserMgr.getAllUserRoles(((FUserinfo)this.object).getUsercode(), "P-");
            if (list != null) {
                this.userroles.addAll(list);
            }
            this.ur_totalRows = this.userroles.size();
            return "viewUnderUnit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public FUserrole getUserrole() {
        return this.userrole;
    }

    public void setUserrole(FUserrole userrole) {
        this.userrole = userrole;
    }

    public Date getObtaindate() {
        return this.obtaindate;
    }

    public void setObtaindate(Date obtaindate) {
        this.obtaindate = obtaindate;
    }

    public String bulitUserRole() {
        try {
            FUserroleId id = new FUserroleId();
            id.setUsercode(((FUserinfo)this.object).getUsercode());
            id.setObtaindateToToday();
            this.userrole = new FUserrole();
            this.userrole.setId(id);
            return "editUserRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String editUserRole() {
        try {
            FUserroleId id = new FUserroleId();
            id.setUsercode(((FUserinfo)this.object).getUsercode());
            id.setRolecode(this.userrole.getRolecode());
            id.setObtaindate(this.obtaindate);
            this.userrole = this.sysUserMgr.getFUserroleByID(id);
            if (this.userrole == null) {
                this.userrole = new FUserrole();
                id.setObtaindateToToday();
                this.userrole.setId(id);
            }
            return "editUserRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String saveUserRole() {
        try {
            String oldValue = null;
            FUserrole desobj = this.sysUserMgr.getValidUserrole(this.userrole.getUsercode(), this.userrole.getRolecode());
            this.userrole.setObtaindateToToday();
            if (desobj != null) {
                oldValue = desobj.display();
                desobj.copyNotNullProperty(this.userrole);
                this.userrole = desobj;
            }
            try {
                this.sysUserMgr.saveUserrole(this.userrole);
                this.savedMessage();
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), this.userrole.getId().toString(), this.userrole.display(), oldValue);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "editUserRole";
            }
            return "saveUserRole";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String deleteUserRole() {
        try {
            FUserroleId id = new FUserroleId();
            id.setUsercode(this.userrole.getUsercode());
            id.setRolecode(this.userrole.getRolecode());
            id.setObtaindate(this.obtaindate);
            log.debug((Object)this.userrole.getRolecode());
            id.setRolecode(this.userrole.getRolecode());
            this.sysUserMgr.deleteUserrole(id);
            this.deletedMessage();
            String optContent = "\u5220\u9664\u7528\u6237 [" + CodeRepositoryUtil.getValue("usercode", this.userrole.getUsercode()) + " ] \u89d2\u8272 [" + CodeRepositoryUtil.getValue("rolecode", this.userrole.getRolecode()) + " ]";
            SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), id.toString(), optContent, this.userrole.display());
            return "saveUserRole";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String addUserUnit() {
        this.userUnit = new FUserunit();
        this.userUnit.setUsercode(((FUserinfo)this.object).getUsercode());
        this.unitsJson = this.sysUnitManager.getAllUnitsJSON();
        return "editUserUnit";
    }

    public String addUserUnderUnit() {
        FUserDetail user = (FUserDetail)this.getLoginUser();
        FUserunit dept = this.sysUserMgr.getUserPrimaryUnit(user.getUsercode());
        this.userUnit = new FUserunit();
        this.userUnit.setUsercode(((FUserinfo)this.object).getUsercode());
        if (dept != null) {
            this.unitList = this.sysUnitManager.getAllSubUnits(dept.getUnitcode());
            this.userUnit.setUnitcode(dept.getUnitcode());
        }
        this.unitsJson = this.sysUnitManager.getAllUnitsJSON();
        return "editUserUnit";
    }

    public String editUserUnit() {
        try {
            FUserunitId id = new FUserunitId();
            id.setUsercode(this.userUnit.getUsercode());
            id.setUnitcode(this.userUnit.getUnitcode());
            id.setUserrank(this.userUnit.getUserrank());
            id.setUserstation(this.userUnit.getUserstation());
            this.userUnit = this.sysUserMgr.findUserUnitById(id);
            if (this.userUnit == null) {
                this.userUnit = new FUserunit();
                this.userUnit.setId(id);
            }
            this.unitsJson = this.sysUnitManager.getAllUnitsJSON();
            return "editUserUnit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String saveUserUnit() {
        try {
            FUserunitId id = new FUserunitId();
            id.setUsercode(this.userUnit.getUsercode());
            id.setUnitcode(this.userUnit.getUnitcode());
            id.setUserrank(this.userUnit.getUserrank());
            id.setUserstation(this.userUnit.getUserstation());
            FUserunit dbobject = this.sysUserMgr.findUserUnitById(id);
            if (dbobject != null) {
                dbobject.copyNotNullProperty(this.userUnit);
                this.userUnit = dbobject;
            }
            try {
                String oldValue = this.userUnit.display();
                this.sysUserMgr.saveUserUnit(this.userUnit);
                this.savedMessage();
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), id.toString(), "\u5c97\u4f4d\u89d2\u8272\u5b9a\u4e49\u5220\u9664 [" + CodeRepositoryUtil.getValue("usercode", this.userUnit.getUsercode()) + "] ", oldValue);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "editUserUnit";
            }
            return "saveUserUnit";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String deleteUserUnit() {
        try {
            FUserunitId id = new FUserunitId();
            id.setUsercode(this.userUnit.getUsercode());
            id.setUnitcode(this.userUnit.getUnitcode());
            id.setUserrank(this.userUnit.getUserrank());
            id.setUserstation(this.userUnit.getUserstation());
            this.sysUserMgr.deleteUserUnit(id);
            this.deletedMessage();
            return "saveUserUnit";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String delete() {
        try {
            try {
                this.object = this.sysUserMgr.getObjectById((Serializable)((Object)((FUserinfo)this.object).getUsercode()));
                this.sysUserMgr.disableObject(this.object);
                this.codeRepositoryManager.refresh("usercode");
                this.deletedMessage();
                String underUnit = this.request.getParameter("underUnit");
                this.deletedMessage();
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FUserinfo)this.object).getUsercode(), "\u7981\u7528\u7528\u6237 [" + ((FUserinfo)this.object).getUsername() + " ]");
                if (underUnit == null) {
                    return "success";
                }
                return "underUnit";
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "edit";
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "error";
        }
    }

    public String built() {
        try {
            this.object = new FUserinfo();
            ((FUserinfo)this.object).setUsercode(this.sysUserMgr.getNextUserCode('S'));
            this.userUnit = new FUserunit();
            this.unitsJson = this.sysUnitManager.getAllUnitsJSON();
            return "edit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String listUserInfo() {
        try {
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserMgr.getUserPrimaryUnit(user.getUsercode());
            if (dept != null) {
                Map paramMap = this.request.getParameterMap();
                this.resetPageParam(paramMap);
                Map filterMap = this.convertSearchColumn(paramMap);
                if ("thisunit".equals(filterMap.get("byUnderUnit"))) {
                    filterMap.put("byUnderUnit", dept.getUnitcode());
                    filterMap.remove("queryUnderUnit");
                }
                if ("true".equals(filterMap.get("queryUnderUnit"))) {
                    filterMap.put("queryUnderUnit", dept.getUnitcode());
                    filterMap.remove("byUnderUnit");
                }
                filterMap.put("order", "");
                Limit limit = ExtremeTableUtils.getLimit((HttpServletRequest)this.request);
                PageDesc pageDesc = ExtremeTableUtils.makePageDesc((Limit)limit);
                this.objList = this.sysUserMgr.listUnderUnit(filterMap, pageDesc);
                this.totalRows = pageDesc.getTotalRows();
                this.unitList = this.sysUnitManager.getAllSubUnits(dept.getUnitcode());
                this.userUnit = new FUserunit();
                this.userUnit.setUnitcode(dept.getUnitcode());
            }
            return "listUserInfo";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public List<FUnitinfo> getUnitList() {
        return this.unitList;
    }

    public void setUnitList(List<FUnitinfo> unitList) {
        this.unitList = unitList;
    }

    public String builtUnderUnit() {
        FUserDetail user = (FUserDetail)this.getLoginUser();
        FUserunit dept = this.sysUserMgr.getUserPrimaryUnit(user.getUsercode());
        ((FUserinfo)this.object).setUsercode(this.sysUserMgr.getNextUserCode('S'));
        if (dept != null) {
            this.unitList = this.sysUnitManager.getAllSubUnits(dept.getUnitcode());
            this.userUnit = new FUserunit();
            this.userUnit.setUnitcode(dept.getUnitcode());
        }
        return "edit";
    }

    public String list() {
        this.unitsJson = this.sysUnitManager.getAllUnitsJSON();
        return super.list();
    }

    public String edit() {
        try {
            FUserinfo dbobject;
            if (this.object != null && (dbobject = (FUserinfo)this.sysUserMgr.getObjectById((Serializable)((Object)((FUserinfo)this.object).getUsercode()))) != null) {
                this.sysUserMgr.copyObjectNotNullProperty(this.object, dbobject);
                this.userUnit = this.sysUserMgr.getUserPrimaryUnit(((FUserinfo)this.object).getUsercode());
            }
            this.unitsJson = this.sysUnitManager.getAllUnitsJSON();
            return "edit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String editUnderUnit() {
        try {
            FUserinfo dbobject;
            if (this.object != null && (dbobject = (FUserinfo)this.sysUserMgr.getObjectById((Serializable)((Object)((FUserinfo)this.object).getUsercode()))) != null) {
                this.sysUserMgr.copyObjectNotNullProperty(this.object, dbobject);
                this.userUnit = this.sysUserMgr.getUserPrimaryUnit(((FUserinfo)this.object).getUsercode());
                this.request.setAttribute("underUnit", (Object)"T");
            }
            return "edit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String saveUnderUnit() {
        try {
            FUserinfo dbobject = (FUserinfo)this.sysUserMgr.getObjectById((Serializable)((Object)((FUserinfo)this.object).getUsercode()));
            if (dbobject != null) {
                this.sysUserMgr.copyObjectNotNullProperty(dbobject, this.object);
                this.object = dbobject;
            }
            this.userUnit.setUsercode(((FUserinfo)this.object).getUsercode());
            this.userUnit.setIsprimary("T");
            FUserunit dbuserunit = this.sysUserMgr.findUserUnitById(this.userUnit.getId());
            if (dbuserunit != null) {
                dbuserunit.copyNotNullProperty(this.userUnit);
                this.userUnit = dbuserunit;
            }
            this.sysUserMgr.saveObject(this.object);
            this.sysUserMgr.saveUserUnit(this.userUnit);
            return "underUnit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String save() {
        String optContent = null;
        String oldValue = null;
        try {
            FUserinfo dbobject = (FUserinfo)this.sysUserMgr.getObjectById((Serializable)((Object)((FUserinfo)this.object).getUsercode()));
            if (dbobject != null) {
                this.sysUserMgr.copyObjectNotNullProperty(dbobject, this.object);
                this.object = dbobject;
            }
            this.userUnit.setUsercode(((FUserinfo)this.object).getUsercode());
            this.userUnit.setIsprimary("T");
            FUserunit dbuserunit = this.sysUserMgr.findUserUnitById(this.userUnit.getId());
            if (dbuserunit != null) {
                oldValue = dbuserunit.display();
                dbuserunit.copyNotNullProperty(this.userUnit);
                this.userUnit = dbuserunit;
            }
            this.sysUserMgr.saveObject(this.object);
            this.sysUserMgr.saveUserUnit(this.userUnit);
            optContent = ((FUserinfo)this.object).display() + "  " + this.userUnit.display();
            this.codeRepositoryManager.refresh("usercode");
            SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FUserinfo)this.object).getUsercode(), optContent, oldValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.savedMessage();
        String underUnit = this.request.getParameter("underUnit");
        if (underUnit == null) {
            return "success";
        }
        return "underUnit";
    }

    public String modifyPwdPage() {
        this.getUserPwd();
        FUserDetail ui = (FUserDetail)this.getLoginUser();
        this.userPwd.setLoginname(ui.getLoginname());
        return "modifyPwdPage";
    }

    public String modifypwd() {
        try {
            FUserDetail ui = (FUserDetail)this.getLoginUser();
            if (!this.userPwd.getNewPassword().equals(this.userPwd.getConfirmPassword())) {
                this.saveMessage("\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
                return "diverror";
            }
            this.sysUserMgr.setNewPassword(ui.getUsercode(), this.userPwd.getOldPassword(), this.userPwd.getNewPassword());
            this.postAlertMessage("\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff01", this.response);
            return null;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            this.saveMessage(ee.getMessage());
            return "diverror";
        }
    }

    public String registerpage() {
        this.getUserPwd();
        this.sysUserMgr.clearObjectProperties(this.object);
        this.userPwd.setLoginname("");
        return "registerPage";
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String captchaimage() {
        try {
            String checkcode = CaptchaImageUtil.getRandomString();
            this.request.getSession().setAttribute(CaptchaImageUtil.SESSIONCHECKCODE, (Object)checkcode);
            BufferedImage img = CaptchaImageUtil.generateCaptchaImage(checkcode);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "gif", out);
            byte[] bbuf = out.toByteArray();
            this.setInputStream(new ByteArrayInputStream(bbuf));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "captchaimage";
    }

    public String register() {
        boolean validCaptcha;
        String session_checkcode = this.request.getSession().getAttribute(CaptchaImageUtil.SESSIONCHECKCODE).toString();
        String request_checkcode = this.request.getParameter(CaptchaImageUtil.REQUESTCHECKCODE).toString();
        boolean bl = validCaptcha = session_checkcode != null && session_checkcode.equalsIgnoreCase(request_checkcode);
        if (!validCaptcha) {
            this.saveError("\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
            return "diverror";
        }
        if (!this.userPwd.getNewPassword().equals(this.userPwd.getConfirmPassword())) {
            this.saveMessage("\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
            return "diverror";
        }
        this.userPwd.setLoginname(((FUserinfo)this.object).getLoginname());
        String pwd = this.userPwd.getNewPassword();
        String sUC = this.sysUserMgr.getNextUserCode('W');
        ((FUserinfo)this.object).setUsercode(sUC);
        ((FUserinfo)this.object).setUserpin(this.sysUserMgr.encodePassword(pwd, sUC));
        ((FUserinfo)this.object).setIsvalid("T");
        try {
            this.sysUserMgr.saveObject(this.object);
        }
        catch (Exception e) {
            this.saveError("\u60a8\u8f93\u5165\u767b\u5f55\u540d\u6216\u8005email\u5df2\u88ab\u522b\u4eba\u4f7f\u7528\uff01");
            return "diverror";
        }
        FDatadictionary dItem = CodeRepositoryUtil.getDataPiece("SYSPARAM", "EnableWebUsr");
        FUserrole userrole = new FUserrole();
        String sRC = dItem.getDatavalue();
        userrole.setUsercode(sUC);
        userrole.setRolecode(sRC);
        userrole.setObtaindateToToday();
        userrole.setSecededate(null);
        userrole.setChangedesc("\u7f51\u7edc\u6ce8\u518c\u7528\u6237\u81ea\u52a8\u8d4b\u4e88\u7684\u6743\u9650");
        this.sysUserMgr.saveUserrole(userrole);
        FUserunit uu = new FUserunit();
        String sUintC = dItem.getExtracode2();
        uu.setUnitcode(sUintC);
        uu.setUsercode(sUC);
        uu.setUserstation("WEB");
        uu.setIsprimary("T");
        this.sysUserMgr.saveUserUnit(uu);
        return "registerSuccess";
    }

    public String renew() {
        try {
            this.sysUserMgr.renewObject(this.object);
            String underUnit = this.request.getParameter("underUnit");
            SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FUserinfo)this.object).getUsercode(), "\u542f\u7528\u7528\u6237 [" + CodeRepositoryUtil.getValue("usercode", ((FUserinfo)this.object).getUsercode()) + " ]");
            if (underUnit == null) {
                return "success";
            }
            return "underUnit";
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            this.saveError(e.getMessage());
            return "edit";
        }
    }

    public FUserunit getUserUnit() {
        return this.userUnit;
    }

    public void setUserUnit(FUserunit userUnit) {
        this.userUnit = userUnit;
    }

    public String getUnitsJson() {
        return this.unitsJson;
    }

    public void setUnitsJson(String unitsJson) {
        this.unitsJson = unitsJson;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    protected void postAlertMessage(String msg, HttpServletResponse response) {
        String alertCoding = "GBK";
        String str = "<script language=\"JavaScript\" type=\"text/JavaScript\" charset=\"" + alertCoding + "\">" + "javascript:alert('" + msg + "');history.back(-1);" + " </script>";
        response.setContentType("text/html; charset=" + alertCoding);
        try {
            ServletOutputStream sos = response.getOutputStream();
            int strSize = str.length();
            byte[] b = new byte[strSize];
            b = str.getBytes();
            sos.write(b);
            sos.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

