/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.security;

import com.centit.core.structs2.OptDesc;
import com.centit.core.structs2.Struts2UrlParser;
import com.centit.sys.dao.OptInfoDao;
import com.centit.sys.dao.OptRunRecDao;
import com.centit.sys.po.FOptRoleMap;
import com.centit.sys.security.CentitSecurityMetadata;
import com.centit.sys.security.RdbmsEntryHoder;
import com.centit.sys.service.CodeRepositoryUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource,
CentitSecurityMetadata {
    private static final Log log = LogFactory.getLog(DaoInvocationSecurityMetadataSource.class);
    private OptInfoDao functionDao;
    private OptRunRecDao optRecDao;
    private Date lastUpdateCadTime = null;
    Map<OptDesc, RdbmsEntryHoder> listEntryHoder = null;

    public void setFunctionDao(OptInfoDao sysfunlsdao) {
        this.functionDao = sysfunlsdao;
    }

    public void setOptRunRecDao(OptRunRecDao optRecDao) {
        this.optRecDao = optRecDao;
    }

    @Override
    public void loadRoleSecurityMetadata() {
        this.lastUpdateCadTime = new Date(System.currentTimeMillis());
        this.listEntryHoder = new HashMap<OptDesc, RdbmsEntryHoder>();
        List<FOptRoleMap> optrolemaps = this.functionDao.getAllOptRoleMap();
        RdbmsEntryHoder rsh = null;
        for (FOptRoleMap optrole : optrolemaps) {
            if (rsh == null || !rsh.matchOptRoleMap(optrole)) {
                if (rsh != null) {
                    RdbmsEntryHoder rsh2 = this.listEntryHoder.get(rsh.getOptDesc());
                    if (rsh2 == null) {
                        this.listEntryHoder.put(rsh.getOptDesc(), rsh);
                    } else {
                        rsh2.merge(rsh);
                    }
                }
                rsh = new RdbmsEntryHoder(optrole);
                continue;
            }
            rsh.addRole(optrole.getRolecode());
        }
        if (rsh != null) {
            RdbmsEntryHoder rsh2 = this.listEntryHoder.get(rsh.getOptDesc());
            if (rsh2 == null) {
                this.listEntryHoder.put(rsh.getOptDesc(), rsh);
            } else {
                rsh2.merge(rsh);
            }
        }
        log.info((Object)"\u7cfb\u7edf\u81ea\u52a8\u5237\u65b0\u89d2\u8272\u6743\u9650\u4fe1\u606f\u3002");
    }

    public Map<OptDesc, RdbmsEntryHoder> getRdbmsEntryHolderList() {
        if (this.lastUpdateCadTime != null && this.listEntryHoder != null && new Date(System.currentTimeMillis()).getTime() - this.lastUpdateCadTime.getTime() < 3600000L) {
            return this.listEntryHoder;
        }
        this.loadRoleSecurityMetadata();
        return this.listEntryHoder;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        Map<OptDesc, RdbmsEntryHoder> list;
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("\u5bf9\u4e0d\u8d77,\u76ee\u6807\u5bf9\u8c61\u4e0d\u662f\u7c7b\u578b");
        }
        FilterInvocation fi = (FilterInvocation)object;
        String sUrl = fi.getRequestUrl();
        OptDesc od = Struts2UrlParser.parseUrl((String)sUrl, (HttpServletRequest)fi.getRequest());
        if ("T".equals(CodeRepositoryUtil.getValue("SYSPARAM", "ACTIONRUNLOG"))) {
            this.optRecDao.recRunTime(od.getActionUrl(), od.getMethod());
        }
        if ((list = this.getRdbmsEntryHolderList()) == null) {
            return null;
        }
        RdbmsEntryHoder entryHolder = list.get(od);
        if (entryHolder != null) {
            return entryHolder.getCad();
        }
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }
}

