/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service;

import com.centit.support.compiler.Lexer;
import com.centit.sys.service.SysVariableTranslate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpCalcContext
extends Lexer {
    private Map<String, Set<String>> unitParams = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> userParams = new HashMap<String, Set<String>>();
    private Map<String, Integer> rankParams = new HashMap<String, Integer>();
    private boolean hasError = false;
    private String lastErrMsg;
    private SysVariableTranslate varTrans = null;

    public void setVarTrans(SysVariableTranslate varTrans) {
        this.varTrans = varTrans;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void clearError() {
        this.hasError = false;
    }

    public String getLastErrMsg() {
        return this.lastErrMsg;
    }

    public void setLastErrMsg(String lastErrMsg) {
        this.hasError = true;
        this.lastErrMsg = "Pos " + this.getCurrPos() + " : " + lastErrMsg;
    }

    public void ClearParams() {
        this.unitParams.clear();
        this.userParams.clear();
        this.rankParams.clear();
    }

    public void addUnitParam(String paramName, String unitCode) {
        if (unitCode != null) {
            HashSet<String> uSet = new HashSet<String>();
            uSet.add(unitCode);
            this.unitParams.put(paramName, uSet);
        }
    }

    public void addUnitParam(String paramName, Set<String> unitCodes) {
        if (unitCodes != null) {
            this.unitParams.put(paramName, unitCodes);
        }
    }

    public void addUserParam(String paramName, String userCode) {
        if (userCode != null) {
            HashSet<String> uSet = new HashSet<String>();
            uSet.add(userCode);
            this.userParams.put(paramName, uSet);
        }
    }

    public void addUserParam(String paramName, Set<String> userCodes) {
        if (userCodes != null) {
            this.userParams.put(paramName, userCodes);
        }
    }

    public void addRankParam(String paramName, int r) {
        this.rankParams.put(paramName, r);
    }

    public Set<String> getUnitCode(String paramName) {
        Set<String> uSet = this.unitParams.get(paramName);
        if (uSet != null) {
            return uSet;
        }
        if (this.varTrans != null) {
            return this.varTrans.getUnitsVariable(paramName);
        }
        return null;
    }

    public Set<String> getUserCode(String paramName) {
        Set<String> uSet = this.userParams.get(paramName);
        if (uSet != null) {
            return uSet;
        }
        if (this.varTrans != null) {
            return this.varTrans.getUsersVariable(paramName);
        }
        return null;
    }

    public int getRank(String paramName) {
        return this.rankParams.get(paramName);
    }
}

