/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service.impl;

import com.centit.core.utils.LabelValueBean;
import com.centit.support.utils.Algorithm;
import com.centit.support.utils.StringRegularOpt;
import com.centit.sys.dao.DataCatalogDao;
import com.centit.sys.dao.DataDictionaryDao;
import com.centit.sys.dao.OptDefDao;
import com.centit.sys.dao.OptInfoDao;
import com.centit.sys.dao.RoleInfoDao;
import com.centit.sys.dao.UnitInfoDao;
import com.centit.sys.dao.UserInfoDao;
import com.centit.sys.dao.UserUnitDao;
import com.centit.sys.po.FDatacatalog;
import com.centit.sys.po.FDatadictionary;
import com.centit.sys.po.FOptdef;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FRoleinfo;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserunit;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.CodeRepositoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeRepositoryManagerImpl
implements CodeRepositoryManager {
    private DataCatalogDao catalogDao;
    private DataDictionaryDao dictionaryDao;
    private UserInfoDao daoUser;
    private UnitInfoDao daoUnit;
    private RoleInfoDao sysroledao;
    private OptDefDao optdefdao;
    private OptInfoDao daoOptinfo;
    private UserUnitDao unituserDao;
    private static final Log log = LogFactory.getLog(CodeRepositoryManager.class);

    public void setCatalogDao(DataCatalogDao dao) {
        this.catalogDao = dao;
    }

    public void setDictionaryDao(DataDictionaryDao dao) {
        this.dictionaryDao = dao;
    }

    public void setUnituserDao(UserUnitDao userunitdao) {
        this.unituserDao = userunitdao;
    }

    public void setSysroleDao(RoleInfoDao roledao) {
        this.sysroledao = roledao;
    }

    public void setOptdefDao(OptDefDao pDao) {
        this.optdefdao = pDao;
    }

    public void setFunctionDao(OptInfoDao dao) {
        this.daoOptinfo = dao;
    }

    public void setSysUserDao(UserInfoDao dao) {
        this.daoUser = dao;
    }

    public void setSysUnitDao(UnitInfoDao dao) {
        this.daoUnit = dao;
    }

    @Override
    public void refreshAll() {
        log.info((Object)"CodeRepository initializing...... ");
        List datalist = this.catalogDao.listObjects();
        REPOSITORIES.clear();
        DATACATALOG.clear();
        DATACATALOG.add(new LabelValueBean("\u7cfb\u7edf\u7528\u6237", "usercode"));
        DATACATALOG.add(new LabelValueBean("\u7cfb\u7edf\u673a\u6784", "unitcode"));
        if (datalist != null) {
            for (FDatacatalog dc : datalist) {
                DATACATALOG.add(new LabelValueBean(dc.getCatalogname(), dc.getCatalogcode()));
                this.refreshCodeRepository(dc);
            }
        }
        DATACATALOG.add(new LabelValueBean("\u7528\u6237\u89d2\u8272", "rolecode"));
        DATACATALOG.add(new LabelValueBean("\u7cfb\u7edf\u4e1a\u52a1", "optid"));
        DATACATALOG.add(new LabelValueBean("\u4e1a\u52a1\u64cd\u4f5c", "optcode"));
        this.refresh("usercode");
        this.refresh("loginName");
        this.refresh("unitcode");
        this.refresh("depno");
        this.refresh("userunit");
        this.refresh("rolecode");
        this.refresh("optid");
        this.refresh("optcode");
        this.refresh("suppowerId");
        this.refresh("mainNotifyUnit");
        log.info((Object)"CodeRepository initialized!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCodeRepository(FDatacatalog dc) {
        CodeRepositoryManagerImpl codeRepositoryManagerImpl = this;
        synchronized (codeRepositoryManagerImpl) {
            List codeRepository = (List)REPOSITORIES.get(dc.getCatalogcode());
            if (codeRepository != null) {
                codeRepository.clear();
            }
            List<FDatadictionary> list = this.dictionaryDao.findByCdtbnm(dc.getCatalogcode());
            if ("T".equals(dc.getCatalogtype())) {
                Algorithm.ParentChild<FDatadictionary> c = new Algorithm.ParentChild<FDatadictionary>(){

                    public boolean parentAndChild(FDatadictionary p, FDatadictionary c) {
                        return p.getDatacode().equals(c.getExtracode());
                    }
                };
                Algorithm.sortAsTree(list, (Algorithm.ParentChild)c);
            }
            REPOSITORIES.put(dc.getCatalogcode(), list);
        }
    }

    public void sort(Map<String, FUserinfo> map) {
        ArrayList<Map.Entry<String, FUserinfo>> infoIds = new ArrayList<Map.Entry<String, FUserinfo>>(map.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, FUserinfo>>(){

            @Override
            public int compare(Map.Entry<String, FUserinfo> o1, Map.Entry<String, FUserinfo> o2) {
                long int1 = o1.getValue().getUserorder() == null ? 0L : o1.getValue().getUserorder();
                long int2 = o2.getValue().getUserorder() == null ? 0L : o2.getValue().getUserorder();
                System.out.println("------------------" + (int1 - int2));
                return (int)(int1 - int2);
            }
        });
    }

    @Override
    public void refresh(String sCatalog) {
        if (sCatalog.equalsIgnoreCase("usercode")) {
            USERREPO.clear();
            List userList = this.daoUser.listObjects();
            if (userList != null) {
                for (FUserinfo fUserinfo : userList) {
                    USERREPO.put(fUserinfo.getUsercode(), fUserinfo);
                }
            }
            return;
        }
        if (sCatalog.equalsIgnoreCase("loginName")) {
            LOGINEPO.clear();
            List userList = this.daoUser.listObjects();
            if (userList != null) {
                for (FUserinfo fUserinfo : userList) {
                    LOGINEPO.put(fUserinfo.getLoginname(), fUserinfo);
                }
            }
            return;
        }
        if (sCatalog.equalsIgnoreCase("unitcode")) {
            UNITREPO.clear();
            List unitList = this.daoUnit.listObjects();
            Algorithm.ParentChild<FUnitinfo> c = new Algorithm.ParentChild<FUnitinfo>(){

                public boolean parentAndChild(FUnitinfo p, FUnitinfo c) {
                    return p.getUnitcode().equals(c.getParentunit());
                }
            };
            Algorithm.sortAsTree((List)unitList, (Algorithm.ParentChild)c);
            UNITASTREE.clear();
            UNITASTREE.addAll(unitList);
            if (unitList != null) {
                for (FUnitinfo fUnitinfo : unitList) {
                    UNITREPO.put(fUnitinfo.getUnitcode(), fUnitinfo);
                }
            }
            for (Map.Entry entry : UNITREPO.entrySet()) {
                FUnitinfo pU;
                FUnitinfo u = (FUnitinfo)entry.getValue();
                String sParentUnit = u.getParentunit();
                if (!"T".equals(u.getIsvalid()) || sParentUnit == null || "".equals(sParentUnit) || "0".equals(sParentUnit) || (pU = (FUnitinfo)UNITREPO.get(sParentUnit)) == null) continue;
                pU.getSubUnits().add(u.getUnitcode());
            }
            return;
        }
        if (sCatalog.equalsIgnoreCase("depno")) {
            DEPNO.clear();
            List unitList = this.daoUnit.listObjects();
            if (unitList != null) {
                for (FUnitinfo fUnitinfo : unitList) {
                    DEPNO.put(fUnitinfo.getDepno(), fUnitinfo);
                }
            }
            for (Map.Entry entry : DEPNO.entrySet()) {
                FUnitinfo pU;
                FUnitinfo fUnitinfo = (FUnitinfo)entry.getValue();
                String sParentUnit = fUnitinfo.getParentunit();
                if (!"T".equals(fUnitinfo.getIsvalid()) || sParentUnit == null || "".equals(sParentUnit) || "0".equals(sParentUnit) || (pU = (FUnitinfo)DEPNO.get(sParentUnit)) == null) continue;
                pU.getSubUnits().add(fUnitinfo.getUnitcode());
            }
            return;
        }
        if (sCatalog.equalsIgnoreCase("userunit")) {
            List userUnits = this.unituserDao.listObjects();
            USERUNIT.clear();
            USERUNIT.addAll(userUnits);
            for (FUserunit fUserunit : USERUNIT) {
                FUnitinfo uint;
                String string = fUserunit.getUsercode();
                String unitCode = fUserunit.getUnitcode();
                FDatadictionary dd = CodeRepositoryUtil.getDataPiece("RankType", fUserunit.getUserrank());
                if (dd != null && dd.getExtracode() != null && StringRegularOpt.isNumber((String)dd.getExtracode())) {
                    try {
                        fUserunit.setXzRank(Integer.valueOf(dd.getExtracode()));
                    }
                    catch (Exception e) {
                        fUserunit.setXzRank(CodeRepositoryUtil.MAXXZRANK);
                    }
                }
                if ((uint = (FUnitinfo)UNITREPO.get(unitCode)) == null) continue;
                uint.getSubUserUnits().add(fUserunit);
                FUserinfo ui = (FUserinfo)USERREPO.get(string);
                if (ui == null || ui.getPrimaryUnit() != null && !"T".equals(fUserunit.getIsprimary())) continue;
                ui.setPrimaryUnit(unitCode);
            }
            return;
        }
        if (sCatalog.equalsIgnoreCase("rolecode")) {
            ROLEREPO.clear();
            List roleList = this.sysroledao.listObjects();
            for (FRoleinfo fRoleinfo : roleList) {
                ROLEREPO.put(fRoleinfo.getRolecode(), fRoleinfo);
            }
            return;
        }
        if (sCatalog.equalsIgnoreCase("optid")) {
            OPTREPO.clear();
            List optList = this.daoOptinfo.listObjects();
            if (optList != null) {
                for (FOptinfo fOptinfo : optList) {
                    OPTREPO.put(fOptinfo.getOptid(), fOptinfo);
                }
            }
            return;
        }
        if (sCatalog.equalsIgnoreCase("optcode")) {
            POWERREPO.clear();
            List optdefList = this.optdefdao.listObjects();
            for (FOptdef fOptdef : optdefList) {
                POWERREPO.put(fOptdef.getOptcode(), fOptdef);
            }
            return;
        }
    }
}

