/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service.impl;

import com.centit.cas.sys.service.FUserunit;
import com.centit.cas.sys.service.IUserUnitProvider;
import com.centit.cas.sys.service.UserUnitProviderBean;
import com.centit.core.dao.BaseDao;
import com.centit.support.utils.DatetimeOpt;
import com.centit.sys.dao.UnitInfoDao;
import com.centit.sys.dao.UserInfoDao;
import com.centit.sys.dao.UserUnitDao;
import com.centit.sys.exception.DataSyncException;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserunitId;
import com.centit.sys.service.DataSyncManager;
import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.reflect.MethodUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSyncManagerImpl
implements DataSyncManager,
Serializable {
    private static final long serialVersionUID = 4885276288652405737L;
    private UserInfoDao userInfoDao;
    private UnitInfoDao unitInfoDao;
    private UserUnitDao userUnitDao;
    private IUserUnitProvider userUnitProvider;

    public void setUserInfoDao(UserInfoDao userInfoDao) {
        this.userInfoDao = userInfoDao;
    }

    public void setUnitInfoDao(UnitInfoDao unitInfoDao) {
        this.unitInfoDao = unitInfoDao;
    }

    public void setUserUnitDao(UserUnitDao userUnitDao) {
        this.userUnitDao = userUnitDao;
    }

    public void setUserUnitProvider(IUserUnitProvider userUnitProvider) {
        this.userUnitProvider = userUnitProvider;
    }

    @Override
    public Map<String, Long> dataSyncCount(Date lastModDate) {
        UserUnitProviderBean userUnitProviderBean = this.userUnitProvider.listAllCount(this.convertDate(lastModDate));
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("countuser", userUnitProviderBean.getCountuser());
        result.put("countunit", userUnitProviderBean.getCountunit());
        result.put("countuserunit", userUnitProviderBean.getCountuserunit());
        return result;
    }

    @Override
    public void update(Map<String, Object> param, Date lastModDate) throws DataSyncException {
        UserUnitProviderBean userUnitProviderBean = this.userUnitProvider.listAll(this.convertDate(lastModDate));
        this.update(param, userUnitProviderBean);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void update(Map<String, Object> param, UserUnitProviderBean userUnitProviderBean) throws DataSyncException {
        List wsUserinfos = userUnitProviderBean.getUserinfos();
        List wsUnitinfos = userUnitProviderBean.getUnitinfos();
        List wsUserunits = userUnitProviderBean.getUserunits();
        String message = "\u6570\u636e\u590d\u5236\u9519\u8bef";
        if ("cover".equals(param.get("DSMode"))) {
            this.userUnitDao.deleteAll(FUserinfo.class);
            this.userUnitDao.deleteAll(FUnitinfo.class);
            this.userUnitDao.deleteAll(com.centit.sys.po.FUserunit.class);
            try {
                if (!CollectionUtils.isEmpty((Collection)wsUserinfos)) {
                    List<FUserinfo> userinfos = this.convertList(wsUserinfos, FUserinfo.class);
                    this.userInfoDao.batchSave(userinfos);
                }
                if (!CollectionUtils.isEmpty((Collection)wsUnitinfos)) {
                    List<FUnitinfo> unitinfos = this.convertList(wsUnitinfos, FUnitinfo.class);
                    this.unitInfoDao.batchSave(unitinfos);
                }
                if (CollectionUtils.isEmpty((Collection)wsUserunits)) return;
                List<com.centit.sys.po.FUserunit> userunits = this.convertUserunit(wsUserunits);
                this.userUnitDao.batchSave(userunits);
                return;
            }
            catch (IllegalAccessException e) {
                throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
            }
            catch (InstantiationException e) {
                throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
            }
            catch (NoSuchMethodException e) {
                throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
            }
            catch (InvocationTargetException e) {
                throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
            }
            catch (Exception e) {
                throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
            }
        }
        try {
            List<com.centit.sys.po.FUserunit> remoteUserunits;
            List<com.centit.sys.po.FUserunit> dbUserunits;
            List<FUnitinfo> dbUnitinfos;
            List<FUserinfo> dbUserinfos;
            if (!CollectionUtils.isEmpty((Collection)wsUserinfos) && !CollectionUtils.isEmpty(dbUserinfos = this.listDbObjsByRemoteType(wsUserinfos, FUserinfo.class, this.userInfoDao, "usercode"))) {
                this.userInfoDao.batchMerge(dbUserinfos);
            }
            if (!CollectionUtils.isEmpty((Collection)wsUnitinfos) && !CollectionUtils.isEmpty(dbUnitinfos = this.listDbObjsByRemoteType(wsUnitinfos, FUnitinfo.class, this.unitInfoDao, "unitcode"))) {
                this.unitInfoDao.batchMerge(dbUnitinfos);
            }
            if (CollectionUtils.isEmpty((Collection)wsUserunits) || CollectionUtils.isEmpty(dbUserunits = this.listDbObjsByLocalType(remoteUserunits = this.convertUserunit(wsUserunits), this.userUnitDao, "id"))) return;
            this.userUnitDao.batchMerge(dbUserunits);
            return;
        }
        catch (InvocationTargetException e) {
            throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
        }
        catch (NoSuchMethodException e) {
            throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
        }
        catch (InstantiationException e) {
            throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
        }
        catch (IllegalAccessException e) {
            throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
        }
        catch (Exception e) {
            throw new DataSyncException("\u6570\u636e\u590d\u5236\u9519\u8bef", e);
        }
    }

    @Override
    public void updateByUsercode(String usercode) throws DataSyncException {
        UserUnitProviderBean userUnitProviderBean = this.userUnitProvider.listUnitinfoByUsercode(usercode);
        if (null == userUnitProviderBean) {
            throw new DataSyncException("\u670d\u52a1\u5668\u4e0d\u5b58\u5728\u6b64\u7528\u6237");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("DSMode", "incremental");
        this.update(param, userUnitProviderBean);
    }

    @Override
    public boolean updateUserPwd(String usercode, String pwd) {
        return this.userUnitProvider.updateUserPwd(usercode, pwd);
    }

    @Override
    public void updateByLdap(Map<String, Object> param, Date lastModDate) throws DataSyncException {
    }

    private <T extends Comparator, DB extends BaseDao> List<T> listDbByLdap(List<T> list, DB db, String prop, String ... ignoreProperties) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, DataSyncException {
        List<T> pks = this.getPropList(list, prop);
        List dbObjs = this.listObjectByPks(db, pks);
        if (CollectionUtils.isEmpty(dbObjs)) {
            return list;
        }
        Collection intersection = org.apache.commons.collections.CollectionUtils.intersection(list, dbObjs);
        ArrayList intersectionList = new ArrayList(intersection);
        Collections.sort(intersectionList, (Comparator)intersectionList.get(0));
        Collections.sort(dbObjs, (Comparator)dbObjs.get(0));
        for (int i = 0; i < intersectionList.size(); ++i) {
            BeanUtils.copyProperties(intersectionList.get(i), dbObjs.get(i), (String[])ignoreProperties);
        }
        Collection subtract = org.apache.commons.collections.CollectionUtils.subtract(list, dbObjs);
        if (!CollectionUtils.isEmpty((Collection)subtract)) {
            dbObjs.addAll(subtract);
        }
        return dbObjs;
    }

    private AttributesMapper getUserAttributes() {
        return new AttributesMapper(){

            public Object mapFromAttributes(Attributes userAttributes) throws NamingException {
                FUserinfo ui = new FUserinfo();
                ui.setLoginname((String)userAttributes.get("sAMAccountName").get());
                ui.setUsername((String)userAttributes.get("cn").get());
                if (null != userAttributes.get("mail")) {
                    ui.setRegemail((String)userAttributes.get("mail").get());
                }
                ui.setCreateDate(DatetimeOpt.convertStringToDate((String)((String)userAttributes.get("whenCreated").get()), (String)"yyyyMMddHHmmss"));
                ui.setLastModifyDate(DatetimeOpt.convertStringToDate((String)((String)userAttributes.get("whenChanged").get()), (String)"yyyyMMddHHmmss"));
                ui.setIsvalid("T");
                return ui;
            }
        };
    }

    private <L, DB extends BaseDao<L>> List<L> listDbObjsByLocalType(List<L> remotes, DB db, String pk) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, DataSyncException {
        List local = db.listObjects();
        Collection subtract = org.apache.commons.collections.CollectionUtils.subtract(remotes, (Collection)local);
        List pks = this.getPropList(remotes, pk);
        List<L> dbs = this.listObjectByPks(db, pks);
        Collection intersection = org.apache.commons.collections.CollectionUtils.intersection(remotes, dbs);
        intersection.addAll(subtract);
        return new ArrayList(intersection);
    }

    private <R, L, DB extends BaseDao<L>> List<L> listDbObjsByRemoteType(List<R> remotes, Class<L> localClass, DB db, String pk) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, DataSyncException {
        List<L> remoteLists = this.convertList(remotes, localClass);
        return this.listDbObjsByLocalType(remoteLists, db, pk);
    }

    private <L, DB extends BaseDao<L>, PK extends Serializable> List<L> listObjectByPks(DB db, List<PK> pks) throws DataSyncException {
        if (CollectionUtils.isEmpty(pks)) {
            return new ArrayList();
        }
        if (db instanceof UserInfoDao) {
            return ((UserInfoDao)db).listUserinfoByUsercodes(pks);
        }
        if (db instanceof UnitInfoDao) {
            return ((UnitInfoDao)db).listUnitinfoByUnitcodes(pks);
        }
        if (db instanceof UserUnitDao) {
            return ((UserUnitDao)db).listUserunitByIds(pks);
        }
        throw new DataSyncException("DB not in the assign range");
    }

    private XMLGregorianCalendar convertDate(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return XMLGregorianCalendarImpl.createDateTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13));
    }

    private Date convertDate(XMLGregorianCalendar xmlGregorianCalendar) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(xmlGregorianCalendar.getYear(), xmlGregorianCalendar.getMonth() + 1, xmlGregorianCalendar.getDay(), xmlGregorianCalendar.getHour(), xmlGregorianCalendar.getMinute(), xmlGregorianCalendar.getSecond());
        return calendar.getTime();
    }

    private List<com.centit.sys.po.FUserunit> convertUserunit(List<FUserunit> remoteUserunits) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<com.centit.sys.po.FUserunit> localUserunits = new ArrayList<com.centit.sys.po.FUserunit>();
        for (FUserunit remoteUserunit : remoteUserunits) {
            com.centit.sys.po.FUserunit localUserunit = new com.centit.sys.po.FUserunit();
            FUserunitId id = new FUserunitId();
            BeanUtils.copyProperties((Object)remoteUserunit, (Object)localUserunit, (String[])new String[]{"createDate", "lastModifyDate"});
            this.invokeMethod(remoteUserunit, localUserunit, "createDate");
            this.invokeMethod(remoteUserunit, localUserunit, "lastModifyDate");
            BeanUtils.copyProperties((Object)remoteUserunit, (Object)id);
            localUserunit.setId(id);
            localUserunits.add(localUserunit);
        }
        return localUserunits;
    }

    private <R, L> List<L> convertList(List<R> r, Class<L> clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ArrayList<L> result = new ArrayList<L>();
        for (R e1 : r) {
            L l = clazz.newInstance();
            BeanUtils.copyProperties(e1, l, (String[])new String[]{"createDate", "lastModifyDate"});
            this.invokeMethod(e1, l, "createDate");
            this.invokeMethod(e1, l, "lastModifyDate");
            result.add(l);
        }
        return result;
    }

    private void invokeMethod(Object source, Object target, String properties) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        XMLGregorianCalendar createDate = (XMLGregorianCalendar)MethodUtils.invokeExactMethod((Object)source, (String)("get" + properties.substring(0, 1).toUpperCase() + properties.substring(1)), null);
        if (null == createDate) {
            return;
        }
        MethodUtils.invokeExactMethod((Object)target, (String)("set" + properties.substring(0, 1).toUpperCase() + properties.substring(1)), (Object)this.convertDate(createDate));
    }

    private <T, E> List<T> getPropList(Collection<E> es, String properties) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (E e : es) {
            result.add(MethodUtils.invokeExactMethod(e, (String)("get" + properties.substring(0, 1).toUpperCase() + properties.substring(1)), null));
        }
        return result;
    }
}

