/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service.impl;

import com.centit.core.dao.BaseDao;
import com.centit.core.service.BaseEntityManagerImpl;
import com.centit.sys.dao.DataCatalogDao;
import com.centit.sys.dao.DataDictionaryDao;
import com.centit.sys.po.FDatacatalog;
import com.centit.sys.po.FDatadictionary;
import com.centit.sys.po.FDatadictionaryId;
import com.centit.sys.service.DictionaryManager;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryManagerImpl
extends BaseEntityManagerImpl<FDatacatalog>
implements DictionaryManager {
    private static final long serialVersionUID = 1L;
    private DataCatalogDao catalogDao;
    private DataDictionaryDao dictionaryDao;

    public void setCatalogDao(DataCatalogDao dao) {
        this.catalogDao = dao;
        this.setBaseDao((BaseDao)dao);
    }

    public void setDictionaryDao(DataDictionaryDao dao) {
        this.dictionaryDao = dao;
    }

    @Override
    public List<FDatadictionary> findByCdtbnm(String cdtbnm) {
        return this.dictionaryDao.findByCdtbnm(cdtbnm);
    }

    @Override
    public FDatadictionary findById(FDatadictionaryId id) {
        return (FDatadictionary)this.dictionaryDao.getObjectById(id);
    }

    @Override
    public List<FDatacatalog> getGBCdctgs() {
        return this.catalogDao.getGBCdctgs();
    }

    @Override
    public List<FDatacatalog> getSysCdctgs() {
        return this.catalogDao.getSysCdctgs();
    }

    @Override
    public List<FDatacatalog> getUserCdctgs() {
        return this.catalogDao.getUserCdctgs();
    }

    @Override
    public List<FDatadictionary> getSysCditms(Map<String, Object> filterDescMap) {
        return this.dictionaryDao.listObjects(filterDescMap);
    }

    @Override
    public void deleteCditms(FDatadictionaryId id) {
        FDatacatalog datacatalog = (FDatacatalog)this.catalogDao.getObjectById((Serializable)((Object)id.getCatalogcode()));
        datacatalog.setIsupload("0");
        this.catalogDao.saveObject(datacatalog);
        this.dictionaryDao.deleteObjectById(id);
    }

    @Override
    public void saveCditms(FDatadictionary dd) {
        FDatacatalog datacatalog = (FDatacatalog)this.catalogDao.getObjectById((Serializable)((Object)dd.getCatalogcode()));
        datacatalog.setIsupload("0");
        this.catalogDao.saveObject(datacatalog);
        this.dictionaryDao.saveObject(dd);
    }

    @Override
    public String[] getFieldsDesc(String sDesc, String sType) {
        String[] nRes = new String[]{"\u6570\u636e\u4ee3\u7801", "\u6269\u5c55\u4ee3\u7801(\u7236\u4ee3\u7801)", "\u6269\u5c55\u4ee3\u7801(\u6392\u5e8f\u53f7)", "\u6807\u8bb0", "\u6570\u503c", "\u7c7b\u578b", "\u6570\u636e\u63cf\u8ff0"};
        if ("T".equals(sType)) {
            nRes[1] = "\u4e0a\u7ea7\u4ee3\u7801";
        }
        if (sDesc == null || "".equals(sDesc)) {
            return nRes;
        }
        String[] s = StringUtils.split((String)sDesc, (char)';');
        if (s == null) {
            return nRes;
        }
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            int p = s[i].indexOf(58);
            nRes[i] = p > 1 ? s[i].substring(0, p) : s[i];
        }
        return nRes;
    }
}

