/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.action;

import com.centit.cas.sys.service.ICasWebClient;
import com.centit.core.action.BaseAction;
import com.centit.support.utils.DatetimeOpt;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.DataSyncManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.struts2.ServletActionContext;
import org.springframework.util.StringUtils;

public class DataSyncAction
extends BaseAction {
    private static final long serialVersionUID = -9122799732668306983L;
    private DataSyncManager dataSyncManager;
    private CodeRepositoryManager codeRepositoryManager;
    private ICasWebClient casWebClient;

    public void setCasWebClient(ICasWebClient casWebClient) {
        this.casWebClient = casWebClient;
    }

    public void setDataSyncManager(DataSyncManager dataSyncManager) {
        this.dataSyncManager = dataSyncManager;
    }

    public void setCodeRepositoryManager(CodeRepositoryManager codeRepositoryManager) {
        this.codeRepositoryManager = codeRepositoryManager;
    }

    public String list() {
        return "list";
    }

    public void syncAll() throws IOException {
        PrintWriter writer = ServletActionContext.getResponse().getWriter();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("result", "0");
        Map paramMap = this.request.getParameterMap();
        Map filterMap = this.convertSearchColumn(paramMap);
        Date lastModDate = null;
        String date = (String)filterMap.get("lastModDate");
        if (StringUtils.hasText((String)date)) {
            lastModDate = DatetimeOpt.convertStringToDate((String)date, (String)"yyyy-MM-dd");
        }
        try {
            this.dataSyncManager.update(filterMap, lastModDate);
            this.codeRepositoryManager.refresh("usercode");
            this.codeRepositoryManager.refresh("unitcode");
            this.codeRepositoryManager.refresh("userunit");
        }
        catch (Exception e) {
            resultMap.put("result", "1");
            resultMap.put("msg", e.getMessage());
        }
        writer.print(JSONObject.fromObject(resultMap).toString());
    }

    public void syncUser() throws IOException {
        PrintWriter writer = ServletActionContext.getResponse().getWriter();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("result", "0");
        Map paramMap = this.request.getParameterMap();
        Map filterMap = this.convertSearchColumn(paramMap);
        try {
            this.dataSyncManager.updateByUsercode((String)filterMap.get("usercode"));
            this.codeRepositoryManager.refresh("usercode");
            this.codeRepositoryManager.refresh("unitcode");
            this.codeRepositoryManager.refresh("userunit");
        }
        catch (Exception e) {
            resultMap.put("result", "1");
            resultMap.put("msg", e.getMessage());
        }
        writer.print(JSONObject.fromObject(resultMap).toString());
    }
}

