/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.action;

import com.centit.core.action.BaseEntityExtremeAction;
import com.centit.sys.po.FDatacatalog;
import com.centit.sys.po.FDatadictionary;
import com.centit.sys.po.FDatadictionaryId;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.DictionaryManager;
import com.centit.sys.util.ISysOptLog;
import com.centit.sys.util.SysOptLogFactoryImpl;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryAction
extends BaseEntityExtremeAction<FDatacatalog> {
    private static final long serialVersionUID = 1L;
    private DictionaryManager dictManger;
    private CodeRepositoryManager codeRepo;
    private FDatacatalog catalog;
    private String[] fdesc;
    private List<FDatadictionary> dictDetails;
    private static final ISysOptLog SYS_OPT_LOG = SysOptLogFactoryImpl.getSysOptLog("DICTSET");
    private Integer dc_totalRows;
    private FDatadictionaryId id;
    private FDatadictionary datadictionary;

    public FDatacatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(FDatacatalog catalog) {
        this.catalog = catalog;
    }

    public String[] getFdesc() {
        return this.fdesc;
    }

    public void setFdesc(String[] fdesc) {
        this.fdesc = fdesc;
    }

    public List<FDatadictionary> getDictDetails() {
        return this.dictDetails;
    }

    public void setDictDetails(List<FDatadictionary> dictDetails) {
        this.dictDetails = dictDetails;
    }

    public Integer getDc_totalRows() {
        return this.dc_totalRows;
    }

    public void setDc_totalRows(Integer dc_totalRows) {
        this.dc_totalRows = dc_totalRows;
    }

    public FDatadictionaryId getId() {
        return this.id;
    }

    public void setId(FDatadictionaryId id) {
        this.id = id;
    }

    public FDatadictionary getDatadictionary() {
        return this.datadictionary;
    }

    public void setDatadictionary(FDatadictionary datadictionary) {
        this.datadictionary = datadictionary;
    }

    public void setCodeRepoManager(CodeRepositoryManager crm) {
        this.codeRepo = crm;
    }

    public void setDictManger(DictionaryManager dm) {
        this.dictManger = dm;
        this.setBaseEntityManager(dm);
    }

    public String refresh() {
        this.codeRepo.refreshAll();
        return "success";
    }

    public String view() {
        try {
            FDatacatalog dbobject = (FDatacatalog)this.dictManger.getObjectById((Serializable)((Object)((FDatacatalog)this.object).getCatalogcode()));
            if (dbobject == null) {
                return "list";
            }
            this.catalog = dbobject;
            this.fdesc = this.dictManger.getFieldsDesc(dbobject.getFielddesc(), dbobject.getCatalogtype());
            this.dictDetails = this.dictManger.findByCdtbnm(((FDatacatalog)this.object).getCatalogcode());
            if (this.dictDetails != null) {
                this.totalRows = this.dictDetails.size();
                this.dc_totalRows = this.dictDetails.size();
            }
            return "view";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String save() {
        try {
            FDatacatalog dbobject = (FDatacatalog)this.dictManger.getObject(this.object);
            if (dbobject != null) {
                dbobject.copyNotNullProperty((FDatacatalog)this.object);
                this.object = dbobject;
            }
            try {
                this.dictManger.saveObject(this.object);
                this.savedMessage();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "edit";
            }
            return "success";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String deleteDetail() {
        try {
            String catalogCode = this.request.getParameter("catalogcode");
            String dataCode = this.request.getParameter("datacode");
            this.id = new FDatadictionaryId();
            if (StringUtils.isNotBlank((String)catalogCode)) {
                this.id.setCatalogcode(catalogCode);
            }
            if (StringUtils.isNotBlank((String)dataCode)) {
                this.id.setDatacode(dataCode);
            }
            this.dictManger.deleteCditms(this.id);
            this.codeRepo.refresh(this.id.getCatalogcode());
            FDatacatalog dbobject = (FDatacatalog)this.dictManger.getObjectById((Serializable)((Object)this.id.getCatalogcode()));
            if (dbobject == null) {
                this.saveError("entity.missing");
                return "list";
            }
            SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), this.id.toString(), "\u5220\u9664\u5b57\u5178\u4ee3\u7801 [" + dbobject.getCatalogcode() + "]");
            return "deleteDetail";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String editDetail() {
        try {
            String catalogCode = this.request.getParameter("catalogcode");
            String dataCode = this.request.getParameter("datacode");
            this.id = new FDatadictionaryId();
            if (StringUtils.isNotBlank((String)catalogCode)) {
                this.id.setCatalogcode(catalogCode);
            }
            if (StringUtils.isNotBlank((String)dataCode)) {
                this.id.setDatacode(dataCode);
            }
            this.datadictionary = this.dictManger.findById(this.id);
            if (this.datadictionary == null) {
                this.datadictionary = new FDatadictionary();
                this.datadictionary.setId(this.id);
            }
            this.catalog = (FDatacatalog)this.dictManger.getObjectById((Serializable)((Object)this.id.getCatalogcode()));
            this.fdesc = this.dictManger.getFieldsDesc(this.catalog.getFielddesc(), this.catalog.getCatalogtype());
            return "editDetail";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String saveDetail() {
        try {
            FDatadictionary desobj = this.dictManger.findById(this.datadictionary.getId());
            if (desobj != null) {
                desobj.copyNotNullProperty(this.datadictionary);
                this.datadictionary = desobj;
            }
            this.dictManger.saveCditms(this.datadictionary);
            this.savedMessage();
            this.codeRepo.refresh(this.datadictionary.getCatalogcode());
            SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), this.datadictionary.getId().toString(), this.datadictionary.display(), desobj != null ? desobj.display() : "");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return "editDetail";
        }
        return "saveDetail";
    }
}

