/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.action;

import com.centit.core.action.BaseAction;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.Usersetting;
import com.centit.sys.security.FUserDetail;
import com.centit.sys.service.FunctionManager;
import com.centit.sys.service.SysUserManager;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrameAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private FunctionManager functionMgr;
    private String userFirstPage;
    private SysUserManager sysUserManager;
    private String superFunctionId;
    private String casHome;

    public String getCasHome() {
        return this.casHome;
    }

    public void setCasHome(String casHome) {
        this.casHome = casHome;
    }

    public void setSysUserManager(SysUserManager sysUserManager) {
        this.sysUserManager = sysUserManager;
    }

    public String getUserFirstPage() {
        return this.userFirstPage;
    }

    public void setUserFirstPage(String userFirstPage) {
        this.userFirstPage = userFirstPage;
    }

    public void setFunctionMgr(FunctionManager functionMgr) {
        this.functionMgr = functionMgr;
    }

    public String showMain() throws Exception {
        FUserDetail uinfo = (FUserDetail)this.getLoginUser();
        Usersetting us = uinfo.getUserSetting();
        try {
            if (StringUtils.isEmpty((String)us.getMainpage())) {
                FOptinfo f = this.functionMgr.getFunctionsByUser(uinfo).get(0);
                us.setMainpage(f.getOpturl());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Map session = ActionContext.getContext().getSession();
        String stylePath = this.request.getContextPath() + "/styles/" + us.getPagestyle();
        session.put("STYLE_PATH", stylePath);
        this.userFirstPage = '/' + us.getMainpage();
        this.request.setAttribute("firstPage", (Object)this.userFirstPage);
        session.put("LAYOUT", us.getFramelayout());
        ActionContext.getContext().put("OA_MENUS", (Object)this.getFunctionsByUserCode(((FUserinfo)super.getLoginUser()).getUsercode()));
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("userCode", uinfo.getUsercode());
        this.request.setAttribute("gwDbnumber", (Object)"0");
        HashMap<String, String> bjMap = new HashMap<String, String>();
        bjMap.put("userCode", uinfo.getUsercode());
        this.request.setAttribute("bjDbnumber", (Object)"0");
        return "MainPage";
    }

    public String getSuperFunc() {
        String superFunctionId = this.request.getParameter("superFunctionId");
        if (!org.springframework.util.StringUtils.hasText((String)superFunctionId)) {
            return MainFrameAction.getMenuFunc(new ArrayList<FOptinfo>());
        }
        FUserinfo user = new FUserinfo();
        user.setUsercode(((FUserinfo)this.getLoginUser()).getUsercode());
        List<FOptinfo> menuFunsByUser = this.functionMgr.getMenuFuncByUserIDAndSuperFunctionId(user, superFunctionId);
        return MainFrameAction.getMenuFunc(menuFunsByUser);
    }

    private String getFunctionsByUserCode(String usercode) {
        FUserinfo user = new FUserinfo();
        List<FOptinfo> menuFunsByUser = null;
        if (StringUtils.isBlank((String)this.superFunctionId)) {
            user.setUsercode(((FUserinfo)this.getLoginUser()).getUsercode());
            menuFunsByUser = this.functionMgr.getMenuFuncByUser(user);
        } else {
            user.setUsercode(usercode);
            menuFunsByUser = this.functionMgr.getMenuFuncByUserIDAndSuperFunctionId(user, this.superFunctionId);
        }
        return MainFrameAction.getMenuFunc(menuFunsByUser);
    }

    private static String getMenuFunc(List<FOptinfo> menuFunsByUser) {
        HashMap result = new HashMap();
        ArrayList menuList = new ArrayList();
        for (FOptinfo fOptinfo : menuFunsByUser) {
            HashMap<String, String> menu = new HashMap<String, String>();
            menu.put("MID", fOptinfo.getOptid());
            menu.put("MText", fOptinfo.getOptname());
            menu.put("ParentID", fOptinfo.getPreoptid());
            menu.put("MUrl", fOptinfo.getOpturl());
            menu.put("MType", fOptinfo.getPageType());
            menuList.add(menu);
        }
        result.put("menuList", menuList);
        return JSONObject.fromObject(result).toString();
    }

    public String login() {
        Map session = ActionContext.getContext().getSession();
        if (this.request.getParameter("inDialog") != null) {
            session.put("loginInDialog", "true");
            return "loginInDialog";
        }
        session.put("loginInDialog", "false");
        return "login";
    }

    public String fgLogin() {
        String loginName = this.request.getParameter("loginName");
        FUserDetail uinfo = null;
        try {
            uinfo = this.sysUserManager.loadUserByUsername(loginName);
        }
        catch (Exception e) {
            return "login";
        }
        Usersetting us = uinfo.getUserSetting();
        try {
            if (StringUtils.isEmpty((String)us.getMainpage())) {
                FOptinfo f = this.functionMgr.getFunctionsByUser(uinfo).get(0);
                us.setMainpage(f.getOpturl());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Map session = ActionContext.getContext().getSession();
        String stylePath = this.request.getContextPath() + "/styles/" + us.getPagestyle();
        session.put("STYLE_PATH", stylePath);
        this.userFirstPage = '/' + us.getMainpage();
        this.request.setAttribute("firstPage", (Object)this.userFirstPage);
        session.put("LAYOUT", us.getFramelayout());
        ActionContext.getContext().put("OA_MENUS", (Object)this.getFunctionsByUserCode(((FUserinfo)super.getLoginUser()).getUsercode()));
        this.request.getSession().setAttribute("USERDETAIL", (Object)uinfo);
        return "MainPage";
    }

    public String loginError() {
        Map session = ActionContext.getContext().getSession();
        String inDialog = (String)session.get("loginInDialog");
        if (inDialog != null || "true".equals(inDialog)) {
            this.saveError("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01");
            return "loginResInDialog";
        }
        return "loginError";
    }

    public String loginSuccess() throws Exception {
        Map session = ActionContext.getContext().getSession();
        String inDialog = (String)session.get("loginInDialog");
        if (inDialog != null) {
            session.remove("loginInDialog");
        }
        if (inDialog != null && "true".equals(inDialog)) {
            this.saveMessage("\u767b\u5f55\u6210\u529f");
            return "loginResInDialog";
        }
        return "loginSuccess";
    }

    public String logincas() throws Exception {
        return "lgoinSuccess";
    }

    public String dashboard() throws Exception {
        return "dashboard";
    }

    public String getSuperFunctionId() {
        return this.superFunctionId;
    }

    public void setSuperFunctionId(String superFunctionId) {
        this.superFunctionId = superFunctionId;
    }
}

