/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.action;

import com.centit.core.action.BaseEntityExtremeAction;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.FunctionManager;
import com.centit.sys.util.ISysOptLog;
import com.centit.sys.util.SysOptLogFactoryImpl;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptInfoAction
extends BaseEntityExtremeAction<FOptinfo> {
    private static final long serialVersionUID = 1L;
    private FunctionManager functionManager;
    private CodeRepositoryManager codeRepositoryManager;
    private Integer totalRows;
    private static final ISysOptLog SYS_OPT_LOG = SysOptLogFactoryImpl.getSysOptLog("OPTINFO");

    public Integer getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(Integer totalRows) {
        this.totalRows = totalRows;
    }

    public void setCodeRepositoryManager(CodeRepositoryManager codeRepositoryManager) {
        this.codeRepositoryManager = codeRepositoryManager;
    }

    public void setFunctionManager(FunctionManager functionManager) {
        this.functionManager = functionManager;
        this.setBaseEntityManager(functionManager);
    }

    public String list() {
        try {
            this.objList = this.functionManager.listObjects();
            this.totalRows = this.objList.size();
            return "list";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String built() {
        try {
            return "edit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String save() {
        try {
            FOptinfo dbobject = (FOptinfo)this.functionManager.getObjectById((Serializable)((Object)((FOptinfo)this.object).getOptid()));
            if (dbobject != null) {
                this.functionManager.copyObjectNotNullProperty(dbobject, this.object);
                this.object = dbobject;
            }
            try {
                this.functionManager.saveObject(this.object);
                this.codeRepositoryManager.refresh("optid");
                this.savedMessage();
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FOptinfo)this.object).getOptid(), ((FOptinfo)this.object).display(), dbobject != null ? dbobject.display() : "");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                return "edit";
            }
            return "success";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String delete() {
        try {
            try {
                this.functionManager.deleteObject(this.object);
                this.codeRepositoryManager.refresh("optid");
                this.deletedMessage();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "edit";
            }
            return "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }
}

