/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.action;

import com.centit.core.action.BaseEntityExtremeAction;
import com.centit.sys.po.AddressBook;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FRolepower;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserunit;
import com.centit.sys.po.FUserunitId;
import com.centit.sys.security.FUserDetail;
import com.centit.sys.service.AddressBookManager;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.CodeRepositoryUtil;
import com.centit.sys.service.SysRoleManager;
import com.centit.sys.service.SysUnitManager;
import com.centit.sys.service.SysUserManager;
import com.centit.sys.util.ISysOptLog;
import com.centit.sys.util.SysOptLogFactoryImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitAction
extends BaseEntityExtremeAction<FUnitinfo> {
    private static final long serialVersionUID = 1L;
    private SysUnitManager sysUnitManager;
    private CodeRepositoryManager codeRepositoryManager;
    private SysRoleManager sysRoleManager;
    private AddressBookManager addressBookMag;
    private SysUserManager sysUserManager;
    private List<FUserunit> unitusers;
    private Integer totalRows;
    private List<FOptinfo> fOptinfos;
    private FUserunit userunit;
    public static final Log log = LogFactory.getLog(UnitAction.class);
    private static final ISysOptLog SYS_OPT_LOG = SysOptLogFactoryImpl.getSysOptLog("UNITMAG");
    private String underUnit;
    private String unitsJson;
    private Map<String, String> powerlist;
    public String[] optcodelist;
    private String usercode;
    private List<FUserinfo> userlist;
    private AddressBook addressBook;
    public JSONObject result;
    public String selectvalue;

    public void setSysRoleManager(SysRoleManager sysRoleManager) {
        this.sysRoleManager = sysRoleManager;
    }

    public FUserunit getUserunit() {
        return this.userunit;
    }

    public void setUserunit(FUserunit userunit) {
        this.userunit = userunit;
    }

    public void setSysUserManager(SysUserManager sysUserManager) {
        this.sysUserManager = sysUserManager;
    }

    public void setCodeRepositoryManager(CodeRepositoryManager codeRepositoryManager) {
        this.codeRepositoryManager = codeRepositoryManager;
    }

    public void setAddressBookMag(AddressBookManager addressBookMag) {
        this.addressBookMag = addressBookMag;
    }

    public void setTotalRows(Integer totalRows) {
        this.totalRows = totalRows;
    }

    public List<FOptinfo> getFOptinfos() {
        return this.fOptinfos;
    }

    public void setFOptinfos(List<FOptinfo> fOptinfos) {
        this.fOptinfos = fOptinfos;
    }

    public Integer getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public List<FUserunit> getUnitusers() {
        return this.unitusers;
    }

    public void setUnitusers(List<FUserunit> unitusers) {
        this.unitusers = unitusers;
    }

    public void setAddressBookManager(AddressBookManager basemgr) {
        this.addressBookMag = basemgr;
    }

    public void setSysUnitManager(SysUnitManager sysUnitManager) {
        this.sysUnitManager = sysUnitManager;
        this.setBaseEntityManager(sysUnitManager);
    }

    public String list() {
        try {
            this.objList = this.sysUnitManager.listObjects();
            this.totalRows = this.objList.size();
            return "list";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String view() {
        try {
            this.object = this.sysUnitManager.getObjectById((Serializable)((Object)((FUnitinfo)this.object).getUnitcode()));
            this.unitusers = this.sysUnitManager.getSysUsersByUnitId(((FUnitinfo)this.object).getUnitcode());
            this.totalRows = this.unitusers.size();
            return "view";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String edit() {
        try {
            FUnitinfo o = (FUnitinfo)this.sysUnitManager.getObject(this.object);
            if (o != null) {
                this.sysUnitManager.copyObjectNotNullProperty(this.object, o);
                if (o.getParentunit() != null) {
                    this.objList = this.sysUnitManager.getAllSubUnits(o.getParentunit());
                }
            }
            this.unitsJson = this.sysUnitManager.getAllUnitsJSON();
            return "edit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String builtNext() {
        try {
            this.unitsJson = "\"\"";
            ((FUnitinfo)this.object).setUnitcode(this.sysUnitManager.getNextKey());
            if (((FUnitinfo)this.object).getParentunit() != null) {
                this.objList = this.sysUnitManager.getAllSubUnits(((FUnitinfo)this.object).getParentunit());
            }
            return "edit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public Map<String, String> getPowerlist() {
        return this.powerlist;
    }

    public void setPowerlist(Map<String, String> powerlist) {
        this.powerlist = powerlist;
    }

    public String editUnitPower() {
        try {
            FUnitinfo dbobject = (FUnitinfo)this.sysUnitManager.getObjectById((Serializable)((Object)((FUnitinfo)this.object).getUnitcode()));
            this.object = dbobject;
            List<FRolepower> list = this.sysRoleManager.getRolePowers("G$" + ((FUnitinfo)this.object).getUnitcode());
            this.powerlist = new HashMap<String, String>();
            for (FRolepower p : list) {
                this.powerlist.put(p.getOptcode(), "1");
            }
            this.fOptinfos = CodeRepositoryUtil.getOptinfoList("P");
            this.totalRows = this.fOptinfos.size();
            return "editUnitPower";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String[] getOptcodelist() {
        return this.optcodelist;
    }

    public void setOptcodelist(String[] optcodelist) {
        this.optcodelist = optcodelist;
    }

    public String saveUnitPower() {
        try {
            this.sysRoleManager.saveRolePowers("G$" + ((FUnitinfo)this.object).getUnitcode(), this.optcodelist);
            this.savedMessage();
            SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FUnitinfo)this.object).getUnitcode(), "\u66f4\u65b0 [" + CodeRepositoryUtil.getValue("unitcode", ((FUnitinfo)this.object).getUnitcode()) + "] \u673a\u6784\u6743\u9650\u4fe1\u606f");
            return "success";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String getUsercode() {
        return this.usercode;
    }

    public void setUsercode(String usercode) {
        this.usercode = usercode;
    }

    public String deleteUnitUser() {
        try {
            this.sysUnitManager.deleteUnitUser(this.userunit.getId());
            this.deletedMessage();
            this.object = this.sysUnitManager.getObjectById((Serializable)((Object)this.userunit.getUnitcode()));
            SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), ((FUnitinfo)this.object).getUnitcode(), "\u5220\u9664 [" + CodeRepositoryUtil.getValue("unitcode", this.userunit.getUnitcode()) + "] \u673a\u6784\u7528\u6237 [" + CodeRepositoryUtil.getValue("usercode", this.userunit.getUsercode()) + "]");
            return "reView";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String builtUnitUser() {
        FUserDetail user = (FUserDetail)this.getLoginUser();
        FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
        this.userlist = this.sysUserManager.getUserUnderUnit(dept.getUnitcode());
        return "editUnitUser";
    }

    public String editUnitUser() {
        try {
            FUserunitId id = new FUserunitId();
            id.setUnitcode(((FUnitinfo)this.object).getUnitcode());
            id.setUsercode(this.usercode);
            FUserunit dbobject = this.sysUnitManager.findUnitUserById(id);
            if (dbobject == null) {
                dbobject = new FUserunit();
                dbobject.setId(id);
            }
            this.userunit = dbobject;
            return "editUnitUser";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String saveUnitUser() {
        try {
            FUserunit dbobject = this.sysUnitManager.findUnitUserById(this.userunit.getId());
            String oldValue = null;
            if (dbobject != null) {
                this.setEorroMessage("\u4f60\u4fdd\u5b58\u7684\u7528\u6237\u5df2\u5b58\u5728");
            } else {
                oldValue = this.userunit.display();
                List<FUserunit> ls = this.sysUnitManager.getSysUnitsByUserId(this.userunit.getUsercode());
                this.userunit.setIsprimary("T");
                for (FUserunit l : ls) {
                    if (!l.getIsprimary().equals("T")) continue;
                    this.userunit.setIsprimary("F");
                }
            }
            try {
                this.sysUnitManager.saveUnitUser(this.userunit);
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), this.userunit.getId().toString(), this.userunit.display(), oldValue);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.saveError(e.getMessage());
                return "editUnitUser";
            }
            return "reView";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String delete() {
        try {
            try {
                this.object = this.sysUnitManager.getObjectById((Serializable)((Object)((FUnitinfo)this.object).getUnitcode()));
                this.sysUnitManager.disableObject(this.object);
                this.codeRepositoryManager.refresh("unitcode");
                this.deletedMessage();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "edit";
            }
            if (this.underUnit == null) {
                return "success";
            }
            return "underUnit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String renew() {
        try {
            try {
                this.object = this.sysUnitManager.getObjectById((Serializable)((Object)((FUnitinfo)this.object).getUnitcode()));
                this.sysUnitManager.renewObject(this.object);
                this.renewedMessage();
            }
            catch (Exception e) {
                return "edit";
            }
            if (this.underUnit == null) {
                return "success";
            }
            return "underUnit";
        }
        catch (Exception e) {
            return "error";
        }
    }

    public String save() {
        FUnitinfo dbobject;
        if (this.object != null && (dbobject = (FUnitinfo)this.sysUnitManager.getObjectById((Serializable)((Object)((FUnitinfo)this.object).getUnitcode()))) != null) {
            dbobject.copyNotNullProperty((FUnitinfo)this.object);
            this.object = dbobject;
        }
        try {
            this.sysUnitManager.saveObject(this.object);
            this.codeRepositoryManager.refresh("unitcode");
            this.savedMessage();
            if (this.underUnit == null) {
                return "success";
            }
            return "underUnit";
        }
        catch (Exception e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "edit";
            }
            catch (Exception ee) {
                ee.printStackTrace();
                return "error";
            }
        }
    }

    public String selectUser() {
        return "selectUser";
    }

    public AddressBook getAddressBook() {
        return this.addressBook;
    }

    public void setAddressBook(AddressBook addressBook) {
        this.addressBook = addressBook;
    }

    public String editAddressBook() {
        try {
            if (((FUnitinfo)this.object).getAddrbookid() == null || ((FUnitinfo)this.object).getAddrbookid().equals(0L)) {
                Long id = this.addressBookMag.getNextAddressId();
                this.addressBook = new AddressBook();
                this.addressBook.setAddrbookid(id);
                this.addressBook.setBodycode(((FUnitinfo)this.object).getUnitcode());
                this.addressBook.setBodytype("D");
                this.addressBook.setRepresentation(((FUnitinfo)this.object).getUnitname());
                ((FUnitinfo)this.object).setAddrbookid(id);
                this.sysUnitManager.saveObject(this.object);
                this.addressBookMag.saveObject(this.addressBook);
            }
            return "editAddressBook";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String getSelectvalue() {
        return this.selectvalue;
    }

    public void setSelectvalue(String selectvalue) {
        this.selectvalue = selectvalue;
    }

    public JSONObject getResult() {
        return this.result;
    }

    public void setResult(JSONObject result) {
        this.result = result;
    }

    public String getUnituser() {
        Set<FUserinfo> userList = CodeRepositoryUtil.getUnitUsers(this.selectvalue);
        HashMap<String, String> map = new HashMap<String, String>();
        for (FUserinfo userinfo : userList) {
            map.put(userinfo.getUsercode(), userinfo.getUsername());
        }
        this.result = JSONObject.fromObject(map);
        return "unituser";
    }

    public List<FUserinfo> getUserlist() {
        return this.userlist;
    }

    public void setUserlist(List<FUserinfo> userlist) {
        this.userlist = userlist;
    }

    public String getUnderUnit() {
        return this.underUnit;
    }

    public void setUnderUnit(String underUnit) {
        this.underUnit = underUnit;
    }

    public String getUnitsJson() {
        return this.unitsJson;
    }

    public void setUnitsJson(String unitsJson) {
        this.unitsJson = unitsJson;
    }
}

