/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.dao;

import com.centit.core.dao.BaseDaoImpl;
import com.centit.sys.po.FOptRoleMap;
import com.centit.sys.po.FOptdef;
import com.centit.sys.po.FOptinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FVUseroptlist;
import com.centit.sys.po.FVUseroptmoudlelist;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptInfoDao
extends BaseDaoImpl<FOptinfo> {
    private static final long serialVersionUID = 1L;

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("OPTID", "EQUAL");
            this.filterField.put("OPTURL", "EQUAL");
            this.filterField.put("OPTNAME", "LIKE");
            this.filterField.put("PREOPTID", "EQUAL");
            this.filterField.put("OPTTYPE", "EQUAL");
            this.filterField.put("TOPOPTID", "EQUAL");
            this.filterField.put("ISINTOOLBAR", "EQUAL");
            this.filterField.put("ORDER BY", " preoptid, orderind");
        }
        return this.filterField;
    }

    public List<FOptinfo> getFunctionsByUserID(String userID) {
        String[] params = null;
        String hql = "FROM FVUseroptmoudlelist where usercode=?";
        params = new String[]{userID};
        List ls = this.getHibernateTemplate().find(hql, (Object[])params);
        ArrayList<FOptinfo> opts = new ArrayList<FOptinfo>();
        for (FVUseroptmoudlelist opm : ls) {
            FOptinfo opt = new FOptinfo();
            opt.setFormcode(opm.getFormcode());
            opt.setImgindex(opm.getImgindex());
            opt.setIsintoolbar(opm.getIsintoolbar());
            opt.setMsgno(opm.getMsgno());
            opt.setMsgprm(opm.getMsgprm());
            opt.setOptid(opm.getOptid());
            opt.setOptname(opm.getOptname());
            opt.setOpturl(opm.getOpturl());
            opt.setPreoptid(opm.getPreoptid());
            opt.setTopoptid(opm.getTopoptid());
            opts.add(opt);
        }
        return opts;
    }

    public List<FOptinfo> getMenuFuncByUserID(String userID) {
        String hql1 = "FROM FOptinfo where opturl='...' order by orderind ";
        List preOpts = this.getHibernateTemplate().find(hql1);
        String hql = "FROM FVUseroptmoudlelist where isintoolbar='Y' and usercode=? ORDER BY orderind";
        List ls = this.getHibernateTemplate().find(hql, new Object[]{userID});
        return OptInfoDao.getMenuFuncs(preOpts, ls);
    }

    public List<FOptinfo> getMenuFuncByUserIDAndSuperFunctionId(String userID, String superFunctionId) {
        String hql1 = "FROM FOptinfo where opturl='...' order by orderind ";
        List preOpts = super.getHibernateTemplate().find(hql1);
        String hql = "select f FROM FVUseroptmoudlelist f, VHioptinfo v where f.optid = v.optid and f.isintoolbar='Y' and f.usercode=? and v.topoptid=? ORDER BY orderind";
        List ls = super.getHibernateTemplate().find(hql, new Object[]{userID, superFunctionId});
        return OptInfoDao.getMenuFuncs(preOpts, ls);
    }

    private static List<FOptinfo> getMenuFuncs(List<FOptinfo> preOpts, List<FVUseroptmoudlelist> ls) {
        int i;
        boolean[] isNeeds = new boolean[preOpts.size()];
        for (int i2 = 0; i2 < preOpts.size(); ++i2) {
            isNeeds[i2] = false;
        }
        ArrayList<FOptinfo> opts = new ArrayList<FOptinfo>();
        block1: for (FVUseroptmoudlelist opm : ls) {
            FOptinfo opt = new FOptinfo();
            opt.setFormcode(opm.getFormcode());
            opt.setImgindex(opm.getImgindex());
            opt.setIsintoolbar(opm.getIsintoolbar());
            opt.setMsgno(opm.getMsgno());
            opt.setMsgprm(opm.getMsgprm());
            opt.setOptid(opm.getOptid());
            opt.setOpttype(opm.getOpttype());
            opt.setOptname(opm.getOptname());
            opt.setOpturl(opm.getOpturl());
            opt.setPreoptid(opm.getPreoptid());
            opt.setTopoptid(opm.getTopoptid());
            opt.setPageType(opm.getPageType());
            opts.add(opt);
            for (i = 0; i < preOpts.size(); ++i) {
                if (opt.getPreoptid() == null || !opt.getPreoptid().equals(preOpts.get(i).getOptid())) continue;
                isNeeds[i] = true;
                continue block1;
            }
        }
        ArrayList<FOptinfo> needAdd = new ArrayList<FOptinfo>();
        for (int i3 = 0; i3 < preOpts.size(); ++i3) {
            if (!isNeeds[i3]) continue;
            needAdd.add(preOpts.get(i3));
        }
        boolean[] isNeeds2 = new boolean[preOpts.size()];
        block4: while (true) {
            int nestedMenu = 0;
            for (i = 0; i < preOpts.size(); ++i) {
                isNeeds2[i] = false;
            }
            block6: for (i = 0; i < needAdd.size(); ++i) {
                for (int j = 0; j < preOpts.size(); ++j) {
                    if (isNeeds[j] || ((FOptinfo)needAdd.get(i)).getPreoptid() == null || !((FOptinfo)needAdd.get(i)).getPreoptid().equals(preOpts.get(j).getOptid())) continue;
                    isNeeds[j] = true;
                    isNeeds2[j] = true;
                    ++nestedMenu;
                    continue block6;
                }
            }
            if (nestedMenu == 0) break;
            needAdd.clear();
            i = 0;
            while (true) {
                if (i >= preOpts.size()) continue block4;
                if (isNeeds2[i]) {
                    needAdd.add(preOpts.get(i));
                }
                ++i;
            }
            break;
        }
        for (int i4 = 0; i4 < preOpts.size(); ++i4) {
            if (!isNeeds[i4]) continue;
            opts.add(preOpts.get(i4));
        }
        return OptInfoDao.makeOptTree(opts);
    }

    private static List<FOptinfo> makeOptTree(List<FOptinfo> opts) {
        ArrayList<FOptinfo> treeOpts = new ArrayList<FOptinfo>();
        ArrayList<FOptinfo> tempOpts = new ArrayList<FOptinfo>();
        for (FOptinfo opt : opts) {
            if (!"0".equals(opt.getPreoptid())) continue;
            tempOpts.add(opt);
        }
        treeOpts.addAll(tempOpts);
        opts.removeAll(tempOpts);
        while (tempOpts.size() > 0 && opts.size() > 0) {
            ArrayList<FOptinfo> parentOpts = tempOpts;
            tempOpts = new ArrayList();
            block2: for (FOptinfo opt : opts) {
                for (FOptinfo parOpt : parentOpts) {
                    if (!parOpt.getOptid().equals(opt.getPreoptid())) continue;
                    tempOpts.add(opt);
                    continue block2;
                }
            }
            treeOpts.addAll(tempOpts);
            opts.removeAll(tempOpts);
        }
        return treeOpts;
    }

    public List<FOptinfo> findMenuFuncByType(String type) {
        String[] params = new String[]{type};
        String hql = "FROM FOptinfo where PREOPTID != '0' and OPTTYPE=? order by orderind ";
        List opts = this.getHibernateTemplate().find(hql, (Object[])params);
        return opts;
    }

    public List<FOptinfo> getFunctionsByUserAndSuperFunctionId(String userID, String superFunctionId) {
        String[] params = null;
        String hql = "FROM FVUseroptmoudlelist  where usercode=? and topoptid=? ORDER BY preoptid, orderind";
        params = new String[]{userID, superFunctionId};
        List ls = this.getHibernateTemplate().find(hql, (Object[])params);
        ArrayList<FOptinfo> opts = new ArrayList<FOptinfo>();
        for (FVUseroptmoudlelist opm : ls) {
            FOptinfo opt = new FOptinfo();
            opt.setFormcode(opm.getFormcode());
            opt.setImgindex(opm.getImgindex());
            opt.setIsintoolbar(opm.getIsintoolbar());
            opt.setMsgno(opm.getMsgno());
            opt.setOpttype(opm.getOpttype());
            opt.setMsgprm(opm.getMsgprm());
            opt.setOptid(opm.getOptid());
            opt.setOptname(opm.getOptname());
            opt.setOpturl(opm.getOpturl());
            opt.setPreoptid(opm.getPreoptid());
            opt.setTopoptid(opm.getTopoptid());
            opts.add(opt);
            System.out.print(opt.getOpttype());
        }
        return opts;
    }

    public List<FOptdef> getMethodByUserAndOptid(String userCode, String optid) {
        String[] params = null;
        String hql = "FROM FVUseroptlist urv where urv.id.usercode=? and optid= ?";
        params = new String[]{userCode, optid};
        List ls = this.getHibernateTemplate().find(hql, (Object[])params);
        ArrayList<FOptdef> methods = new ArrayList<FOptdef>();
        for (FVUseroptlist opm : ls) {
            FOptdef method = new FOptdef();
            method.setOptcode(opm.getId().getOptcode());
            method.setOptid(opm.getOptid());
            method.setOptmethod(opm.getOptmethod());
            method.setOptname(opm.getOptname());
            methods.add(method);
        }
        return methods;
    }

    public List<FVUseroptlist> getAllOptMethodByUser(String userCode) {
        String[] params = null;
        String hql = "FROM FVUseroptlist urv where urv.id.usercode=?";
        params = new String[]{userCode};
        List ls = this.getHibernateTemplate().find(hql, (Object[])params);
        return ls;
    }

    public List<FOptRoleMap> getAllOptRoleMap() {
        String sSqlsen = "select c.opturl,b.optmethod,a.rolecode,c.optid,b.optcode from F_ROLEPOWER a join F_OPTDEF b on(a.optcode=b.optcode) join f_optinfo c on(b.optid=c.optid) where c.OptType<>'W' and c.opturl<>'...' order by c.opturl,b.optmethod,a.rolecode";
        List l = this.findObjectsBySql(sSqlsen, FOptRoleMap.class);
        return l;
    }

    public List<FOptinfo> getParentMenu() {
        String hql1 = "FROM FOptinfo where OPTURL='...' order by PREOPTID ";
        List parentMenuList = this.getHibernateTemplate().find(hql1);
        return parentMenuList;
    }

    public List<FVUseroptmoudlelist> getMenuItem(String userID) {
        String hql = "FROM FVUseroptmoudlelist where isintoolbar='Y' and usercode=? ORDER BY orderind";
        String[] params = new String[]{userID};
        return this.getHibernateTemplate().find(hql, (Object[])params);
    }

    public List<FVUseroptmoudlelist> getMenuItem(String userID, String pid) {
        String hql = "FROM FVUseroptmoudlelist where isintoolbar='Y' and usercode=? and preoptid = ? ORDER BY orderind";
        String[] params = new String[]{userID, pid};
        return this.getHibernateTemplate().find(hql, (Object[])params);
    }

    public List<FVUseroptmoudlelist> getMenuItem(FUserinfo fUserinfo) {
        if (null != fUserinfo && !"".equals(fUserinfo.getUsercode())) {
            return this.getMenuItem(fUserinfo.getUsercode());
        }
        return null;
    }

    public FOptinfo getFOptinfo(String optid) {
        return null;
    }
}

