/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service;

import com.centit.support.utils.StringRegularOpt;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.CodeRepositoryUtil;
import com.centit.sys.service.ExpCalcContext;
import com.centit.sys.service.SysVariableTranslate;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysUnitFilterEngine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SysUnitFilterEngine.class);

    public static Set<String> nullSubUnits(int nTiers) {
        HashSet<String> units = new HashSet<String>();
        if (nTiers < 1) {
            return units;
        }
        for (Map.Entry<String, FUnitinfo> unitEnt : CodeRepositoryManager.UNITREPO.entrySet()) {
            String puc = unitEnt.getValue().getParentunit();
            if (puc != null && !"0".equals(puc) && !"".equals(puc) || !"T".equals(unitEnt.getValue().getIsvalid())) continue;
            units.add(unitEnt.getKey());
        }
        return SysUnitFilterEngine.subUnits(units, nTiers - 1);
    }

    public static Set<String> nullParentUnits(int nTiers) {
        HashSet<String> units = new HashSet<String>();
        if (nTiers < 1) {
            return units;
        }
        for (Map.Entry<String, FUnitinfo> unitEnt : CodeRepositoryManager.UNITREPO.entrySet()) {
            Set<String> subUS = unitEnt.getValue().getSubUnits();
            if (subUS != null && subUS.size() != 0 || !"T".equals(unitEnt.getValue().getIsvalid())) continue;
            units.add(unitEnt.getKey());
        }
        return SysUnitFilterEngine.parentUnits(units, nTiers - 1);
    }

    public static Set<String> allSeriesUnits(Set<String> units) {
        if (units == null || units.size() == 0) {
            return units;
        }
        HashSet<String> retUnits = new HashSet<String>();
        for (String unitCode : units) {
            String tu = SysUnitFilterEngine.topUnit(unitCode);
            if (tu == null) continue;
            retUnits.add(tu);
        }
        retUnits.addAll(SysUnitFilterEngine.allSubUnits(retUnits));
        return retUnits;
    }

    public static Set<String> allSubUnits(Set<String> units) {
        if (units == null || units.size() == 0) {
            return units;
        }
        int preSize = 0;
        HashSet<String> retUnits = new HashSet<String>();
        Set<String> midUnits = units;
        while (midUnits != null && midUnits.size() != 0) {
            retUnits.addAll(midUnits);
            if (preSize == retUnits.size()) break;
            preSize = retUnits.size();
            midUnits = SysUnitFilterEngine.subUnits(midUnits, 1);
        }
        return retUnits;
    }

    public static Set<String> allTopUnits(Set<String> units) {
        if (units == null || units.size() == 0) {
            return units;
        }
        HashSet<String> retUnits = new HashSet<String>();
        for (String unitCode : units) {
            String puc;
            FUnitinfo u = CodeRepositoryUtil.getUnitInfoByCode(unitCode);
            while (u != null && (puc = u.getParentunit()) != null && !"0".equals(puc) && !"".equals(puc)) {
                u = CodeRepositoryUtil.getUnitInfoByCode(puc);
                if (u == null) continue;
                retUnits.add(u.getUnitcode());
            }
        }
        return retUnits;
    }

    public static Set<String> subUnits(Set<String> units, int nTiers) {
        if (nTiers < 1 || units == null || units.size() == 0) {
            return units;
        }
        Set<String> midUnits = units;
        for (int i = 0; i < nTiers; ++i) {
            HashSet<String> retUnits = new HashSet<String>();
            for (String suc : midUnits) {
                FUnitinfo u = CodeRepositoryUtil.getUnitInfoByCode(suc);
                if (u == null) continue;
                retUnits.addAll(u.getSubUnits());
            }
            midUnits = retUnits;
        }
        return midUnits;
    }

    public static Set<String> parentUnits(Set<String> units, int nTiers) {
        if (nTiers < 1 || units == null || units.size() == 0) {
            return units;
        }
        Set<String> midUnits = units;
        for (int i = 0; i < nTiers; ++i) {
            HashSet<String> retUnits = new HashSet<String>();
            for (String suc : midUnits) {
                FUnitinfo u = CodeRepositoryUtil.getUnitInfoByCode(suc);
                String puc = u.getParentunit();
                if (puc == null || "0".equals(puc) || "".equals(puc)) continue;
                retUnits.add(puc);
            }
            midUnits = retUnits;
        }
        return midUnits;
    }

    public static String topUnit(String unitCode) {
        String topUnit = null;
        String retUnitCode = unitCode;
        FUnitinfo u;
        while ((u = CodeRepositoryUtil.getUnitInfoByCode(retUnitCode)) != null) {
            topUnit = retUnitCode;
            String puc = u.getParentunit();
            if (puc == null || "0".equals(puc) || "".equals(puc)) {
                return retUnitCode;
            }
            retUnitCode = puc;
        }
        return topUnit;
    }

    public static Set<String> topUnits(Set<String> units, int nTiers) {
        if (nTiers < 1) {
            return units;
        }
        HashSet<String> retUnits = new HashSet<String>();
        for (String unitCode : units) {
            String tu = SysUnitFilterEngine.topUnit(unitCode);
            if (tu == null) continue;
            retUnits.add(tu);
        }
        return SysUnitFilterEngine.subUnits(retUnits, nTiers - 1);
    }

    private static Set<String> calcSimpleExp(ExpCalcContext ecc) {
        Set<String> units = new HashSet<String>();
        String w = ecc.getAWord();
        if (ExpCalcContext.isLabel((String)w)) {
            if ("all".equalsIgnoreCase(w)) {
                for (String unitCode : CodeRepositoryManager.UNITREPO.keySet()) {
                    units.add(unitCode);
                }
            } else if ("empty".equalsIgnoreCase(w)) {
                w = ecc.getAWord();
                if ("-".equals(w)) {
                    w = ecc.getAWord();
                    if (!StringRegularOpt.isNumber((String)w)) {
                        ecc.setLastErrMsg(w + " is unexpected, expect number; calcSimpleUnit null- .");
                        return null;
                    }
                    units = SysUnitFilterEngine.nullParentUnits(Integer.valueOf(w));
                } else if ("+".equals(w)) {
                    w = ecc.getAWord();
                    if (!StringRegularOpt.isNumber((String)w)) {
                        ecc.setLastErrMsg(w + " is unexpected, expect number; calcSimpleUnit null+ . ");
                        return null;
                    }
                    units = SysUnitFilterEngine.nullSubUnits(Integer.valueOf(w));
                } else {
                    ecc.setPreword(w);
                }
            } else {
                Set<String> us = ecc.getUnitCode(w);
                if (us != null) {
                    units.addAll(us);
                }
            }
        } else if (StringRegularOpt.isString((String)w)) {
            String unitCode = StringRegularOpt.trimString((String)w);
            if (CodeRepositoryUtil.getUnitInfoByCode(unitCode) != null) {
                units.add(unitCode);
            }
        } else {
            ecc.setLastErrMsg(w + " is unexpected, expect label or string [unitcode]; calcSimpleUnit label . ");
            return null;
        }
        w = ecc.getAWord();
        if ("-".equals(w)) {
            w = ecc.getAWord();
            StringRegularOpt.isNumber((String)w);
            if (!StringRegularOpt.isNumber((String)w)) {
                ecc.setLastErrMsg(w + " is unexpected, expect number ; calcSimpleUnit - . ");
                return null;
            }
            units = SysUnitFilterEngine.parentUnits(units, Integer.valueOf(w));
            w = ecc.getAWord();
            if ("+".equals(w)) {
                w = ecc.getAWord();
                if (!StringRegularOpt.isNumber((String)w)) {
                    ecc.setLastErrMsg(w + " is unexpected, expect number ; calcSimpleUnit -+ .");
                    return null;
                }
                units = SysUnitFilterEngine.subUnits(units, Integer.valueOf(w));
            } else {
                ecc.setPreword(w);
            }
        } else if ("+".equals(w)) {
            w = ecc.getAWord();
            if (!StringRegularOpt.isNumber((String)w)) {
                ecc.setLastErrMsg(w + " is unexpected, expect number; calcSimpleUnit + . ");
                return null;
            }
            units = SysUnitFilterEngine.subUnits(units, Integer.valueOf(w));
        } else if ("*".equals(w)) {
            w = ecc.getAWord();
            if ("*".equals(w)) {
                units = SysUnitFilterEngine.allSeriesUnits(units);
            } else if (!StringRegularOpt.isNumber((String)w)) {
                ecc.setLastErrMsg(w + " is unexpected, expect number ; calcSimpleUnit *.");
                return null;
            }
            units = SysUnitFilterEngine.topUnits(units, Integer.valueOf(w));
        } else if ("++".equals(w)) {
            units = SysUnitFilterEngine.allSubUnits(units);
        } else if ("--".equals(w)) {
            units = SysUnitFilterEngine.allTopUnits(units);
        } else {
            ecc.setPreword(w);
        }
        return units;
    }

    private static Set<String> calcSingleExp(ExpCalcContext ecc) {
        String w = ecc.getAWord();
        if (!"(".equals(w)) {
            ecc.setLastErrMsg(w + " is unexpected, expect '(' ; calcSingleUnit begin .");
            return null;
        }
        Set<String> units = SysUnitFilterEngine.calcUnitsExp(ecc);
        if (units == null) {
            return null;
        }
        while (units == null || units.size() == 0) {
            w = ecc.getAWord();
            if (")".equals(w)) {
                return units;
            }
            if (",".equals(w)) {
                units = SysUnitFilterEngine.calcUnitsExp(ecc);
                continue;
            }
            ecc.setLastErrMsg(w + " is unexpected, expect ',' or ')' ; calcSingleUnit end .");
            return null;
        }
        ecc.seekToRightBracket();
        return units;
    }

    private static Set<String> calcItemExp(ExpCalcContext ecc) {
        String w = ecc.getAWord();
        if (w == null || "".equals(w)) {
            ecc.setLastErrMsg("End of file is unexpected; calcItemUnit begin ");
            return null;
        }
        if ("(".equals(w)) {
            Set<String> units = SysUnitFilterEngine.calcUnitsExp(ecc);
            w = ecc.getAWord();
            if (")".equals(w)) {
                return units;
            }
            ecc.setLastErrMsg(w + " is unexpected, expect ')'; calcItemUnit (unitExp) end ");
            return null;
        }
        if ("S".equalsIgnoreCase(w)) {
            return SysUnitFilterEngine.calcSingleExp(ecc);
        }
        ecc.setPreword(w);
        return SysUnitFilterEngine.calcSimpleExp(ecc);
    }

    public static Set<String> calcUnitsExp(ExpCalcContext ecc) {
        String w;
        Set<String> units = SysUnitFilterEngine.calcItemExp(ecc);
        if (units == null) {
            return null;
        }
        while (true) {
            Set<String> units2;
            if ((w = ecc.getAWord()) == null || "".equals(w)) {
                return units;
            }
            if (",".equals(w) || ")".equals(w)) {
                ecc.setPreword(w);
                return units;
            }
            if ("|".equals(w) || "||".equals(w)) {
                units2 = SysUnitFilterEngine.calcItemExp(ecc);
                if (units2 == null) {
                    return null;
                }
                units.addAll(units2);
                continue;
            }
            if ("&".equals(w) || "&&".equals(w)) {
                units2 = SysUnitFilterEngine.calcItemExp(ecc);
                if (units2 == null) {
                    return null;
                }
                units.retainAll(units2);
                continue;
            }
            if (!"!".equals(w)) break;
            units2 = SysUnitFilterEngine.calcItemExp(ecc);
            if (units2 == null) {
                return null;
            }
            units.removeAll(units2);
        }
        ecc.setLastErrMsg(w + " is unexpected, expect '||','&&','!',',' or ')'; calcUnitsExp end  ");
        return null;
    }

    public static Set<String> calcUnitsByExp(String unitExp, String lastSameNodeUnit, String userUnit, String previousNodeUnit, String flowUnit, SysVariableTranslate varTrans) {
        if (unitExp == null) {
            return null;
        }
        ExpCalcContext ecc = new ExpCalcContext();
        ecc.setFormula(unitExp);
        ecc.setVarTrans(varTrans);
        ecc.addUnitParam("L", lastSameNodeUnit);
        ecc.addUnitParam("U", userUnit);
        ecc.addUnitParam("P", previousNodeUnit);
        ecc.addUnitParam("F", flowUnit);
        Set<String> untis = SysUnitFilterEngine.calcUnitsExp(ecc);
        if (ecc.hasError()) {
            log.error((Object)ecc.getLastErrMsg());
        }
        return untis;
    }

    public static Set<String> calcUnitsExp(String unitExp, String lastSameNodeUnit, String userUnit, String previousNodeUnit, String flowUnit, SysVariableTranslate varTrans) {
        return SysUnitFilterEngine.calcUnitsByExp(unitExp, lastSameNodeUnit, userUnit, previousNodeUnit, flowUnit, varTrans);
    }

    public static String calcSingleUnitByExp(String unitExp, String lastSameNodeUnit, String userUnit, String previousNodeUnit, String flowUnit, SysVariableTranslate varTrans) {
        Set<String> untis = SysUnitFilterEngine.calcUnitsByExp(unitExp, lastSameNodeUnit, userUnit, previousNodeUnit, flowUnit, varTrans);
        if (untis == null || untis.size() == 0) {
            return null;
        }
        return untis.iterator().next();
    }

    public static String calcSingleUnitExp(String unitExp, String lastSameNodeUnit, String userUnit, String previousNodeUnit, String flowUnit, SysVariableTranslate varTrans) {
        return SysUnitFilterEngine.calcSingleUnitByExp(unitExp, lastSameNodeUnit, userUnit, previousNodeUnit, flowUnit, varTrans);
    }

    public static String validateUnitsExp(String unitExp) {
        ExpCalcContext ecc = new ExpCalcContext();
        ecc.setFormula(unitExp);
        SysUnitFilterEngine.calcUnitsExp(ecc);
        if (ecc.hasError()) {
            return ecc.getLastErrMsg();
        }
        return "T";
    }
}

