/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service.impl;

import com.centit.core.dao.BaseDao;
import com.centit.core.service.BaseEntityManagerImpl;
import com.centit.sys.dao.UnitInfoDao;
import com.centit.sys.dao.UserUnitDao;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserunit;
import com.centit.sys.po.FUserunitId;
import com.centit.sys.service.SysUnitManager;
import java.io.Serializable;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysUnitManagerImpl
extends BaseEntityManagerImpl<FUnitinfo>
implements SysUnitManager {
    private static final long serialVersionUID = 1L;
    private UnitInfoDao sysunitdao;
    private UserUnitDao unituserDao;

    public void setSysunitdao(UnitInfoDao unitdao) {
        this.setBaseDao((BaseDao)unitdao);
        this.sysunitdao = unitdao;
    }

    public void setUnituserDao(UserUnitDao userunitdao) {
        this.unituserDao = userunitdao;
    }

    @Override
    public List<FUnitinfo> getSubUnits(String superUnitID) {
        return this.sysunitdao.getSubUnits(superUnitID);
    }

    @Override
    public List<FUnitinfo> getAllSubUnits(String superUnitID) {
        return this.sysunitdao.getAllSubUnits(superUnitID);
    }

    public FUnitinfo getObject(FUnitinfo object) {
        FUnitinfo newObj = (FUnitinfo)this.sysunitdao.getObjectById((Serializable)((Object)object.getUnitcode()));
        if (newObj == null) {
            newObj = object;
            newObj.setUnitcode(this.sysunitdao.getNextKey());
            newObj.setIsvalid("T");
        }
        return newObj;
    }

    @Override
    public List<FUserunit> getSysUsersByUnitId(String unitCode) {
        return this.sysunitdao.getSysUsersByUnitId(unitCode);
    }

    @Override
    public List<FUserinfo> getUnitUsers(String unitCode) {
        return this.sysunitdao.getUnitUsers(unitCode);
    }

    @Override
    public List<FUserunit> getSysUnitsByUserId(String userId) {
        return this.sysunitdao.getSysUnitsByUserId(userId);
    }

    @Override
    public List<FUserinfo> getRelationUsers(String unitCode) {
        return this.sysunitdao.getRelationUsers(unitCode);
    }

    @Override
    public FUserunit findUnitUserById(FUserunitId id) {
        return (FUserunit)this.unituserDao.getObjectById(id);
    }

    @Override
    public void saveUnitUser(FUserunit object) {
        this.unituserDao.saveObject(object);
    }

    @Override
    public String getUnitCode(String depno) {
        return this.sysunitdao.getUnitCode(depno);
    }

    @Override
    public String getNextKey() {
        return this.sysunitdao.getNextKey();
    }

    @Override
    public void deleteUnitUser(FUserunitId id) {
        this.unituserDao.deleteObjectById(id);
    }

    @Override
    public List<FUserunit> getSysUsersByRoleAndUnit(String roleType, String roleCode, String unitCode) {
        return this.unituserDao.getSysUsersByRoleAndUnit(roleType, roleCode, unitCode);
    }

    @Override
    public String getAllUnitsJSON() {
        List unitList = this.sysunitdao.listObjects();
        return this.unitList2JSON(unitList);
    }

    @Override
    public String getAllSubUnitsJSON(String unitCode) {
        List<FUnitinfo> unitList = this.sysunitdao.getAllSubUnits(unitCode);
        return this.unitList2JSON(unitList);
    }

    @Override
    public String getAllUnitsJSON(String unitCode) {
        List<FUnitinfo> unitList = this.sysunitdao.getAllSubUnits(unitCode);
        return this.unit2JSON(unitList);
    }

    @Override
    public String getAllUnitsJSONNoTree() {
        List unitList = this.sysunitdao.listObjects();
        return this.unit2JSON(unitList);
    }

    private String unitList2JSON(List<FUnitinfo> unitList) {
        if (unitList == null) {
            return "";
        }
        JSONArray jsonArr = new JSONArray();
        for (FUnitinfo unitInfo : unitList) {
            if (unitInfo.getUnitname() == null || unitInfo.getUnitname().equals("")) continue;
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"MID", (Object)unitInfo.getUnitcode());
            jsonObj.put((Object)"ParentID", (Object)unitInfo.getParentunit());
            jsonObj.put((Object)"MText", (Object)unitInfo.getUnitname());
            jsonObj.put((Object)"depno", (Object)unitInfo.getDepno());
            jsonArr.add((Object)jsonObj);
        }
        return jsonArr.toString();
    }

    private String unit2JSON(List<FUnitinfo> unitList) {
        if (unitList == null) {
            return "";
        }
        JSONArray jsonArr = new JSONArray();
        for (FUnitinfo unitInfo : unitList) {
            if (unitInfo.getUnitname() == null || unitInfo.getUnitname().equals("")) continue;
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"nodeID", (Object)unitInfo.getUnitcode());
            jsonObj.put((Object)"name", (Object)unitInfo.getUnitname());
            jsonArr.add((Object)jsonObj);
        }
        return jsonArr.toString();
    }

    @Override
    public FUnitinfo getUnitByName(String name) {
        return this.sysunitdao.getUnitByName(name);
    }
}

