/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.service.impl;

import com.centit.core.dao.BaseDao;
import com.centit.core.service.BaseEntityManagerImpl;
import com.centit.core.service.ObjectException;
import com.centit.core.utils.PageDesc;
import com.centit.support.utils.DatetimeOpt;
import com.centit.sys.dao.OptInfoDao;
import com.centit.sys.dao.UnitInfoDao;
import com.centit.sys.dao.UserInfoDao;
import com.centit.sys.dao.UserRoleDao;
import com.centit.sys.dao.UserSettingDao;
import com.centit.sys.dao.UserUnitDao;
import com.centit.sys.dao.VUserUnitsDao;
import com.centit.sys.po.FDatadictionary;
import com.centit.sys.po.FRoleinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserrole;
import com.centit.sys.po.FUserroleId;
import com.centit.sys.po.FUserunit;
import com.centit.sys.po.FUserunitId;
import com.centit.sys.po.FVUseroptlist;
import com.centit.sys.po.Usersetting;
import com.centit.sys.po.VUserUnits;
import com.centit.sys.security.FUserDetail;
import com.centit.sys.service.CodeRepositoryUtil;
import com.centit.sys.service.SysUserManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysUserManagerImpl
extends BaseEntityManagerImpl<FUserinfo>
implements SysUserManager,
UserDetailsService,
AuthenticationUserDetailsService {
    private static final long serialVersionUID = 1L;
    Md5PasswordEncoder passwordEncoder;
    private UserInfoDao sysuserdao;
    private UserUnitDao unituserDao;
    private UnitInfoDao sysunitdao;
    private UserRoleDao userRoleDao;
    private UserSettingDao userSettingdao;
    private OptInfoDao functionDao;
    private VUserUnitsDao vUserUnitsDao;

    public void setPasswordEncoder(Md5PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public String encodePassword(String password, String usercode) {
        return this.passwordEncoder.encodePassword(password, (Object)usercode);
    }

    private String getDefaultPassword(String usercode) {
        String defaultPassword = "000000";
        return this.encodePassword("000000", usercode);
    }

    public void setSysuserDao(UserInfoDao userdao) {
        this.setBaseDao((BaseDao)userdao);
        this.sysuserdao = userdao;
    }

    public void setUnituserDao(UserUnitDao userunitdao) {
        this.unituserDao = userunitdao;
    }

    public void setSysunitDao(UnitInfoDao sysunitdao) {
        this.sysunitdao = sysunitdao;
    }

    public void setUserSettingDao(UserSettingDao usersettingdao) {
        this.userSettingdao = usersettingdao;
    }

    public void setUserRoleDao(UserRoleDao sysusrodao) {
        this.userRoleDao = sysusrodao;
    }

    public void setFunctionDao(OptInfoDao dao) {
        this.functionDao = dao;
    }

    @Override
    public List<FRoleinfo> getSysRolesByUsid(String usercode) {
        List<FRoleinfo> roles = this.userRoleDao.getSysRolesByUsid(usercode);
        return roles;
    }

    @Override
    public List<FUserrole> getUserRoles(String usercode, String rolePrefix) {
        return this.userRoleDao.getUserRolesByUsid(usercode, rolePrefix);
    }

    @Override
    public List<FUserrole> getAllUserRoles(String usercode, String rolePrefix) {
        return this.userRoleDao.getAllUserRolesByUsid(usercode, rolePrefix);
    }

    @Override
    public Collection<GrantedAuthority> loadUserAuthorities(String loginname) throws UsernameNotFoundException {
        FUserDetail sysuser = (FUserDetail)this.sysuserdao.loadUserByLoginname(loginname);
        sysuser.setSysusrodao(this.userRoleDao);
        List<FRoleinfo> roles = this.getSysRolesByUsid(sysuser.getUsercode());
        sysuser.setAuthoritiesByRoles(roles);
        return sysuser.getAuthorities();
    }

    @Override
    public FUserDetail loadUserByUsername(String loginname) throws UsernameNotFoundException, DataAccessException {
        FUserDetail sysuser = (FUserDetail)this.sysuserdao.loadUserByLoginname(loginname.toLowerCase());
        sysuser.setSysusrodao(this.userRoleDao);
        List<FRoleinfo> roles = this.getSysRolesByUsid(sysuser.getUsercode());
        List<FUserunit> usun = this.sysunitdao.getSysUnitsByUserId(sysuser.getUsercode());
        sysuser.setUserUnits(usun);
        sysuser.setUserSetting(this.getUserSetting(sysuser.getUsercode()));
        sysuser.setUserFuncs(this.functionDao.getMenuFuncByUserID(sysuser.getUsercode()));
        sysuser.setAuthoritiesByRoles(roles);
        List<FVUseroptlist> uoptlist = this.functionDao.getAllOptMethodByUser(sysuser.getUsercode());
        HashMap<String, String> userOptList = new HashMap<String, String>();
        if (uoptlist != null) {
            for (FVUseroptlist opt : uoptlist) {
                userOptList.put(opt.getOptid() + "-" + opt.getOptmethod(), "T");
            }
        }
        sysuser.setUserOptList(userOptList);
        return sysuser;
    }

    public UserDetails loadUserDetails(Authentication token) throws UsernameNotFoundException {
        FUserDetail ud = this.loadUserByUsername(token.getName());
        return ud;
    }

    @Override
    public void resetPwd(String usid) {
        FUserinfo user = (FUserinfo)this.sysuserdao.getObjectById((Serializable)((Object)usid));
        user.setUserpin(this.getDefaultPassword(user.getUsercode()));
        this.sysuserdao.saveObject(user);
    }

    @Override
    public void setNewPassword(String userID, String oldPassword, String newPassword) {
        FUserinfo user = (FUserinfo)this.sysuserdao.getObjectById((Serializable)((Object)userID));
        if (!user.getUserpin().equals(this.encodePassword(oldPassword, user.getUsercode()))) {
            throw new ObjectException("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        user.setUserpin(this.encodePassword(newPassword, user.getUsercode()));
        this.sysuserdao.saveObject(user);
    }

    public void saveObject(FUserinfo sysuser) {
        boolean hasExist = this.sysuserdao.checkIfUserExists(sysuser);
        if (StringUtils.isBlank((String)sysuser.getUsercode())) {
            sysuser.setIsvalid("T");
            sysuser.setUserpin(this.getDefaultPassword(sysuser.getUsercode()));
        }
        if (!hasExist && StringUtils.isBlank((String)sysuser.getUserpin())) {
            sysuser.setUserpin(this.getDefaultPassword(sysuser.getUsercode()));
        }
        this.sysuserdao.saveObject(sysuser);
    }

    @Override
    public FUserrole getFUserroleByID(FUserroleId id) {
        return (FUserrole)this.userRoleDao.getObjectById(id);
    }

    @Override
    public List<FUserunit> getSysUnitsByUserId(String userCode) {
        return this.sysunitdao.getSysUnitsByUserId(userCode);
    }

    @Override
    public FUserunit getUserPrimaryUnit(String userId) {
        return this.sysunitdao.getUserPrimaryUnit(userId);
    }

    @Override
    public FUserunit findUserUnitById(FUserunitId id) {
        return (FUserunit)this.unituserDao.getObjectById(id);
    }

    @Override
    public void saveUserUnit(FUserunit userunit) {
        FUserunit pUserUnit;
        FDatadictionary agencyMode = SysUserManagerImpl.getAgencyMode();
        if (agencyMode == null) {
            agencyMode = new FDatadictionary();
        }
        if (("O".equalsIgnoreCase(agencyMode.getDatavalue()) || "D".equalsIgnoreCase(agencyMode.getExtracode())) && null != (pUserUnit = this.sysunitdao.getUserPrimaryUnit(userunit.getUsercode()))) {
            this.deleteUserUnit(pUserUnit.getId());
        }
        FUserunitId id = new FUserunitId();
        id.setUsercode(userunit.getUsercode());
        id.setUnitcode(userunit.getUnitcode());
        id.setUserrank(userunit.getUserrank());
        id.setUserstation(userunit.getUserstation());
        FUserunit dbobject = this.findUserUnitById(id);
        if (dbobject != null) {
            dbobject.copyNotNullProperty(userunit);
            userunit = dbobject;
        }
        if (userunit.getIsprimary() != null && "T".equals(userunit.getIsprimary())) {
            this.sysuserdao.deleteOtherPrimaryUnit(userunit);
        }
        this.unituserDao.saveObject(userunit);
    }

    @Override
    public void saveUserUnit(FUserinfo userinfo, FUserunit userunit) {
        userinfo.setPrimaryUnit(userunit.getUnitcode());
        this.sysuserdao.saveObject(userinfo);
        this.saveUserUnit(userunit);
    }

    @Override
    public void saveUserUnit(FUserunit object, FUserunit oldObject) {
        this.unituserDao.deleteObject(oldObject);
        if (object.getIsprimary() != null && "T".equals(object.getIsprimary())) {
            this.sysuserdao.deleteOtherPrimaryUnit(object);
        }
        this.unituserDao.saveObject(object);
    }

    @Override
    public void saveUserUnitFromXc(FUserunit object) {
        this.unituserDao.saveObject(object);
    }

    @Override
    public void deleteUserUnit(FUserunitId id) {
        this.unituserDao.deleteObjectById(id);
    }

    @Override
    public FUserrole getValidUserrole(String usercode, String rolecode) {
        return this.userRoleDao.getValidUserrole(usercode, rolecode);
    }

    @Override
    public int deleteUserrole(String usercode, String rolecode) {
        FUserrole userrole = this.getValidUserrole(usercode, rolecode);
        return this.deleteUserrole(userrole);
    }

    @Override
    public int deleteUserrole(FUserroleId id) {
        FUserrole userrole = this.getFUserroleByID(id);
        return this.deleteUserrole(userrole);
    }

    @Override
    public int deleteUserrole(FUserrole userrole) {
        if (userrole == null) {
            return -1;
        }
        Date today = new Date(System.currentTimeMillis());
        if (userrole.getObtaindate().after(today)) {
            this.userRoleDao.deleteObject(userrole);
            return 1;
        }
        if (userrole.getSecededate() == null || userrole.getSecededate().after(today)) {
            userrole.setSecededateToToday();
            this.userRoleDao.saveObject(userrole);
            return 2;
        }
        return 3;
    }

    @Override
    public void saveUserrole(FUserrole userrole) {
        this.userRoleDao.saveObject(userrole);
    }

    @Override
    public String getNextUserCode(char cType) {
        String sKey = "00000000000" + this.sysuserdao.getNextValueOfSequence("S_USERCODE");
        return cType + sKey.substring(sKey.length() - 7);
    }

    @Override
    public Usersetting getUserSetting(String usercode) {
        Usersetting us = (Usersetting)this.userSettingdao.getObjectById((Serializable)((Object)usercode));
        if (us == null) {
            us = (Usersetting)this.userSettingdao.getObjectById((Serializable)((Object)"default"));
        }
        return us;
    }

    @Override
    public FUserunit getUserunitByUserid(String userid) {
        return this.unituserDao.getUserunitByUserid(userid);
    }

    @Override
    public String getJSONUsers() {
        List userList = this.sysuserdao.listObjects();
        JSONArray jsonArr = new JSONArray();
        for (FUserinfo userInfo : userList) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"usercode", (Object)userInfo.getUsercode());
            jsonObj.put((Object)"username", (Object)userInfo.getUsername());
            jsonArr.add((Object)jsonObj);
        }
        return jsonArr.toString();
    }

    @Override
    public List<FUserinfo> listUnderUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.sysuserdao.listUnderUnit(filterMap, pageDesc);
    }

    @Override
    public List<FUserinfo> listUnderUnit(Map<String, Object> filterMap) {
        return this.sysuserdao.listUnderUnit(filterMap);
    }

    @Override
    public List<FUserinfo> getUserUnderUnit(String unitcode) {
        return this.sysuserdao.getUserUnderUnit(unitcode);
    }

    @Override
    public void saveBatchUserRole(String rolecode, List<String> ucs) {
        ArrayList<String> userCodes = new ArrayList<String>(ucs);
        Date now = new Date();
        HashMap<String, String> paramFilter = new HashMap<String, String>();
        paramFilter.put("rolecode", rolecode);
        List userroles = this.userRoleDao.listObjects(paramFilter);
        if (CollectionUtils.isEmpty((Collection)userroles)) {
            for (String usercode : userCodes) {
                FUserrole userrole = new FUserrole(new FUserroleId(usercode, rolecode, new Date()));
                this.userRoleDao.saveObject(userrole);
            }
        } else {
            for (FUserrole userrole : userroles) {
                if (!userCodes.contains(userrole.getId().getUsercode())) {
                    if (userrole.getObtaindate().after(DatetimeOpt.truncateToDay((Date)now))) {
                        this.userRoleDao.deleteObject(userrole);
                        continue;
                    }
                    if (userrole.getSecededate() != null && !userrole.getSecededate().after(now)) continue;
                    userrole.setSecededateToToday();
                    this.userRoleDao.saveObject(userrole);
                    continue;
                }
                if (null != userrole.getSecededate() && !userrole.getSecededate().after(now)) continue;
                userCodes.remove(userrole.getId().getUsercode());
            }
            for (String usercode : userCodes) {
                FUserrole userrole = new FUserrole(new FUserroleId(usercode, rolecode, now));
                this.userRoleDao.saveObject(userrole);
            }
        }
    }

    public void setvUserUnitsDao(VUserUnitsDao vUserUnitsDao) {
        this.vUserUnitsDao = vUserUnitsDao;
    }

    @Override
    public List<VUserUnits> getUnitUsers(String unitCode) {
        List<VUserUnits> unitUsers = this.vUserUnitsDao.getUnitUsers(unitCode);
        return unitUsers;
    }

    @Override
    public VUserUnits getUnitByUserCode(VUserUnits o) {
        return (VUserUnits)this.vUserUnitsDao.getObject(o);
    }

    public static FDatadictionary getAgencyMode() {
        List<FDatadictionary> sysparam = CodeRepositoryUtil.getDictionaryIgnoreD("SYSPARAM");
        for (FDatadictionary d : sysparam) {
            if (!"AgencyMode".equalsIgnoreCase(d.getId().getDatacode())) continue;
            return d;
        }
        return null;
    }

    @Override
    public void disabledUserrole(String usercode, String rolecode) {
        FUserrole userrole = this.getValidUserrole(usercode, rolecode);
        if (null == userrole) {
            return;
        }
        Date now = new Date();
        if (userrole.getObtaindate().after(DatetimeOpt.truncateToDay((Date)now))) {
            this.userRoleDao.deleteObject(userrole);
        } else if (userrole.getSecededate() == null || userrole.getSecededate().after(now)) {
            userrole.setSecededateToToday();
            this.userRoleDao.saveObject(userrole);
        }
    }
}

