/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.config;

import com.centit.framework.config.SecurityCasCondition;
import com.centit.framework.security.AjaxAuthenticationFailureHandler;
import com.centit.framework.security.AjaxAuthenticationSuccessHandler;
import com.centit.framework.security.DaoAccessDecisionManager;
import com.centit.framework.security.DaoFilterSecurityInterceptor;
import com.centit.framework.security.DaoInvocationSecurityMetadataSource;
import com.centit.framework.security.model.CentitSessionRegistry;
import com.centit.framework.security.model.CentitUserDetailsService;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;

@EnableWebSecurity
@Conditional(value={SecurityCasCondition.class})
public class SpringSecurityCasConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private Environment env;
    @Autowired
    public CentitSessionRegistry centitSessionRegistry;
    @Autowired
    private CentitUserDetailsService centitUserDetailsService;

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/system/login", "/service/exception/**", "/system/login/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ServiceProperties casServiceProperties = this.createCasServiceProperties();
        CasAuthenticationEntryPoint casEntryPoint = this.createCasEntryPoint(casServiceProperties);
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).logout().logoutSuccessUrl("/index.jsp").and()).exceptionHandling().accessDeniedPage("/service/exception/accessDenied").and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)casEntryPoint);
        AjaxAuthenticationSuccessHandler ajaxSuccessHandler = this.createAjaxSuccessHandler();
        AjaxAuthenticationFailureHandler ajaxFailureHandler = this.createAjaxFailureHandler();
        CasAuthenticationProvider casAuthenticationProvider = this.createCasAuthenticationProvider(casServiceProperties);
        AuthenticationManager authenticationManager = this.creatAuthenticationManager(casAuthenticationProvider);
        CasAuthenticationFilter casFilter = this.createCasFilter(authenticationManager, ajaxSuccessHandler, ajaxFailureHandler);
        DaoAccessDecisionManager centitAccessDecisionManagerBean = this.createCentitAccessDecisionManagerBean();
        DaoInvocationSecurityMetadataSource centitSecurityMetadataSource = this.createCentitSecurityMetadataSource();
        DaoFilterSecurityInterceptor centitPowerFilter = this.createCentitPowerFilter(authenticationManager, centitAccessDecisionManagerBean, centitSecurityMetadataSource);
        http.addFilterAt((Filter)casFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)centitPowerFilter, FilterSecurityInterceptor.class).addFilterBefore((Filter)this.requestSingleLogoutFilter(), LogoutFilter.class).addFilterBefore((Filter)this.singleLogoutFilter(), CasAuthenticationFilter.class);
    }

    private CasAuthenticationEntryPoint createCasEntryPoint(ServiceProperties casServiceProperties) {
        CasAuthenticationEntryPoint casEntryPoint = new CasAuthenticationEntryPoint();
        casEntryPoint.setLoginUrl(this.env.getProperty("cas.home") + "/login");
        casEntryPoint.setServiceProperties(casServiceProperties);
        return casEntryPoint;
    }

    private ServiceProperties createCasServiceProperties() {
        ServiceProperties casServiceProperties = new ServiceProperties();
        casServiceProperties.setService(this.env.getProperty("local.home") + "/login/cas");
        casServiceProperties.setSendRenew(false);
        return casServiceProperties;
    }

    private CasAuthenticationProvider createCasAuthenticationProvider(ServiceProperties casServiceProperties) {
        CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
        casAuthenticationProvider.setUserDetailsService((UserDetailsService)this.centitUserDetailsService);
        casAuthenticationProvider.setServiceProperties(casServiceProperties);
        casAuthenticationProvider.setTicketValidator((TicketValidator)new Cas20ServiceTicketValidator(this.env.getProperty("cas.home")));
        casAuthenticationProvider.setKey(this.env.getProperty("app.key"));
        return casAuthenticationProvider;
    }

    private DaoAccessDecisionManager createCentitAccessDecisionManagerBean() {
        return new DaoAccessDecisionManager();
    }

    private DaoInvocationSecurityMetadataSource createCentitSecurityMetadataSource() {
        return new DaoInvocationSecurityMetadataSource();
    }

    private DaoFilterSecurityInterceptor createCentitPowerFilter(AuthenticationManager authenticationManager, DaoAccessDecisionManager centitAccessDecisionManagerBean, DaoInvocationSecurityMetadataSource centitSecurityMetadataSource) {
        DaoFilterSecurityInterceptor centitPowerFilter = new DaoFilterSecurityInterceptor();
        centitPowerFilter.setAuthenticationManager(authenticationManager);
        centitPowerFilter.setAccessDecisionManager((AccessDecisionManager)centitAccessDecisionManagerBean);
        centitPowerFilter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)centitSecurityMetadataSource);
        centitPowerFilter.setSessionRegistry(this.centitSessionRegistry);
        return centitPowerFilter;
    }

    private AjaxAuthenticationFailureHandler createAjaxFailureHandler() {
        AjaxAuthenticationFailureHandler ajaxFailureHandler = new AjaxAuthenticationFailureHandler();
        ajaxFailureHandler.setDefaultFailureUrl("/system/mainframe/login/error");
        ajaxFailureHandler.setWriteLog(false);
        return ajaxFailureHandler;
    }

    private AjaxAuthenticationSuccessHandler createAjaxSuccessHandler() {
        AjaxAuthenticationSuccessHandler ajaxSuccessHandler = new AjaxAuthenticationSuccessHandler();
        ajaxSuccessHandler.setWriteLog(true);
        return ajaxSuccessHandler;
    }

    private CasAuthenticationFilter createCasFilter(AuthenticationManager authenticationManager, AjaxAuthenticationSuccessHandler ajaxSuccessHandler, AjaxAuthenticationFailureHandler ajaxFailureHandler) {
        CasAuthenticationFilter casFilter = new CasAuthenticationFilter();
        casFilter.setAuthenticationManager(authenticationManager);
        casFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)ajaxFailureHandler);
        casFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)ajaxSuccessHandler);
        return casFilter;
    }

    private SingleSignOutFilter singleLogoutFilter() {
        SingleSignOutFilter singleLogoutFilter = new SingleSignOutFilter();
        singleLogoutFilter.setCasServerUrlPrefix(this.env.getProperty("cas.home"));
        return singleLogoutFilter;
    }

    private LogoutFilter requestSingleLogoutFilter() {
        return new LogoutFilter(this.env.getProperty("cas.home") + "/logout", new LogoutHandler[]{new SecurityContextLogoutHandler()});
    }

    private AuthenticationManager creatAuthenticationManager(CasAuthenticationProvider casAuthenticationProvider) {
        ArrayList<CasAuthenticationProvider> providerList = new ArrayList<CasAuthenticationProvider>();
        providerList.add(casAuthenticationProvider);
        return new ProviderManager(providerList);
    }
}

