/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.config;

import com.centit.framework.config.SecurityDaoCondition;
import com.centit.framework.security.AjaxAuthenticationFailureHandler;
import com.centit.framework.security.AjaxAuthenticationSuccessHandler;
import com.centit.framework.security.DaoAccessDecisionManager;
import com.centit.framework.security.DaoFilterSecurityInterceptor;
import com.centit.framework.security.DaoInvocationSecurityMetadataSource;
import com.centit.framework.security.PretreatmentAuthenticationProcessingFilter;
import com.centit.framework.security.model.CentitPasswordEncoderImpl;
import com.centit.framework.security.model.CentitSessionRegistry;
import com.centit.framework.security.model.CentitUserDetailsService;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;

@EnableWebSecurity
@Conditional(value={SecurityDaoCondition.class})
public class SpringSecurityDaoConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private HttpSessionCsrfTokenRepository csrfTokenRepository;
    @Autowired
    private CentitPasswordEncoderImpl passwordEncoder;
    @Autowired
    private CentitUserDetailsService centitUserDetailsService;
    @Autowired
    private CentitSessionRegistry centitSessionRegistry;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/system/mainframe/login", "/system/mainframe/csrf", "/system/exception"})).anonymous().and()).exceptionHandling().accessDeniedPage("/system/exception/accessDenied").and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint());
        AuthenticationProvider authenticationProvider = this.createAuthenticationProvider();
        AuthenticationManager authenticationManager = this.createAuthenticationManager(authenticationProvider);
        DaoFilterSecurityInterceptor centitPowerFilter = this.createCentitPowerFilter(authenticationManager, (FilterInvocationSecurityMetadataSource)new DaoInvocationSecurityMetadataSource(), (AccessDecisionManager)new DaoAccessDecisionManager(), this.centitSessionRegistry);
        AuthenticationFailureHandler ajaxFailureHandler = this.createAjaxFailureHandler();
        AjaxAuthenticationSuccessHandler ajaxSuccessHandler = this.createAjaxSuccessHandler();
        UsernamePasswordAuthenticationFilter pretreatmentAuthenticationProcessingFilter = this.createPretreatmentAuthenticationProcessingFilter(authenticationManager, ajaxSuccessHandler, ajaxFailureHandler);
        http.addFilterAt((Filter)pretreatmentAuthenticationProcessingFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)centitPowerFilter, FilterSecurityInterceptor.class).addFilterAt((Filter)this.logoutFilter(), LogoutFilter.class);
    }

    private LoginUrlAuthenticationEntryPoint authenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint("/system/mainframe/login");
    }

    private DaoFilterSecurityInterceptor createCentitPowerFilter(AuthenticationManager authenticationManager, FilterInvocationSecurityMetadataSource centitSecurityMetadataSource, AccessDecisionManager centitAccessDecisionManagerBean, CentitSessionRegistry centitSessionRegistry) {
        DaoFilterSecurityInterceptor centitPowerFilter = new DaoFilterSecurityInterceptor();
        centitPowerFilter.setAuthenticationManager(authenticationManager);
        centitPowerFilter.setAccessDecisionManager(centitAccessDecisionManagerBean);
        centitPowerFilter.setSecurityMetadataSource(centitSecurityMetadataSource);
        centitPowerFilter.setSessionRegistry(centitSessionRegistry);
        return centitPowerFilter;
    }

    private AuthenticationFailureHandler createAjaxFailureHandler() {
        AjaxAuthenticationFailureHandler ajaxFailureHandler = new AjaxAuthenticationFailureHandler();
        ajaxFailureHandler.setDefaultFailureUrl("/system/mainframe/login/error");
        ajaxFailureHandler.setWriteLog(false);
        return ajaxFailureHandler;
    }

    private AjaxAuthenticationSuccessHandler createAjaxSuccessHandler() {
        AjaxAuthenticationSuccessHandler ajaxSuccessHandler = new AjaxAuthenticationSuccessHandler();
        ajaxSuccessHandler.setWriteLog(true);
        ajaxSuccessHandler.setUserDetailsService(this.centitUserDetailsService);
        return ajaxSuccessHandler;
    }

    private UsernamePasswordAuthenticationFilter createPretreatmentAuthenticationProcessingFilter(AuthenticationManager authenticationManager, AjaxAuthenticationSuccessHandler ajaxSuccessHandler, AuthenticationFailureHandler ajaxFailureHandler) {
        PretreatmentAuthenticationProcessingFilter pretreatmentAuthenticationProcessingFilter = new PretreatmentAuthenticationProcessingFilter();
        pretreatmentAuthenticationProcessingFilter.setAuthenticationManager(authenticationManager);
        pretreatmentAuthenticationProcessingFilter.setCheckCaptcha(false);
        pretreatmentAuthenticationProcessingFilter.setMaxTryTimes(0);
        pretreatmentAuthenticationProcessingFilter.setCheckTimeTnterval(3);
        pretreatmentAuthenticationProcessingFilter.setCheckType("loginName");
        pretreatmentAuthenticationProcessingFilter.setLockMinites(3);
        pretreatmentAuthenticationProcessingFilter.setContinueChainBeforeSuccessfulAuthentication(false);
        pretreatmentAuthenticationProcessingFilter.setAuthenticationFailureHandler(ajaxFailureHandler);
        pretreatmentAuthenticationProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)ajaxSuccessHandler);
        return pretreatmentAuthenticationProcessingFilter;
    }

    private LogoutFilter logoutFilter() {
        return new LogoutFilter("/system/mainframe/login", new LogoutHandler[]{new CsrfLogoutHandler((CsrfTokenRepository)this.csrfTokenRepository), new CookieClearingLogoutHandler(new String[]{"JSESSIONID", "remember-me"}), new SecurityContextLogoutHandler()});
    }

    private AuthenticationProvider createAuthenticationProvider() {
        DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider();
        authenticationProvider.setHideUserNotFoundExceptions(false);
        authenticationProvider.setUserDetailsService((UserDetailsService)this.centitUserDetailsService);
        authenticationProvider.setPasswordEncoder((Object)this.passwordEncoder);
        return authenticationProvider;
    }

    private AuthenticationManager createAuthenticationManager(AuthenticationProvider authenticationProvider) {
        ArrayList<AuthenticationProvider> providerList = new ArrayList<AuthenticationProvider>();
        providerList.add(authenticationProvider);
        return new ProviderManager(providerList);
    }
}

