/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.DatePropertiesEditor;
import com.centit.framework.core.controller.SqlDatePropertiesEditor;
import com.centit.framework.core.controller.SqlTimestampPropertiesEditor;
import com.centit.framework.core.controller.StringPropertiesEditor;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.framework.system.service.OptInfoManager;
import com.centit.framework.system.service.OptMethodManager;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.support.json.JsonPropertyUtils;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/roleinfo"})
public class RoleInfoController
extends BaseController {
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    @Resource
    @NotNull
    private OptInfoManager functionManager;
    @Resource
    @NotNull
    private OptMethodManager optDefManager;
    private String optId = "ROLEMAG";

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setAutoGrowCollectionLimit(1024);
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringPropertiesEditor(true));
        binder.registerCustomEditor(java.util.Date.class, (PropertyEditor)new DatePropertiesEditor());
        binder.registerCustomEditor(Date.class, (PropertyEditor)new SqlDatePropertiesEditor());
        binder.registerCustomEditor(Timestamp.class, (PropertyEditor)new SqlTimestampPropertiesEditor());
    }

    @RequestMapping(method={RequestMethod.GET})
    public void listGlobalAndPublicRole(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = RoleInfoController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("NP_GLOBAL", "true");
        if (!StringUtils.isEmpty(filterMap.get("createDateEnd"))) {
            String endDate = filterMap.get("createDateEnd").toString();
            SimpleDateFormat fmt = new SimpleDateFormat("yy-MM-dd");
            try {
                java.util.Date date = fmt.parse(endDate);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(5, 1);
                java.util.Date resultDate = calendar.getTime();
                String resultString = fmt.format(resultDate);
                filterMap.put("createDateEnd", resultString);
            }
            catch (ParseException e) {
                this.logger.error("\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            }
        }
        List<RoleInfo> roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData respData = new ResponseMapData();
        respData.addResponseData("objList", roleInfos);
        respData.addResponseData("pageDesc", (Object)pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(RoleInfo.class, (String[])field));
        } else {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(RoleInfo.class, (String[])new String[]{"rolePowers", "userRoles"}));
        }
    }

    @RequestMapping(value={"/unit/{unitCode}"}, method={RequestMethod.GET})
    public void listUnitAndPublicRole(String[] field, @PathVariable String unitCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = RoleInfoController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("UNITROLE", unitCode + "-%");
        List<RoleInfo> roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData respData = new ResponseMapData();
        respData.addResponseData("objList", roleInfos);
        respData.addResponseData("pageDesc", (Object)pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(RoleInfo.class, (String[])field));
        } else {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(RoleInfo.class, (String[])new String[]{"rolePowers", "userRoles"}));
        }
    }

    @RequestMapping(value={"/item"}, method={RequestMethod.GET})
    public void listItemRole(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = RoleInfoController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("ROLECODE", "I-%");
        List<RoleInfo> roleInfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData respData = new ResponseMapData();
        respData.addResponseData("objList", roleInfos);
        respData.addResponseData("pageDesc", (Object)pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(RoleInfo.class, (String[])field));
        } else {
            JsonResultUtils.writeResponseDataAsJson((ResponseData)respData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(RoleInfo.class, (String[])new String[]{"rolePowers", "userRoles"}));
        }
    }

    @RequestMapping(value={"/power/role/{roleCode}"}, method={RequestMethod.GET})
    public void getRolePowerByRoleCode(@PathVariable String roleCode, HttpServletResponse response) {
        List<RolePower> rolePowers = this.sysRoleManager.getRolePowers(roleCode);
        JsonResultUtils.writeSingleDataJson(rolePowers, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/power/defCode/{defCode}"}, method={RequestMethod.GET})
    public void getRolePowerByOptCode(@PathVariable String defCode, HttpServletResponse response) {
        List<RolePower> rolePowers = this.sysRoleManager.getRolePowersByDefCode(defCode);
        JsonResultUtils.writeSingleDataJson(rolePowers, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/power/optCode/{optId}"}, method={RequestMethod.GET})
    public void getRolePowerByOptId(@PathVariable String optId, HttpServletResponse response) {
        ArrayList result = new ArrayList();
        List<OptMethod> optDefs = this.optDefManager.listOptMethodByOptID(optId);
        for (OptMethod def : optDefs) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            List<RolePower> rolePowers = this.sysRoleManager.getRolePowersByDefCode(def.getOptCode());
            temp.put("optDef", def);
            temp.put("rolePowers", rolePowers);
            result.add(temp);
        }
        JsonResultUtils.writeSingleDataJson(result, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/global"}, method={RequestMethod.POST})
    public void createGlobalRole(@Valid RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        if (!roleInfo.getRoleCode().startsWith("G-")) {
            roleInfo.setRoleCode("G-" + roleInfo.getRoleCode());
        }
        roleInfo.setRoleType("S");
        roleInfo.setCreateDate(new java.util.Date());
        this.sysRoleManager.saveNewRoleInfo(roleInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)roleInfo.getRoleCode(), (String)"create", (String)"\u65b0\u589e\u89d2\u8272", (Object)roleInfo);
    }

    @RequestMapping(value={"/public"}, method={RequestMethod.POST})
    public void createPublicRole(@Valid RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        if (!roleInfo.getRoleCode().startsWith("P-")) {
            roleInfo.setRoleCode("P-" + roleInfo.getRoleCode());
        }
        roleInfo.setRoleType("S");
        roleInfo.setCreateDate(new java.util.Date());
        this.sysRoleManager.saveNewRoleInfo(roleInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)roleInfo.getRoleCode(), (String)"create", (String)"\u65b0\u589e\u89d2\u8272", (Object)roleInfo);
    }

    @RequestMapping(value={"/item"}, method={RequestMethod.POST})
    public void createItemRole(@Valid RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        if (!roleInfo.getRoleCode().startsWith("I-")) {
            roleInfo.setRoleCode("I-" + roleInfo.getRoleCode());
        }
        roleInfo.setRoleType("I");
        roleInfo.setCreateDate(new java.util.Date());
        this.sysRoleManager.saveNewRoleInfo(roleInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)roleInfo.getRoleCode(), (String)"create", (String)"\u65b0\u589e\u89d2\u8272", (Object)roleInfo);
    }

    @RequestMapping(value={"/dept/{unitcode}"}, method={RequestMethod.POST})
    public void createDeptRole(@PathVariable String unitcode, @Valid RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        if (!roleInfo.getRoleCode().startsWith(unitcode + "-")) {
            roleInfo.setRoleCode(unitcode + "-" + roleInfo.getRoleCode());
        }
        roleInfo.setRoleType("S");
        roleInfo.setUnitCode(unitcode);
        roleInfo.setCreateDate(new java.util.Date());
        this.sysRoleManager.saveNewRoleInfo(roleInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)roleInfo.getRoleCode(), (String)"create", (String)"\u65b0\u589e\u89d2\u8272", (Object)roleInfo);
    }

    @RequestMapping(value={"/addopt/{roleCode}/{optCode}"}, method={RequestMethod.PUT})
    public void addOptToRole(@PathVariable String roleCode, @PathVariable String optCode, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        RolePower rolePower = new RolePower(new RolePowerId(roleCode, optCode));
        if (dbRoleInfo.getRolePowers().contains(rolePower)) {
            JsonResultUtils.writeBlankJson((HttpServletResponse)response);
            return;
        }
        dbRoleInfo.getRolePowers().add(rolePower);
        this.sysRoleManager.updateRoleInfo(dbRoleInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)rolePower.getOptCode(), (String)"create", (String)("\u89d2\u8272" + dbRoleInfo.getRoleName() + "\u6dfb\u52a0\u6743\u9650:"), (Object)rolePower);
    }

    @RequestMapping(value={"/delopt/{roleCode}/{optCode}"}, method={RequestMethod.DELETE})
    public void deleteOptFormRole(@PathVariable String roleCode, @PathVariable String optCode, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        RolePower rolePower = new RolePower(new RolePowerId(roleCode, optCode));
        if (!dbRoleInfo.getRolePowers().contains(rolePower)) {
            JsonResultUtils.writeBlankJson((HttpServletResponse)response);
            return;
        }
        dbRoleInfo.getRolePowers().remove(rolePower);
        this.sysRoleManager.updateRoleInfo(dbRoleInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)rolePower.getOptCode(), (String)"delete", (String)("\u5220\u9664\u89d2\u8272" + dbRoleInfo.getRoleName() + "\u7684\u6743\u9650"), (Object)rolePower);
    }

    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.PUT})
    public void edit(@PathVariable String roleCode, @Valid RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        RoleInfo oldValue = new RoleInfo();
        oldValue.copy(dbRoleInfo);
        this.sysRoleManager.updateRoleInfo(roleInfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)roleCode, (String)"update", (String)"\u66f4\u65b0\u89d2\u8272\u4fe1\u606f", (Object)roleInfo, (Object)oldValue);
    }

    @RequestMapping(value={"/power/{roleCode}"}, method={RequestMethod.PUT})
    public void updateRolePower(@PathVariable String roleCode, RoleInfo roleInfo, HttpServletRequest request, HttpServletResponse response) {
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (null == dbRoleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        RoleInfo oldRoleInfo = new RoleInfo();
        oldRoleInfo.copy(dbRoleInfo);
        dbRoleInfo.setRolePowers(roleInfo.getRolePowers());
        List<RolePower> oldRolePowers = this.sysRoleManager.updateRolePower(dbRoleInfo);
        oldRoleInfo.setRolePowers(oldRolePowers);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)roleCode, (String)"update", (String)("\u66f4\u65b0\u89d2\u8272" + dbRoleInfo.getRoleName() + "\u6743\u9650"), (Object)dbRoleInfo, (Object)oldRoleInfo);
    }

    @RequestMapping(value={"/notexists/{roleCode}"}, method={RequestMethod.GET})
    public void isNotExists(@PathVariable String roleCode, HttpServletResponse response) throws IOException {
        if (roleCode.indexOf(45) < 1) {
            boolean notExist;
            boolean bl = notExist = this.sysRoleManager.getObjectById("G-" + roleCode) == null;
            if (notExist) {
                notExist = this.sysRoleManager.getObjectById("P-" + roleCode) == null;
            }
            JsonResultUtils.writeOriginalObject((Object)notExist, (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeOriginalObject((Object)(null == this.sysRoleManager.getObjectById(roleCode) ? 1 : 0), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/nameexists/{roleName}/{unitCode}"}, method={RequestMethod.GET})
    public void isNameExists(@PathVariable String roleName, @PathVariable String unitCode, HttpServletResponse response) {
        JsonResultUtils.writeOriginalObject((Object)this.sysRoleManager.isRoleNameNotExist(unitCode, roleName, null), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/isNameUnique/{roleName}/{roleCode}/{unitCode}"}, method={RequestMethod.GET})
    public void isNameUnique(@PathVariable String roleName, @PathVariable String roleCode, @PathVariable String unitCode, HttpServletResponse response) {
        JsonResultUtils.writeOriginalObject((Object)this.sysRoleManager.isRoleNameNotExist(unitCode, roleName, roleCode), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.DELETE})
    public void deleteRole(@PathVariable String roleCode, HttpServletRequest request, HttpServletResponse response) {
        if ("G-SYSADMIN".equalsIgnoreCase(roleCode) || "G-anonymous".equalsIgnoreCase(roleCode) || "G-DEPLOY".equalsIgnoreCase(roleCode)) {
            JsonResultUtils.writeErrorMessageJson((String)"\u7cfb\u7edf\u5185\u7f6e\u89d2\u8272\u4e0d\u80fd\u5220\u9664\u3002", (HttpServletResponse)response);
            return;
        }
        int n = this.sysRoleManager.countRoleUserSum(roleCode);
        if (n > 0) {
            JsonResultUtils.writeErrorMessageJson((String)"\u6709\u7528\u6237\u5f15\u7528\u8fd9\u4e2a\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (HttpServletResponse)response);
            return;
        }
        RoleInfo dbRoleInfo = this.sysRoleManager.getObjectById(roleCode);
        if (dbRoleInfo != null) {
            OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)roleCode, (String)"delete", (String)("\u5220\u9664\u89d2\u8272" + dbRoleInfo.getRoleName()), (Object)dbRoleInfo);
        }
        this.sysRoleManager.deleteRoleInfo(roleCode);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{roleCode}"}, method={RequestMethod.GET})
    public void findRoleInfo(@PathVariable String roleCode, HttpServletResponse response) {
        RoleInfo roleInfo = this.sysRoleManager.getRoleInfo(roleCode);
        if (null == roleInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        JsonResultUtils.writeSingleDataJson((Object)roleInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/power/unit/{unitCode}"}, method={RequestMethod.GET})
    public void getUnitInfoPower(@PathVariable String unitCode, HttpServletResponse response) {
        List<RolePower> rolePowers = this.sysRoleManager.getRolePowers("G$" + unitCode);
        JsonResultUtils.writeSingleDataJson(rolePowers, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/search/{key}"}, method={RequestMethod.GET})
    public void search(@PathVariable String key, String[] field, HttpServletResponse response) {
    }

    @RequestMapping(value={"/listRoles/{type}"}, method={RequestMethod.GET})
    public void listRoles(@PathVariable String type, String[] field, HttpServletRequest request, HttpServletResponse response) {
        if (ArrayUtils.isEmpty((Object[])field)) {
            field = new String[]{"roleCode", "roleName"};
        }
        Map filterMap = RoleInfoController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("roleType", "S");
        filterMap.put("isValid", "T");
        if ("S".equals(type)) {
            filterMap.put("NP_unitCode", true);
        } else if ("D".equals(type)) {
            CentitUserDetails user = this.getLoginUser(request);
            IUserUnit unit = CodeRepositoryUtil.getUserPrimaryUnit((String)user.getUserCode());
            if (unit != null) {
                filterMap.put("publicUnitRole", unit.getUnitCode() + "-%");
            } else {
                return;
            }
        }
        List<RoleInfo> listObjects = this.sysRoleManager.listObjects(filterMap);
        JsonResultUtils.writeSingleDataJson(listObjects, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(RoleInfo.class, (String[])field));
    }
}

