/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.json.JsonPropertyUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/unitinfo"})
public class UnitInfoController
extends BaseController {
    @Resource
    @NotNull
    private SysUnitManager sysUnitManager;
    @Resource
    @NotNull
    private SysUserManager sysUserMag;
    @Resource
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    @NotNull
    private SysRoleManager sysRoleManager;
    private String optId = "UNITMAG";

    @RequestMapping(method={RequestMethod.GET})
    public void list(String[] field, boolean struct, String id, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = UnitInfoController.convertSearchColumn((HttpServletRequest)request);
        String unitName = (String)searchColumn.get("unitName");
        if (StringUtils.isNotBlank((CharSequence)unitName) && StringUtils.isBlank((CharSequence)id)) {
            List<UnitInfo> listObjects = this.sysUnitManager.listObjects(searchColumn);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray(listObjects);
            if (struct) {
                ja = ListOpt.srotAsTreeAndToJSON((List)ja, (p, c) -> StringUtils.equals((CharSequence)((JSONObject)p).getString("unitCode"), (CharSequence)((JSONObject)c).getString("parentUnit")), (String)"children");
            }
            JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(JSONObject.class, (String[])field));
        } else {
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                filterMap.put("parentUnit", id);
            } else {
                filterMap.put("NP_TOPUnit", "true");
            }
            List<UnitInfo> listObjects = this.sysUnitManager.listObjects(filterMap);
            this.sysUnitManager.checkState(listObjects);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray(listObjects);
            JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response, null);
        }
    }

    @RequestMapping(value={"/subunits"}, method={RequestMethod.GET})
    public void listSub(String[] field, String id, HttpServletRequest request, HttpServletResponse response) {
        UserInfo user = this.sysUserMag.getObjectById(this.getLoginUser(request).getUserCode());
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("parentUnit", StringUtils.isNotBlank((CharSequence)id) ? id : user.getPrimaryUnit());
        List<UnitInfo> listObjects = this.sysUnitManager.listObjects(filterMap);
        if (listObjects == null) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
            return;
        }
        this.sysUnitManager.checkState(listObjects);
        JSONArray ja = DictionaryMapUtils.objectsToJSONArray(listObjects);
        JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(JSONObject.class, (String[])field));
    }

    @RequestMapping(value={"/underunits"}, method={RequestMethod.GET})
    public void allunits(String id, HttpServletRequest request, HttpServletResponse response) {
        UserInfo user = this.sysUserMag.getObjectById(this.getLoginUser(request).getUserCode());
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filterMap.put("parentUnit", id);
        } else {
            filterMap.put("unitCode", user.getPrimaryUnit());
        }
        List<UnitInfo> listObjects = this.sysUnitManager.listObjects(filterMap);
        if (listObjects == null) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
            return;
        }
        this.sysUnitManager.checkState(listObjects);
        JSONArray ja = new JSONArray();
        for (UnitInfo u : listObjects) {
            JSONObject json = (JSONObject)JSON.toJSON((Object)u);
            json.put("id", (Object)u.getUnitCode());
            json.put("text", (Object)u.getUnitName());
            ja.add((Object)json);
        }
        JsonResultUtils.writeSingleDataJson((Object)ja, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.GET})
    public void getUnitInfo(@PathVariable String unitCode, HttpServletResponse response) {
        UnitInfo unitInfo = this.sysUnitManager.getObjectById(unitCode);
        JsonResultUtils.writeSingleDataJson((Object)unitInfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String unitCode, HttpServletRequest request, HttpServletResponse response) {
        UnitInfo unitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (unitInfo == null) {
            JsonResultUtils.writeErrorMessageJson((String)"The object not found!", (HttpServletResponse)response);
            return;
        }
        this.sysUnitManager.deleteUnitInfo(unitInfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)unitInfo.getUnitCode(), (String)"delete", (String)("\u5220\u9664\u673a\u6784" + unitInfo.getUnitName()), (Object)unitInfo);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void create(@Valid UnitInfo unitInfo, HttpServletRequest request, HttpServletResponse response) {
        if (!this.sysUnitManager.isUniqueName(unitInfo)) {
            JsonResultUtils.writeErrorMessageJson((int)702, (String)("\u673a\u6784\u540d" + unitInfo.getUnitName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"), (HttpServletResponse)response);
            return;
        }
        this.sysUnitManager.saveNewUnitInfo(unitInfo);
        JsonResultUtils.writeSingleDataJson((Object)unitInfo, (HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)unitInfo.getUnitCode(), (String)"create", (String)"\u65b0\u589e\u673a\u6784", (Object)unitInfo);
    }

    @RequestMapping(value={"/{unitCode}"}, method={RequestMethod.PUT})
    public void edit(@PathVariable String unitCode, @Valid UnitInfo unitInfo, HttpServletRequest request, HttpServletResponse response) {
        UnitInfo dbUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (null == dbUnitInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u673a\u6784\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        if (!this.sysUnitManager.isUniqueName(unitInfo)) {
            JsonResultUtils.writeErrorMessageJson((int)702, (String)("\u673a\u6784\u540d" + unitInfo.getUnitName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"), (HttpServletResponse)response);
            return;
        }
        UnitInfo oldValue = new UnitInfo();
        oldValue.copy(dbUnitInfo);
        this.sysUnitManager.updateUnitInfo(unitInfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)unitCode, (String)"update", (String)"\u66f4\u65b0\u673a\u6784\u4fe1\u606f", (Object)unitInfo, (Object)oldValue);
    }

    @RequestMapping(value={"/{unitCode}/status/{statusValue}"}, method={RequestMethod.PUT})
    public void changeStatus(@PathVariable String unitCode, @PathVariable String statusValue, HttpServletRequest request, HttpServletResponse response) {
        UnitInfo dbUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (null == dbUnitInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u673a\u6784\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        if (!"T".equals(statusValue) && !"F".equals(statusValue)) {
            JsonResultUtils.writeErrorMessageJson((String)"\u673a\u6784\u72b6\u6001\u4e0d\u6b63\u786e", (HttpServletResponse)response);
            return;
        }
        this.sysUnitManager.changeStatus(unitCode, statusValue);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        String optContent = "\u66f4\u65b0\u673a\u6784\u72b6\u6001,\u673a\u6784\u540d\u79f0:" + CodeRepositoryUtil.getCode((String)"unitCode", (String)unitCode) + ",\u673a\u6784\u662f\u5426\u542f\u7528:" + ("T".equals(statusValue) ? "\u662f" : "\u5426");
        OperationLogCenter.log((HttpServletRequest)request, (String)this.optId, (String)unitCode, (String)"update", (String)optContent);
    }

    @RequestMapping(value={"/{unitCode}/children"}, method={RequestMethod.GET})
    public void listChildren(@PathVariable String unitCode, String[] field, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = UnitInfoController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("parentUnit", unitCode);
        List<UnitInfo> listObjects = this.sysUnitManager.listObjects(searchColumn);
        JsonResultUtils.writeSingleDataJson(listObjects, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getIncludePropPreFilter(UnitInfo.class, (String[])field));
    }

    @RequestMapping(value={"/{unitCode}/users"}, method={RequestMethod.GET})
    public void listUnitUsers(@PathVariable String unitCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = UnitInfoController.convertSearchColumn((HttpServletRequest)request);
        searchColumn.put("unitCode", unitCode);
        List<UserInfo> listObjects = this.sysUserMag.listObjects(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}/validusers"}, method={RequestMethod.GET})
    public void listUnitAllUsers(@PathVariable String unitCode, HttpServletResponse response) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("unitCode", unitCode);
        filterMap.put("isValid", "T");
        List<UserInfo> listObjects = this.sysUserMag.listObjects(filterMap);
        JsonResultUtils.writeSingleDataJson(listObjects, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unitusers/{userunitid}"}, method={RequestMethod.GET})
    public void getUnitUser(@PathVariable String userunitid, HttpServletResponse response) {
        UserUnit userUnit = this.sysUserUnitManager.getObjectById(userunitid);
        if (null == userUnit) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        JsonResultUtils.writeSingleDataJson((Object)userUnit, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unit/saveopts/{unitcode}"}, method={RequestMethod.POST})
    public void setUnitPowers(@PathVariable String unitcode, String optCodes, HttpServletRequest request, HttpServletResponse response) {
        Object[] optCodesArray = optCodes.split(",");
        RoleInfo roleInfo = this.sysRoleManager.getObjectById("G$" + unitcode);
        if (roleInfo == null) {
            roleInfo = new RoleInfo();
            roleInfo.setIsValid("T");
            roleInfo.setRoleCode("G$" + unitcode);
            roleInfo.setRoleName("\u8d4b\u7ed9\u90e8\u95e8" + unitcode + "\u7684\u6743\u9650");
            roleInfo.setRoleDesc(roleInfo.getRoleName());
            roleInfo.setRoleType("D");
            roleInfo.setCreateDate(new Date());
            this.sysRoleManager.saveNewRoleInfo(roleInfo);
            this.sysRoleManager.loadRoleSecurityMetadata();
        }
        ArrayList<RolePower> rolePowers = new ArrayList<RolePower>();
        if (ArrayUtils.isNotEmpty((Object[])optCodesArray)) {
            for (Object optCode : optCodesArray) {
                if (!StringUtils.isNotBlank((CharSequence)optCode)) continue;
                rolePowers.add(new RolePower(new RolePowerId(roleInfo.getRoleCode(), (String)optCode)));
            }
        }
        roleInfo.addAllRolePowers(rolePowers);
        this.sysRoleManager.updateRolePower(roleInfo);
        this.sysRoleManager.loadRoleSecurityMetadata();
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)roleInfo.getRoleCode(), (String)"update", (String)"\u66f4\u65b0\u673a\u6784\u6743\u9650", (Object)roleInfo);
    }
}

