/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.framework.system.service.UserSettingManager;
import com.centit.support.json.JsonPropertyUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userinfo"})
public class UserInfoController
extends BaseController {
    @Resource
    @NotNull
    private SysUserManager sysUserManager;
    @Resource
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    @NotNull
    private UserSettingManager userSettingManager;
    private String optId = "USERMAG";

    @RequestMapping(method={RequestMethod.GET})
    public void list(String[] field, PageDesc pageDesc, String _search, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = UserInfoController.convertSearchColumn((HttpServletRequest)request);
        List<UserInfo> listObjects = null;
        if (Boolean.parseBoolean(_search)) {
            listObjects = this.sysUserManager.listObjects(searchColumn);
            pageDesc = null;
        } else {
            listObjects = this.sysUserManager.listObjects(searchColumn, pageDesc);
        }
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(UserInfo.class, field);
        }
        if (null == pageDesc) {
            JsonResultUtils.writeSingleDataJson(listObjects, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
            return;
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void create(@Valid UserInfo userInfo, UserUnit userUnit, HttpServletRequest request, HttpServletResponse response) {
        UserInfo dbuserinfo = this.sysUserManager.loadUserByLoginname(userInfo.getLoginName());
        if (null != dbuserinfo) {
            JsonResultUtils.writeErrorMessageJson((int)702, (String)("\u767b\u5f55\u540d" + userInfo.getLoginName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"), (HttpServletResponse)response);
            return;
        }
        userInfo.setUserCode(this.sysUserManager.getNextUserCode());
        if (null != userInfo.getUserUnits()) {
            for (UserUnit uu : userInfo.getUserUnits()) {
                uu.setUserCode(userInfo.getUserCode());
            }
        }
        if (null != userInfo.listUserRoles()) {
            for (UserRole ur : userInfo.listUserRoles()) {
                ur.setUserCode(userInfo.getUserCode());
            }
        }
        this.sysUserManager.saveNewUserInfo(userInfo, userUnit);
        JsonResultUtils.writeSingleDataJson((Object)userInfo, (HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)userInfo.getUserCode(), (String)"create", (String)"\u65b0\u589e\u7528\u6237", (Object)userInfo);
    }

    @RequestMapping(value={"/{userCode}"}, method={RequestMethod.PUT})
    public void edit(@PathVariable String userCode, @Valid UserInfo userInfo, HttpServletRequest request, HttpServletResponse response) {
        UserInfo dbUserInfo = this.sysUserManager.getObjectById(userCode);
        if (null == dbUserInfo) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        UserInfo oldValue = new UserInfo();
        oldValue.copy(dbUserInfo);
        if (oldValue.getUserUnits().size() == 0) {
            oldValue.setUserUnits(null);
        }
        if (oldValue.listUserRoles().size() == 0) {
            oldValue.setUserRoles(null);
        }
        this.sysUserManager.updateUserInfo(userInfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)userCode, (String)"update", (String)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f", (Object)userInfo, (Object)oldValue);
    }

    @RequestMapping(value={"/current"}, method={RequestMethod.GET})
    public void getCurrentUserInfo(HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails userDetails = super.getLoginUser(request);
        UserInfo userinfo = this.sysUserManager.getObjectById(userDetails.getUserCode());
        JsonResultUtils.writeSingleDataJson((Object)userinfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userCode}"}, method={RequestMethod.GET})
    public void getUserInfo(@PathVariable String userCode, HttpServletResponse response) {
        UserInfo userDetails = this.sysUserManager.getObjectById(userCode);
        HashMap<Class, String[]> excludes = new HashMap<Class, String[]>();
        excludes.put(UserUnit.class, new String[]{"userInfo"});
        excludes.put(UserRole.class, new String[]{"userInfo"});
        JsonResultUtils.writeSingleDataJson((Object)userDetails, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(excludes));
    }

    @RequestMapping(value={"/allroles/{userCode}"}, method={RequestMethod.GET})
    public void listRolesByUser(@PathVariable String userCode, HttpServletResponse response) {
        List<RoleInfo> roles = this.sysUserManager.listUserValidRoles(userCode);
        JsonResultUtils.writeSingleDataJson(roles, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/exists"}, method={RequestMethod.GET})
    public void isAnyExist(HttpServletRequest request, HttpServletResponse response) {
        String userCode = request.getParameter("userCode");
        String loginName = request.getParameter("loginName");
        String regPhone = request.getParameter("regPhone");
        String regEmail = request.getParameter("regEmail");
        JsonResultUtils.writeOriginalObject((Object)this.sysUserManager.isAnyOneExist(userCode, loginName, regPhone, regEmail), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/exists/{loginName}"}, method={RequestMethod.GET})
    public void isExists(@PathVariable String loginName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserInfo userInfo = this.sysUserManager.loadUserByLoginname(loginName);
        JsonResultUtils.writeOriginalObject((Object)(null != userInfo ? 1 : 0), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/change/{userCode}"}, method={RequestMethod.PUT})
    public void changePwd(@PathVariable String userCode, String password, String newPassword, HttpServletRequest request, HttpServletResponse response) {
        this.sysUserManager.setNewPassword(userCode, password, newPassword);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.log((HttpServletRequest)request, (String)this.optId, (String)userCode, (String)"changePassword", (String)("\u66f4\u65b0\u7528\u6237\u5bc6\u7801,\u7528\u6237\u4ee3\u7801:" + userCode));
    }

    @RequestMapping(value={"/changePwd/{userCode}"}, method={RequestMethod.PUT})
    public void forceChangePwd(@PathVariable String userCode, HttpServletRequest request, HttpServletResponse response) {
        String newPassword = request.getParameter("newPassword");
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            this.sysUserManager.resetPwd(userCode);
        } else {
            this.sysUserManager.forceSetPassword(userCode, newPassword);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.log((HttpServletRequest)request, (String)this.optId, (String)userCode, (String)"forceChangePwd", (String)("\u66f4\u65b0\u7528\u6237\u5bc6\u7801,\u7528\u6237\u4ee3\u7801:" + userCode));
    }

    @RequestMapping(value={"/canchange/{userCode}/{oldPassword}"}, method={RequestMethod.GET})
    public void canChangePwd(@PathVariable String userCode, @PathVariable String oldPassword, HttpServletRequest request, HttpServletResponse response) {
        boolean bo = true;
        bo = this.sysUserManager.checkUserPassword(userCode, oldPassword);
        JsonResultUtils.writeSingleDataJson((Object)bo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.PUT})
    public void resetBatchPwd(String[] userCodes, HttpServletRequest request, HttpServletResponse response) {
        if (ArrayUtils.isEmpty((Object[])userCodes)) {
            JsonResultUtils.writeErrorMessageJson((String)"\u7528\u6237\u4ee3\u7801\u96c6\u5408\u4e3a\u7a7a", (HttpServletResponse)response);
            return;
        }
        this.sysUserManager.resetPwd(userCodes);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, null, (String)"resetPassword", (String)"\u6279\u91cf\u91cd\u7f6e\u5bc6\u7801", (Object)userCodes);
    }

    @RequestMapping(value={"/reset/{userCode}"}, method={RequestMethod.PUT})
    public void resetPwd(@PathVariable String userCode, HttpServletRequest request, HttpServletResponse response) {
        this.sysUserManager.resetPwd(userCode);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.log((HttpServletRequest)request, (String)this.optId, (String)userCode, (String)"resetPassword", (String)("\u91cd\u7f6e\u7528\u6237\u5bc6\u7801,\u7528\u6237\u4ee3\u7801:" + userCode));
    }

    @RequestMapping(value={"/{userCodes}"}, method={RequestMethod.DELETE})
    public void deleteUser(@PathVariable String[] userCodes, HttpServletRequest request, HttpServletResponse response) {
        for (String userCode : userCodes) {
            UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
            if (null == userInfo) {
                JsonResultUtils.writeErrorMessageJson((String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728", (HttpServletResponse)response);
                return;
            }
            this.sysUserManager.deleteUserInfo(userCode);
            OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)userCode, (String)"delete", (String)("\u5220\u9664\u7528\u6237" + userInfo.getUserName()), (Object)userInfo);
        }
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }
}

