/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.system.po.UserQueryFilter;
import com.centit.framework.system.service.UserQueryFilterManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userqueryfilter"})
public class UserQueryFilterController
extends BaseController {
    @Resource
    private UserQueryFilterManager userQueryFilterMag;

    @RequestMapping(method={RequestMethod.GET})
    public void list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = UserQueryFilterController.convertSearchColumn((HttpServletRequest)request);
        List<UserQueryFilter> listObjects = this.userQueryFilterMag.listObjects(searchColumn, pageDesc);
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(UserQueryFilter.class, field);
        }
        if (null == pageDesc) {
            JsonResultUtils.writeSingleDataJson(listObjects, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
            return;
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/list/{modelCode}"}, method={RequestMethod.GET})
    public void listUserQueryFilter(@PathVariable String modelCode, HttpServletRequest request, HttpServletResponse response) {
        List<UserQueryFilter> userFilters = this.userQueryFilterMag.listUserQueryFilterByModle(super.getLoginUserCode(request), modelCode);
        JsonResultUtils.writeSingleDataJson(userFilters, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{filterNo}"}, method={RequestMethod.GET})
    public void getUserQueryFilter(@PathVariable Long filterNo, HttpServletResponse response) {
        UserQueryFilter userQueryFilter = this.userQueryFilterMag.getUserQueryFilter(filterNo);
        JsonResultUtils.writeSingleDataJson((Object)userQueryFilter, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void createUserQueryFilter(@Valid UserQueryFilter userQueryFilter, HttpServletRequest request, HttpServletResponse response) {
        userQueryFilter.setFilterNo(this.userQueryFilterMag.getNextFilterKey());
        userQueryFilter.setCreateDate(DatetimeOpt.currentUtilDate());
        userQueryFilter.setIsDefault("F");
        if (StringBaseOpt.isNvl((String)userQueryFilter.getUserCode())) {
            userQueryFilter.setUserCode(super.getLoginUserCode(request));
        }
        this.userQueryFilterMag.saveNewObject(userQueryFilter);
        JsonResultUtils.writeSingleDataJson((Object)userQueryFilter.getFilterNo(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/default/{modelCode}"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void createUserDefaultFilter(@PathVariable String modelCode, @Valid UserQueryFilter userQueryFilter, HttpServletRequest request, HttpServletResponse response) {
        userQueryFilter.setCreateDate(DatetimeOpt.currentUtilDate());
        userQueryFilter.setIsDefault("T");
        userQueryFilter.setModleCode(modelCode);
        if (StringBaseOpt.isNvl((String)userQueryFilter.getUserCode())) {
            userQueryFilter.setUserCode(super.getLoginUserCode(request));
        }
        Long pk = this.userQueryFilterMag.saveUserDefaultFilter(userQueryFilter);
        JsonResultUtils.writeSingleDataJson((Object)pk, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/default/{modelCode}"}, method={RequestMethod.GET})
    public void getUserDefaultFilter(@PathVariable String modelCode, HttpServletRequest request, HttpServletResponse response) {
        UserQueryFilter userQueryFilter = this.userQueryFilterMag.getUserDefaultFilter(super.getLoginUserCode(request), modelCode);
        JsonResultUtils.writeSingleDataJson((Object)userQueryFilter, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{filterNo}"}, method={RequestMethod.DELETE})
    public void deleteUserQueryFilter(@PathVariable Long filterNo, HttpServletResponse response) {
        boolean b = this.userQueryFilterMag.deleteUserQueryFilter(filterNo);
        if (b) {
            JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u4e0d\u80fd\u5220\u9664\u9ed8\u8ba4\u8fc7\u6ee4\u6761\u4ef6\uff01", (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/{filterNo}"}, method={RequestMethod.PUT})
    public void updateUserQueryFilter(@PathVariable Long filterNo, @Valid UserQueryFilter userQueryFilter, HttpServletResponse response) {
        UserQueryFilter dbUserQueryFilter = this.userQueryFilterMag.getUserQueryFilter(filterNo);
        if (null == userQueryFilter) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbUserQueryFilter.copy(userQueryFilter);
        dbUserQueryFilter.setCreateDate(DatetimeOpt.currentUtilDate());
        this.userQueryFilterMag.mergeObject(dbUserQueryFilter);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

