/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.framework.system.service.SysUserRoleManager;
import com.centit.support.json.JsonPropertyUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userrole"})
public class UserRoleController
extends BaseController {
    @Resource
    @NotNull
    private SysUserRoleManager sysUserRoleManager;
    private String optId = "USERROLE";

    @RequestMapping(value={"/roleusers/{roleCode}"}, method={RequestMethod.GET})
    public void listUsersByRole(@PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = UserRoleController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("roleCode", roleCode);
        if (!Objects.isNull(filterMap.get("userName"))) {
            filterMap.put("userName", "%" + filterMap.get("userName") + "%");
        }
        this.listObject(filterMap, pageDesc, response);
    }

    @RequestMapping(value={"/userroles/{userCode}"}, method={RequestMethod.GET})
    public void listRolesByUser(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = UserRoleController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("userCode", userCode);
        String type = request.getParameter("type");
        if ("S".equals(type)) {
            filterMap.put("NP_userRoleType", true);
        } else if ("D".equals(type)) {
            filterMap.put("NP_unitRoleType", true);
        }
        this.listObject(filterMap, pageDesc, response);
    }

    protected void listObject(Map<String, Object> filterMap, PageDesc pageDesc, HttpServletResponse response) {
        List<UserRole> listObjects = this.sysUserRoleManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        HashMap<Class<RoleInfo>, String[]> excludes = new HashMap<Class<RoleInfo>, String[]>();
        excludes.put(RoleInfo.class, new String[]{"rolePowers"});
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(excludes));
    }

    @RequestMapping(value={"/{roleCode}/{userCode}"}, method={RequestMethod.GET})
    public void getUserRole(@PathVariable String roleCode, @PathVariable String userCode, HttpServletResponse response) {
        UserRole userRole = this.sysUserRoleManager.getObjectById(new UserRoleId(userCode, roleCode));
        if (null == userRole) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u89d2\u8272\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        HashMap<Class<RoleInfo>, String[]> excludes = new HashMap<Class<RoleInfo>, String[]>();
        excludes.put(RoleInfo.class, new String[]{"rolePowers"});
        JsonResultUtils.writeSingleDataJson((Object)userRole, (HttpServletResponse)response, (PropertyPreFilter)JsonPropertyUtils.getExcludePropPreFilter(excludes));
    }

    @RequestMapping(method={RequestMethod.POST})
    public void create(@Valid UserRole userRole, @Valid String[] userCode, HttpServletRequest request, HttpServletResponse response) {
        userRole.setCreateDate(new Date());
        if (userCode != null && userCode.length > 0) {
            UserRole ur = null;
            for (String u : userCode) {
                ur = new UserRole();
                ur.copy(userRole);
                ur.setUserCode(u);
                this.sysUserRoleManager.mergeObject(ur);
            }
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)(userRole.getUserCode() + "-" + userRole.getRoleCode()), (String)"create", (String)"\u65b0\u589e\u7528\u6237\u89d2\u8272\u5173\u8054", (Object)userRole);
    }

    @RequestMapping(value={"/{roleCode}/{userCode}"}, method={RequestMethod.PUT})
    public void edit(@PathVariable String roleCode, @PathVariable String userCode, @Valid UserRole userRole, HttpServletRequest request, HttpServletResponse response) {
        UserRole dbUserRole = this.sysUserRoleManager.getObjectById(new UserRoleId(userCode, roleCode));
        if (null == userRole) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u89d2\u8272\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        this.sysUserRoleManager.mergeObject(dbUserRole, userRole);
        JsonResultUtils.writeSingleDataJson((Object)userRole, (HttpServletResponse)response);
        StringBuilder optContent = new StringBuilder();
        optContent.append("\u66f4\u6539\u7528\u6237\u89d2\u8272\u4fe1\u606f:" + JSON.toJSONString((Object)userRole.getId()));
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)dbUserRole.getUserCode(), (String)"update", (String)optContent.toString(), (Object)userRole, (Object)dbUserRole);
    }

    @RequestMapping(value={"/{roleCode}/{userCodes}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String roleCode, @PathVariable String userCodes, HttpServletRequest request, HttpServletResponse response) {
        String[] userCodeArray;
        for (String userCode : userCodeArray = userCodes.split(",")) {
            UserRoleId userRoleId = new UserRoleId(userCode, roleCode);
            UserRole userRole = this.sysUserRoleManager.getObjectById(userRoleId);
            this.sysUserRoleManager.deleteObjectById(userRoleId);
            OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)(userCode + "-" + roleCode), (String)"delete", (String)"\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", (Object)userRole);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/ban/{roleCode}/{userCode}"}, method={RequestMethod.PUT})
    public void ban(@PathVariable String roleCode, @PathVariable String userCode, HttpServletRequest request, HttpServletResponse response) {
        UserRoleId a = new UserRoleId(userCode, roleCode);
        UserRole userRole = this.sysUserRoleManager.getObjectById(a);
        this.sysUserRoleManager.deleteObjectById(a);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)(userCode + "-" + roleCode), (String)"delete", (String)"\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u8054\u4fe1\u606f", (Object)userRole);
    }
}

