/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.po.UserSettingId;
import com.centit.framework.system.service.UserSettingManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.HtmlUtils;

@Controller
@RequestMapping(value={"/usersetting"})
public class UserSettingController
extends BaseController {
    @Resource
    private UserSettingManager userSettingManager;
    private String optId = "userSetting";

    @RequestMapping
    public void list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = UserSettingController.convertSearchColumn((HttpServletRequest)request);
        UserInfo userInfo = (UserInfo)this.getLoginUser(request);
        searchColumn.put("userCode", userInfo.getUserCode());
        List<UserSetting> listObjects = this.userSettingManager.listObjects(searchColumn, pageDesc);
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(UserSetting.class, field);
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
    }

    @RequestMapping(value={"/listall"}, method={RequestMethod.GET})
    public void listAll(String[] field, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> searchColumn = new HashMap<String, Object>();
        UserInfo userInfo = (UserInfo)this.getLoginUser(request);
        searchColumn.put("userCode", userInfo.getUserCode());
        List<UserSetting> listObjects = this.userSettingManager.listObjects(searchColumn);
        SimplePropertyPreFilter simplePropertyPreFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            simplePropertyPreFilter = new SimplePropertyPreFilter(UserSetting.class, field);
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", listObjects);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
    }

    @RequestMapping(value={"/{paramCode}"}, method={RequestMethod.GET})
    public void getUserSetting(@PathVariable String paramCode, HttpServletRequest request, HttpServletResponse response) {
        UserSettingId id = new UserSettingId(this.getLoginUser(request).getUserCode(), paramCode);
        UserSetting userSetting = this.userSettingManager.getObjectById(id);
        if (null != userSetting) {
            userSetting.setParamValue(HtmlUtils.htmlUnescape((String)userSetting.getParamValue()));
        }
        JsonResultUtils.writeSingleDataJson((Object)userSetting, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{paramCode}"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void editUserSetting(@PathVariable String paramCode, @Valid UserSetting userSetting, HttpServletRequest request, BindingResult bindingResult, HttpServletResponse response) {
        UserSettingId id = new UserSettingId(this.getLoginUser(request).getUserCode(), paramCode);
        UserSetting dbUserSetting = this.userSettingManager.getObjectById(id);
        if (dbUserSetting != null) {
            BeanUtils.copyProperties((Object)userSetting, (Object)dbUserSetting, (String[])new String[]{"cid"});
            this.userSettingManager.saveUserSetting(dbUserSetting);
        } else {
            userSetting.setCid(id);
            userSetting.setCreateDate(new Date());
            this.userSettingManager.saveUserSetting(userSetting);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)userSetting.getUserCode(), (String)"update", (String)"\u66f4\u65b0\u5f53\u524d\u7528\u6237\u8bbe\u7f6e\u53c2\u6570", (Object)userSetting);
    }

    @RequestMapping(value={"/{paramCode}"}, method={RequestMethod.DELETE})
    public void deleteUserSetting(@PathVariable String paramCode, HttpServletRequest request, HttpServletResponse response) {
        UserSetting dbUserSetting = this.userSettingManager.getObjectById(new UserSettingId(this.getLoginUser(request).getUserCode(), paramCode));
        this.userSettingManager.deleteObject(dbUserSetting);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)dbUserSetting.getUserCode(), (String)"delete", (String)"\u5df2\u5220\u9664", (Object)dbUserSetting);
    }
}

