/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userunit"})
public class UserUnitController
extends BaseController {
    @Resource
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    @NotNull
    private SysUserManager sysUserManager;
    private String optId = "USERUNIT";

    @RequestMapping(method={RequestMethod.GET})
    public void list(String state, HttpServletResponse response) {
        HashMap<String, String> object;
        ArrayList listObjects = new ArrayList();
        if (StringUtils.isBlank((CharSequence)state)) {
            state = "A";
        }
        List users = CodeRepositoryUtil.getAllUsers((String)state);
        List units = CodeRepositoryUtil.getAllUnits((String)state);
        for (IUnitInfo unit : units) {
            object = new HashMap<String, String>();
            object.put("id", unit.getUnitCode());
            object.put("name", unit.getUnitName());
            object.put("pId", unit.getParentUnit());
            listObjects.add(object);
        }
        for (IUserInfo user : users) {
            object = new HashMap();
            object.put("id", user.getUserCode());
            object.put("name", user.getUserName());
            object.put("pId", user.getPrimaryUnit());
            listObjects.add(object);
        }
        JsonResultUtils.writeSingleDataJson(listObjects, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/unitusers/{unitCode}"}, method={RequestMethod.GET})
    public void listUsersByUnit(@PathVariable String unitCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = UserUnitController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("unitCode", unitCode);
        List<UserUnit> listObjects = this.sysUserUnitManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray(listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/userunits/{userCode}"}, method={RequestMethod.GET})
    public void listUnitsByUser(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        UserInfo user = this.sysUserManager.getObjectById(this.getLoginUser(request).getUserCode());
        Map filterMap = UserUnitController.convertSearchColumn((HttpServletRequest)request);
        filterMap.put("userCode", userCode);
        filterMap.put("unitCode", user.getPrimaryUnit());
        List<UserUnit> listObjects = this.sysUserUnitManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray(listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    protected void listObject(Map<String, Object> filterMap, PageDesc pageDesc, HttpServletResponse response) {
        List<UserUnit> listObjects = this.sysUserUnitManager.listObjects(filterMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)DictionaryMapUtils.objectsToJSONArray(listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userunitid}"}, method={RequestMethod.GET})
    public void getUserUnitById(@PathVariable String userunitid, HttpServletResponse response) {
        UserUnit userUnit = this.sysUserUnitManager.getObjectById(userunitid);
        if (null == userUnit) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        JsonResultUtils.writeSingleDataJson((Object)DictionaryMapUtils.objectToJSON((Object)userUnit), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{unitCode}/{userCode}"}, method={RequestMethod.GET})
    public void getUserUnit(@PathVariable String unitCode, @PathVariable String userCode, HttpServletResponse response) {
        List<UserUnit> userUnits = this.sysUserUnitManager.listObjectByUserUnit(userCode, unitCode);
        if (null == userUnits || userUnits.size() == 0) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
            return;
        }
        JsonResultUtils.writeSingleDataJson((Object)DictionaryMapUtils.objectsToJSONArray(userUnits), (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void create(@Valid UserUnit userUnit, HttpServletRequest request, HttpServletResponse response) {
        this.sysUserUnitManager.saveNewUserUnit(userUnit);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)"create", (String)"create", (String)"\u65b0\u589e\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", (Object)userUnit);
    }

    @RequestMapping(value={"/{userunitid}"}, method={RequestMethod.PUT})
    public void edit(@PathVariable String userunitid, @Valid UserUnit userUnit, HttpServletRequest request, HttpServletResponse response) {
        UserUnit dbUserUnit = this.sysUserUnitManager.getObjectById(userunitid);
        if (null == dbUserUnit) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u673a\u6784\u4e2d\u65e0\u6b64\u7528\u6237", (HttpServletResponse)response);
        }
        UserUnit oldValue = new UserUnit();
        oldValue.copy(dbUserUnit);
        dbUserUnit.copy(userUnit);
        this.sysUserUnitManager.updateUserUnit(dbUserUnit);
        JsonResultUtils.writeSingleDataJson((Object)userUnit, (HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)oldValue.getUserUnitId(), (String)"update", (String)"\u66f4\u65b0\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", (Object)dbUserUnit, (Object)oldValue);
    }

    @RequestMapping(value={"/{userunitid}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String userunitid, HttpServletRequest request, HttpServletResponse response) {
        UserUnit dbUserUnit = this.sysUserUnitManager.getObjectById(userunitid);
        this.sysUserUnitManager.deleteObject(dbUserUnit);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)dbUserUnit.getUserUnitId(), (String)"delete", (String)"\u5220\u9664\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", (Object)dbUserUnit);
    }
}

