/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UserInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class CentitUserDetailsImpl
extends UserInfo
implements CentitUserDetails {
    private static final long serialVersionUID = 1L;
    @JSONField(serialize=false)
    private List<GrantedAuthority> arrayAuths = null;
    private Map<String, String> userSettings;
    private Map<String, String> userOptList;

    public Map<String, String> getUserSettings() {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>();
        }
        return this.userSettings;
    }

    public void putUserSettingsParams(String paramCode, String paramValue) {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>();
        }
        this.userSettings.put(paramCode, paramValue);
    }

    public void setUserSettings(Map<String, String> userSettings) {
        this.userSettings = userSettings;
    }

    public Map<String, String> getUserOptList() {
        if (this.userOptList == null) {
            this.userOptList = new HashMap<String, String>();
        }
        return this.userOptList;
    }

    public void setUserOptList(Map<String, String> userOptList) {
        this.userOptList = userOptList;
    }

    public boolean checkOptPower(String optId, String optMethod) {
        String s = this.userOptList.get(optId + "-" + optMethod);
        if (s == null) {
            return false;
        }
        return "T".equals(s);
    }

    public CentitUserDetailsImpl(UserInfo user) {
        super(user.getUserCode(), user.getUserPin(), user.getUserType(), user.getIsValid(), user.getLoginName(), user.getUserName(), user.getUserDesc(), user.getLoginTimes(), user.getActiveTime(), user.getLoginIp(), user.getAddrbookId());
    }

    public CentitUserDetailsImpl() {
    }

    public CentitUserDetailsImpl(String userCode, String userstate, String loginname, String username) {
        super(userCode, userstate, loginname, username);
    }

    public CentitUserDetailsImpl(String userCode, String userpin, String usertype, String userstate, String loginname, String username, String userdesc, Long logintimes, Date activeime, String loginip, Long addrbookid) {
        super(userCode, userpin, usertype, userstate, loginname, username, userdesc, logintimes, activeime, loginip, addrbookid);
    }

    public void setAuthoritiesByRoles(List<RoleInfo> roles) {
        if (roles.size() < 1) {
            return;
        }
        this.arrayAuths = new ArrayList<GrantedAuthority>();
        for (RoleInfo role : roles) {
            this.arrayAuths.add((GrantedAuthority)new SimpleGrantedAuthority("R_" + StringUtils.trim((String)role.getRoleCode())));
        }
        Collections.sort(this.arrayAuths, new Comparator<GrantedAuthority>(){

            @Override
            public int compare(GrantedAuthority o1, GrantedAuthority o2) {
                return o1.getAuthority().compareTo(o2.getAuthority());
            }
        });
    }

    @JSONField(serialize=false)
    public Collection<GrantedAuthority> getAuthorities() {
        return this.arrayAuths;
    }

    public List<String> getUserRoleCodes() {
        ArrayList<String> userRoles = new ArrayList<String>();
        if (this.arrayAuths == null) {
            return userRoles;
        }
        for (GrantedAuthority auth : this.arrayAuths) {
            userRoles.add(auth.getAuthority().substring(2));
        }
        return userRoles;
    }

    public String getUsername() {
        return this.getLoginName();
    }

    public boolean isAccountNonExpired() {
        return "T".equals(this.getIsValid());
    }

    public boolean isAccountNonLocked() {
        return "T".equals(this.getIsValid());
    }

    public boolean isCredentialsNonExpired() {
        return "T".equals(this.getIsValid());
    }

    @JSONField(serialize=false)
    public String getPassword() {
        return this.getUserPin();
    }

    public String getUserSettingValue(String paramCode) {
        if (this.userSettings == null) {
            return null;
        }
        return this.userSettings.get(paramCode);
    }

    public void setUserSettingValue(String paramCode, String paramValue) {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>();
        }
        this.userSettings.put(paramCode, paramValue);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CentitUserDetail:");
        sb.append(super.toString());
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof CentitUserDetails) {
            return this.getUserCode().equals(((CentitUserDetails)other).getUserCode());
        }
        if (other instanceof UserInfo) {
            return this.getUserCode().equals(((UserInfo)other).getUserCode());
        }
        return false;
    }

    public int hashCode() {
        return this.getUserCode().hashCode();
    }

    @JSONField(serialize=false)
    public Object getCredentials() {
        return this.getUserPin();
    }

    @JSONField(serialize=false)
    public Object getDetails() {
        return this;
    }

    @JSONField(serialize=false)
    public Object getPrincipal() {
        return this;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public String getName() {
        return this.getLoginName();
    }
}

