/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.security;

import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.security.model.CentitUserDetailsService;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserSettingDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.FVUserOptList;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.security.CentitUserDetailsImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="centitUserDetailsService")
public class DaoUserDetailsService
implements CentitUserDetailsService,
UserDetailsService,
AuthenticationUserDetailsService<Authentication> {
    @Resource
    private UserInfoDao sysuserdao;
    @Resource
    private UnitInfoDao sysunitdao;
    @Resource
    private UserUnitDao userUnitdao;
    @Resource
    private UserRoleDao userRoleDao;
    @Resource
    private UserSettingDao userSettingDao;

    @Transactional
    public Collection<GrantedAuthority> loadUserAuthorities(String loginname) throws UsernameNotFoundException {
        UserInfo userinfo = this.sysuserdao.getUserByLoginName(loginname);
        if (userinfo == null) {
            throw new UsernameNotFoundException("user '" + loginname + "' not found...");
        }
        CentitUserDetailsImpl sysuser = new CentitUserDetailsImpl();
        sysuser.copy(userinfo);
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        roles.add(new RoleInfo("G-public", "general public", "G", "G", "T", "general public"));
        List ls = this.userRoleDao.getSysRolesByUserId(sysuser.getUserCode());
        if (ls != null) {
            for (FVUserRoles l : ls) {
                RoleInfo roleInfo = new RoleInfo();
                BeanUtils.copyProperties((Object)l, (Object)roleInfo);
                roles.add(roleInfo);
            }
        }
        sysuser.setAuthoritiesByRoles(roles);
        return sysuser.getAuthorities();
    }

    @Transactional
    private CentitUserDetails fillUserDetailsField(UserInfo userinfo) {
        CentitUserDetailsImpl sysuser = new CentitUserDetailsImpl();
        sysuser.copy(userinfo);
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        roles.add(new RoleInfo("G-public", "general public", "G", "G", "T", "general public"));
        List ls = this.userRoleDao.getSysRolesByUserId(sysuser.getUserCode());
        if (ls != null) {
            for (FVUserRoles l : ls) {
                RoleInfo roleInfo = new RoleInfo();
                BeanUtils.copyProperties((Object)l, (Object)roleInfo);
                roles.add(roleInfo);
            }
        }
        List usun = this.userUnitdao.listUserUnitsByUserCode(sysuser.getUserCode());
        sysuser.setUserUnits(usun);
        if (roles == null || roles.size() < 1) {
            sysuser.setIsValid("F");
            return sysuser;
        }
        sysuser.setAuthoritiesByRoles(roles);
        List uoptlist = this.sysuserdao.getAllOptMethodByUser(sysuser.getUserCode());
        HashMap<String, String> userOptList = new HashMap<String, String>();
        if (uoptlist != null) {
            for (FVUserOptList opt : uoptlist) {
                if (StringUtils.isBlank((CharSequence)opt.getOptMethod())) continue;
                userOptList.put(opt.getOptId() + "-" + opt.getOptMethod(), "T");
            }
        }
        sysuser.setUserOptList(userOptList);
        List uss = this.userSettingDao.getUserSettingsByCode(sysuser.getUserCode());
        if (uss != null) {
            for (UserSetting us : uss) {
                sysuser.putUserSettingsParams(us.getParamCode(), us.getParamValue());
            }
        }
        return sysuser;
    }

    @Transactional
    public CentitUserDetails loadUserByUsername(String loginname) throws UsernameNotFoundException {
        CentitUserDetails ud = this.loadDetailsByLoginName(loginname);
        if (ud == null) {
            throw new UsernameNotFoundException("user: " + loginname + " not found!");
        }
        return ud;
    }

    @Transactional
    public CentitUserDetails loadDetailsByLoginName(String loginname) {
        UserInfo userinfo = this.sysuserdao.getUserByLoginName(loginname);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetails loadUserDetails(Authentication token) throws UsernameNotFoundException {
        return this.loadUserByUsername(token.getName());
    }

    @Transactional
    public void saveUserSetting(String userCode, String paramCode, String paramValue, String paramClass, String paramName) {
        this.userSettingDao.saveUserSetting(new UserSetting(userCode, paramCode, paramValue, paramClass, paramName));
    }

    @Transactional
    public CentitUserDetails loadDetailsByUserCode(String userCode) {
        UserInfo userinfo = this.sysuserdao.getUserByCode(userCode);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetails loadDetailsByRegEmail(String regEmail) {
        UserInfo userinfo = this.sysuserdao.getUserByRegEmail(regEmail);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetails loadDetailsByRegCellPhone(String regCellPhone) {
        UserInfo userinfo = this.sysuserdao.getUserByRegCellPhone(regCellPhone);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }
}

