/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.common.SysParametersUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IDataDictionary;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitSecurityMetadata;
import com.centit.framework.security.model.OptTreeNode;
import com.centit.framework.system.dao.DataCatalogDao;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserSettingDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.DataCatalog;
import com.centit.framework.system.po.DataDictionary;
import com.centit.framework.system.po.FVUserOptList;
import com.centit.framework.system.po.FVUserOptMoudleList;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.OptMethodUrlMap;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.po.UserSettingId;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.security.CentitUserDetailsImpl;
import com.centit.support.algorithm.StringRegularOpt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.access.SecurityConfig;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="platformEnvironment")
public class DBPlatformEnvironment
implements PlatformEnvironment {
    @Resource
    private CentitPasswordEncoder passwordEncoder;
    @Resource
    @NotNull
    private UserSettingDao userSettingDao;
    @Resource
    @NotNull
    private OptInfoDao optInfoDao;
    @Resource
    private UserInfoDao sysuserdao;
    @Resource
    @NotNull
    private DataDictionaryDao dictionaryDao;
    @Resource
    @NotNull
    protected DataCatalogDao dataCatalogDao;
    @Resource
    @NotNull
    private UserUnitDao userUnitDao;
    @Resource
    @NotNull
    protected UnitInfoDao unitInfoDao;
    @Resource
    @NotNull
    protected RoleInfoDao roleInfoDao;
    @Resource
    @NotNull
    private UserRoleDao userRoleDao;
    @Resource
    @NotNull
    protected OptMethodDao optMethodDao;
    @Resource
    @NotNull
    private RolePowerDao rolePowerDao;

    public boolean reloadDictionary() {
        return false;
    }

    @Transactional(readOnly=true)
    public boolean reloadSecurityMetadata() {
        CentitSecurityMetadata.optMethodRoleMap.clear();
        List rplist = this.rolePowerDao.listObjectsAll();
        if (rplist == null || rplist.size() == 0) {
            return false;
        }
        for (RolePower rp : rplist) {
            ArrayList<SecurityConfig> roles = (ArrayList<SecurityConfig>)CentitSecurityMetadata.optMethodRoleMap.get(rp.getOptCode());
            if (roles == null) {
                roles = new ArrayList<SecurityConfig>();
            }
            roles.add(new SecurityConfig("R_" + StringUtils.trim((String)rp.getRoleCode())));
            CentitSecurityMetadata.optMethodRoleMap.put(rp.getOptCode(), roles);
        }
        CentitSecurityMetadata.sortOptMethodRoleMap();
        List oulist = this.optInfoDao.listAllOptMethodUrlMap();
        CentitSecurityMetadata.optTreeNode.setChildList(null);
        CentitSecurityMetadata.optTreeNode.setOptCode(null);
        for (OptMethodUrlMap ou : oulist) {
            List sOpt = CentitSecurityMetadata.parseUrl((String)ou.getOptDefUrl(), (String)ou.getOptReq());
            for (List surls : sOpt) {
                OptTreeNode opt = CentitSecurityMetadata.optTreeNode;
                for (String surl : surls) {
                    opt = opt.setChildPath(surl);
                }
                opt.setOptCode(ou.getOptCode());
            }
        }
        return true;
    }

    public String getSystemParameter(String paramCode) {
        return SysParametersUtils.getStringValue((String)paramCode);
    }

    @Transactional(readOnly=true)
    public String getUserSetting(String userCode, String paramCode) {
        UserSetting us = this.userSettingDao.getObjectById(new UserSettingId(userCode, paramCode));
        if (us == null) {
            return null;
        }
        return us.getParamValue();
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos, String superOptId) {
        Iterator<OptInfo> menus = optInfos.iterator();
        OptInfo parentOpt = null;
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (superOptId != null && superOptId.equals(optInfo.getOptId())) {
                parentOpt = optInfo;
            }
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        if (superOptId != null && parentOpt != null) {
            return parentOpt.getChildren();
        }
        return parentMenu;
    }

    @Transactional(readOnly=true)
    public List<OptInfo> listUserMenuOptInfos(String userCode, boolean asAdmin) {
        List preOpts = this.optInfoDao.getMenuFuncByOptUrl();
        String optType = asAdmin ? "S" : "O";
        List ls = this.optInfoDao.getMenuFuncByUserID(userCode, optType);
        List<OptInfo> menuFunsByUser = DBPlatformEnvironment.getMenuFuncs(preOpts, ls);
        return this.formatMenuTree(menuFunsByUser, null);
    }

    @Transactional(readOnly=true)
    public List<OptInfo> listUserMenuOptInfosUnderSuperOptId(String userCode, String superOptId, boolean asAdmin) {
        List preOpts = this.optInfoDao.getMenuFuncByOptUrl();
        String optType = asAdmin ? "S" : "O";
        List ls = this.optInfoDao.getMenuFuncByUserID(userCode, optType);
        List<OptInfo> menuFunsByUser = DBPlatformEnvironment.getMenuFuncs(preOpts, ls);
        return this.formatMenuTree(menuFunsByUser, superOptId);
    }

    @Transactional(readOnly=true)
    public UserInfo getUserInfoByUserCode(String userCode) {
        return this.sysuserdao.getObjectById(userCode);
    }

    @Transactional(readOnly=true)
    public UserInfo getUserInfoByLoginName(String loginName) {
        return this.sysuserdao.getUserByLoginName(loginName);
    }

    @Transactional(readOnly=true)
    public IUnitInfo getUnitInfoByUnitCode(String unitCode) {
        return this.unitInfoDao.getObjectById(unitCode);
    }

    @Transactional
    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo user = this.sysuserdao.getObjectById(userCode);
        user.setUserPin(this.passwordEncoder.encodePassword(userPassword, (Object)user.getUserCode()));
        this.sysuserdao.saveObject(user);
    }

    @Transactional(readOnly=true)
    public boolean checkUserPassword(String userCode, String userPassword) {
        UserInfo user = this.sysuserdao.getObjectById(userCode);
        return this.passwordEncoder.isPasswordValid(user.getUserPin(), userPassword, (Object)user.getUserCode());
    }

    @Cacheable(value={"UserInfo"}, key="'userList'")
    @Transactional(readOnly=true)
    public List<UserInfo> listAllUsers() {
        return this.sysuserdao.listObjects();
    }

    @Cacheable(value={"UnitInfo"}, key="'unitList'")
    @Transactional(readOnly=true)
    public List<UnitInfo> listAllUnits() {
        return this.unitInfoDao.listObjects();
    }

    @Cacheable(value={"AllUserUnits"}, key="'allUserUnits'")
    @Transactional(readOnly=true)
    public List<UserUnit> listAllUserUnits() {
        return this.userUnitDao.listObjectsAll();
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"UserUnits"}, key="#userCode")
    public List<UserUnit> listUserUnits(String userCode) {
        List userUnits = this.userUnitDao.listUserUnitsByUserCode(userCode);
        if (userUnits != null) {
            for (UserUnit uu : userUnits) {
                IDataDictionary dd;
                if (null == uu || (dd = CodeRepositoryUtil.getDataPiece((String)"RankType", (String)uu.getUserRank())) == null || dd.getExtraCode() == null || !StringRegularOpt.isNumber((String)dd.getExtraCode())) continue;
                try {
                    uu.setXzRank(Integer.valueOf(dd.getExtraCode()).intValue());
                }
                catch (Exception e) {
                    uu.setXzRank(CodeRepositoryUtil.MAXXZRANK.intValue());
                }
            }
        }
        return userUnits;
    }

    @Cacheable(value={"UnitUsers"}, key="#unitCode")
    @Transactional(readOnly=true)
    public List<UserUnit> listUnitUsers(String unitCode) {
        List unitUsers = this.userUnitDao.listUnitUsersByUnitCode(unitCode);
        if (unitUsers != null) {
            for (UserUnit uu : unitUsers) {
                IDataDictionary dd;
                if (null == uu || (dd = CodeRepositoryUtil.getDataPiece((String)"RankType", (String)uu.getUserRank())) == null || dd.getExtraCode() == null || !StringRegularOpt.isNumber((String)dd.getExtraCode())) continue;
                try {
                    uu.setXzRank(Integer.valueOf(dd.getExtraCode()).intValue());
                }
                catch (Exception e) {
                    uu.setXzRank(CodeRepositoryUtil.MAXXZRANK.intValue());
                }
            }
        }
        return unitUsers;
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"RoleInfo"}, key="'roleCodeMap'")
    public Map<String, RoleInfo> getRoleRepo() {
        HashMap<String, RoleInfo> roleReop = new HashMap<String, RoleInfo>();
        List roleList = this.roleInfoDao.listObjectsAll();
        if (roleList != null) {
            for (RoleInfo roleinfo : roleList) {
                roleReop.put(roleinfo.getRoleCode(), roleinfo);
            }
        }
        return roleReop;
    }

    @Cacheable(value={"OptInfo"}, key="'optIdMap'")
    @Transactional(readOnly=true)
    public Map<String, OptInfo> getOptInfoRepo() {
        HashMap<String, OptInfo> optRepo = new HashMap<String, OptInfo>();
        List optList = this.optInfoDao.listObjectsAll();
        if (optList != null) {
            for (OptInfo optinfo : optList) {
                optRepo.put(optinfo.getOptId(), optinfo);
            }
        }
        return optRepo;
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"OptInfo"}, key="'optCodeMap'")
    public Map<String, OptMethod> getOptMethodRepo() {
        HashMap<String, OptMethod> powerRepo = new HashMap<String, OptMethod>();
        List optdefList = this.optMethodDao.listObjects();
        if (optdefList != null) {
            for (OptMethod optdef : optdefList) {
                powerRepo.put(optdef.getOptCode(), optdef);
            }
        }
        return powerRepo;
    }

    @Cacheable(value={"DataDictionary"}, key="'CatalogCode'")
    @Transactional(readOnly=true)
    public List<DataCatalog> listAllDataCatalogs() {
        return this.dataCatalogDao.listObjects();
    }

    @Cacheable(value={"DataDictionary"}, key="#catalogCode")
    @Transactional(readOnly=true)
    public List<DataDictionary> listDataDictionaries(String catalogCode) {
        return this.dictionaryDao.listDataDictionary(catalogCode);
    }

    @Cacheable(value={"UnitInfo"}, key="'unitCodeMap'")
    @Transactional(readOnly=true)
    public Map<String, UnitInfo> getUnitRepo() {
        HashMap<String, UnitInfo> unitRepo = new HashMap<String, UnitInfo>();
        List unitList = this.unitInfoDao.listObjects();
        if (unitList != null) {
            for (UnitInfo unitInfo : unitList) {
                unitRepo.put(unitInfo.getUnitCode(), unitInfo);
            }
        }
        for (Map.Entry entry : unitRepo.entrySet()) {
            UnitInfo pU;
            UnitInfo u = (UnitInfo)entry.getValue();
            String sParentUnit = u.getParentUnit();
            if (!"T".equals(u.getIsValid()) || sParentUnit == null || "".equals(sParentUnit) || "0".equals(sParentUnit) || (pU = (UnitInfo)unitRepo.get(sParentUnit)) == null) continue;
            pU.getSubUnits().add(u);
        }
        return unitRepo;
    }

    @Cacheable(value={"UserInfo"}, key="'userCodeMap'")
    @Transactional(readOnly=true)
    public Map<String, UserInfo> getUserRepo() {
        HashMap<String, UserInfo> userInfoMap = new HashMap<String, UserInfo>();
        List users = this.sysuserdao.listObjects();
        if (users != null) {
            for (UserInfo userInfo : users) {
                userInfoMap.put(userInfo.getUserCode(), userInfo);
            }
        }
        return userInfoMap;
    }

    @Cacheable(value={"UserInfo"}, key="'loginNameMap'")
    @Transactional(readOnly=true)
    public Map<String, ? extends IUserInfo> getLoginNameRepo() {
        HashMap<String, UserInfo> userInfoMap = new HashMap<String, UserInfo>();
        List users = this.sysuserdao.listObjects();
        if (users != null) {
            for (UserInfo userInfo : users) {
                userInfoMap.put(userInfo.getLoginName(), userInfo);
            }
        }
        return userInfoMap;
    }

    @Cacheable(value={"UnitInfo"}, key="'depNoMap'")
    @Transactional(readOnly=true)
    public Map<String, ? extends IUnitInfo> getDepNoRepo() {
        HashMap<String, UnitInfo> depNo = new HashMap<String, UnitInfo>();
        List unitList = this.unitInfoDao.listObjects();
        if (unitList != null) {
            for (UnitInfo unitinfo : unitList) {
                depNo.put(unitinfo.getDepNo(), unitinfo);
            }
        }
        return depNo;
    }

    @Transactional
    private CentitUserDetailsImpl fillUserDetailsField(UserInfo userinfo) {
        CentitUserDetailsImpl sysuser = new CentitUserDetailsImpl();
        sysuser.copy(userinfo);
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        roles.add(new RoleInfo("G-public", "general public", "G", "G", "T", "general public"));
        List ls = this.userRoleDao.getSysRolesByUserId(sysuser.getUserCode());
        if (ls != null) {
            for (FVUserRoles l : ls) {
                RoleInfo roleInfo = new RoleInfo();
                BeanUtils.copyProperties((Object)l, (Object)roleInfo);
                roles.add(roleInfo);
            }
        }
        List usun = this.userUnitDao.listUserUnitsByUserCode(sysuser.getUserCode());
        sysuser.setUserUnits(usun);
        if (roles == null || roles.size() < 1) {
            sysuser.setIsValid("F");
            return sysuser;
        }
        sysuser.setAuthoritiesByRoles(roles);
        List uoptlist = this.sysuserdao.getAllOptMethodByUser(sysuser.getUserCode());
        HashMap<String, String> userOptList = new HashMap<String, String>();
        if (uoptlist != null) {
            for (FVUserOptList opt : uoptlist) {
                if (StringUtils.isBlank((CharSequence)opt.getOptMethod())) continue;
                userOptList.put(opt.getOptId() + "-" + opt.getOptMethod(), "T");
            }
        }
        sysuser.setUserOptList(userOptList);
        List uss = this.userSettingDao.getUserSettingsByCode(sysuser.getUserCode());
        if (uss != null) {
            for (UserSetting us : uss) {
                sysuser.putUserSettingsParams(us.getParamCode(), us.getParamValue());
            }
        }
        return sysuser;
    }

    @Transactional
    public CentitUserDetailsImpl loadUserDetailsByLoginName(String loginName) {
        UserInfo userinfo = this.sysuserdao.getUserByLoginName(loginName);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetailsImpl loadUserDetailsByUserCode(String userCode) {
        UserInfo userinfo = this.sysuserdao.getUserByCode(userCode);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetailsImpl loadUserDetailsByRegEmail(String regEmail) {
        UserInfo userinfo = this.sysuserdao.getUserByRegEmail(regEmail);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetailsImpl loadUserDetailsByRegCellPhone(String regCellPhone) {
        UserInfo userinfo = this.sysuserdao.getUserByRegCellPhone(regCellPhone);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    private static List<OptInfo> getMenuFuncs(List<OptInfo> preOpts, List<FVUserOptMoudleList> ls) {
        int i;
        boolean[] isNeeds = new boolean[preOpts.size()];
        for (int i2 = 0; i2 < preOpts.size(); ++i2) {
            isNeeds[i2] = false;
        }
        ArrayList<OptInfo> opts = new ArrayList<OptInfo>();
        block1: for (FVUserOptMoudleList opm : ls) {
            OptInfo opt = new OptInfo();
            opt.setFormCode(opm.getFormcode());
            opt.setImgIndex(opm.getImgindex());
            opt.setIsInToolbar(opm.getIsintoolbar());
            opt.setMsgNo(opm.getMsgno());
            opt.setMsgPrm(opm.getMsgprm());
            opt.setOptId(opm.getOptid());
            opt.setOptType(opm.getOpttype());
            opt.setOptName(opm.getOptname());
            opt.setOptUrl(opm.getOpturl());
            opt.setPreOptId(opm.getPreoptid());
            opt.setTopOptId(opm.getTopoptid());
            opt.setPageType(opm.getPageType());
            opt.setOptRoute(opm.getOptRoute());
            opts.add(opt);
            for (i = 0; i < preOpts.size(); ++i) {
                if (opt.getPreOptId() == null || !opt.getPreOptId().equals(preOpts.get(i).getOptId())) continue;
                isNeeds[i] = true;
                continue block1;
            }
        }
        ArrayList<OptInfo> needAdd = new ArrayList<OptInfo>();
        for (int i3 = 0; i3 < preOpts.size(); ++i3) {
            if (!isNeeds[i3]) continue;
            needAdd.add(preOpts.get(i3));
        }
        boolean[] isNeeds2 = new boolean[preOpts.size()];
        block4: while (true) {
            int nestedMenu = 0;
            for (i = 0; i < preOpts.size(); ++i) {
                isNeeds2[i] = false;
            }
            block6: for (i = 0; i < needAdd.size(); ++i) {
                for (int j = 0; j < preOpts.size(); ++j) {
                    if (isNeeds[j] || ((OptInfo)needAdd.get(i)).getPreOptId() == null || !((OptInfo)needAdd.get(i)).getPreOptId().equals(preOpts.get(j).getOptId())) continue;
                    isNeeds[j] = true;
                    isNeeds2[j] = true;
                    ++nestedMenu;
                    continue block6;
                }
            }
            if (nestedMenu == 0) break;
            needAdd.clear();
            i = 0;
            while (true) {
                if (i >= preOpts.size()) continue block4;
                if (isNeeds2[i]) {
                    needAdd.add(preOpts.get(i));
                }
                ++i;
            }
            break;
        }
        for (int i4 = 0; i4 < preOpts.size(); ++i4) {
            if (!isNeeds[i4]) continue;
            opts.add(preOpts.get(i4));
        }
        return opts;
    }
}

