/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.system.dao.DataCatalogDao;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.po.DataCatalog;
import com.centit.framework.system.po.DataDictionary;
import com.centit.framework.system.po.DataDictionaryId;
import com.centit.framework.system.service.DataDictionaryManager;
import com.centit.support.algorithm.ListOpt;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dataDictionaryManager")
public class DataDictionaryManagerImpl
implements DataDictionaryManager {
    protected Logger logger = LoggerFactory.getLogger(DataDictionaryManagerImpl.class);
    @Resource
    @NotNull
    private DataDictionaryDao dictionaryDao;
    @Resource
    @NotNull
    protected DataCatalogDao dataCatalogDao;

    @Override
    @Transactional
    public List<DataDictionary> getDataDictionary(String catalogCode) {
        this.logger.info("\u7f13\u5b58\u6570\u636e\u5b57\u5178  DataDictionary \uff1a" + catalogCode + " ......");
        return this.dictionaryDao.listDataDictionary(catalogCode);
    }

    @Override
    @Transactional
    public DataCatalog getCatalogIncludeDataPiece(String catalogCode) {
        DataCatalog dc = this.dataCatalogDao.getObjectById(catalogCode);
        dc.addAllDataPiece(this.dictionaryDao.listDataDictionary(catalogCode));
        return dc;
    }

    @Override
    @Transactional
    @CacheEvict(value={"DataDictionary"}, key="#dataCatalog.catalogCode")
    public List<DataDictionary> saveCatalogIncludeDataPiece(DataCatalog dataCatalog, boolean isAdmin) {
        List newData;
        List oldData = this.dictionaryDao.listDataDictionary(dataCatalog.getCatalogCode());
        Triple dbOptList = ListOpt.compareTwoList((List)oldData, (List)(newData = dataCatalog.getDataDictionaries()), (o1, o2) -> o1.getDataCode().compareTo(o2.getDataCode()));
        if (dbOptList.getRight() != null) {
            for (DataDictionary dp : (List)dbOptList.getRight()) {
                if (!"U".equals(dp.getDataStyle()) && (!isAdmin || !"S".equals(dp.getDataStyle()))) continue;
                this.dictionaryDao.deleteObject(dp);
            }
        }
        if ((isAdmin || !"F".equals(dataCatalog.getCatalogStyle())) && dbOptList.getLeft() != null) {
            for (DataDictionary dp : (List)dbOptList.getLeft()) {
                this.dictionaryDao.saveNewObject(dp);
            }
        }
        if (null != dbOptList.getMiddle()) {
            for (Pair updateDp : (List)dbOptList.getMiddle()) {
                DataDictionary oldD = (DataDictionary)updateDp.getLeft();
                DataDictionary newD = (DataDictionary)updateDp.getRight();
                if ("F".equals(oldD.getDataStyle()) || !isAdmin && !"U".equals(oldD.getDataStyle())) continue;
                this.dictionaryDao.mergeObject(newD);
            }
        }
        return oldData;
    }

    @Override
    @Transactional
    @CacheEvict(value={"DataDictionary"}, key="#catalogCode")
    public void deleteDataDictionary(String catalogCode) {
        this.dictionaryDao.deleteDictionary(catalogCode);
        this.dataCatalogDao.deleteObjectById(catalogCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    @CacheEvict(value={"DataDictionary"}, key="#dd.catalogCode")
    public void deleteDataDictionaryPiece(DataDictionaryId dd) {
        this.dictionaryDao.deleteObjectById(dd);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    @CacheEvict(value={"DataDictionary"}, key="#dd.catalogCode")
    public void saveDataDictionaryPiece(DataDictionary dd) {
        this.dictionaryDao.mergeObject(dd);
    }

    @Override
    public String[] getFieldsDesc(String sDesc, String sType) {
        String[] nRes = new String[]{"\u6570\u636e\u4ee3\u7801", "\u6269\u5c55\u4ee3\u7801(\u7236\u4ee3\u7801)", "\u6269\u5c55\u4ee3\u7801(\u6392\u5e8f\u53f7)", "\u6807\u8bb0", "\u6570\u503c", "\u7c7b\u578b", "\u6570\u636e\u63cf\u8ff0"};
        if ("T".equals(sType)) {
            nRes[1] = "\u4e0a\u7ea7\u4ee3\u7801";
        }
        if (sDesc == null || "".equals(sDesc)) {
            return nRes;
        }
        String[] s = StringUtils.split((String)sDesc, (char)';');
        if (s == null) {
            return nRes;
        }
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            int p = s[i].indexOf(58);
            nRes[i] = p > 1 ? s[i].substring(0, p) : s[i];
        }
        return nRes;
    }

    @Override
    @Transactional
    public DataDictionary getDataDictionaryPiece(DataDictionaryId id) {
        return this.dictionaryDao.getObjectById(id);
    }

    @Override
    @Transactional
    public List<DataCatalog> listFixDataCatalog() {
        return this.dataCatalogDao.listFixCatalog();
    }

    @Override
    @Transactional
    public List<DataCatalog> listSysDataCatalog() {
        return this.dataCatalogDao.listSysCatalog();
    }

    @Override
    @Transactional
    public List<DataCatalog> listUserDataCatalog() {
        return this.dataCatalogDao.listUserCatalog();
    }

    @Override
    @Transactional
    public List<DataCatalog> listAllDataCatalog() {
        return this.dataCatalogDao.listObjects();
    }

    @Override
    @Transactional
    public List<DataDictionary> listDataDictionarys(Map<String, Object> filterDescMap) {
        return this.dictionaryDao.listObjects(filterDescMap);
    }

    @Override
    @Transactional
    public List<DataDictionary> getWholeDictionary() {
        return this.dictionaryDao.getWholeDictionary();
    }

    @Override
    @Transactional
    public DataCatalog getObjectById(String catalogCode) {
        return this.dataCatalogDao.getObjectById(catalogCode);
    }

    @Override
    @Transactional
    public void mergeObject(DataCatalog dataCatalog) {
        this.dataCatalogDao.mergeObject(dataCatalog);
    }

    @Override
    @Transactional
    public void saveNewObject(DataCatalog dataCatalog) {
        this.dataCatalogDao.saveNewObject(dataCatalog);
    }

    @Override
    @Transactional
    public List<DataCatalog> listObjects(Map<String, Object> filterDescMap, PageDesc pageDesc) {
        return this.dataCatalogDao.pageQuery(QueryParameterPrepare.prepPageParams(filterDescMap, (com.centit.support.database.utils.PageDesc)pageDesc, (int)this.dataCatalogDao.pageCount(filterDescMap)));
    }
}

