/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.system.dao.OptFlowNoInfoDao;
import com.centit.framework.system.dao.OptFlowNoPoolDao;
import com.centit.framework.system.po.OptFlowNoInfo;
import com.centit.framework.system.po.OptFlowNoInfoId;
import com.centit.framework.system.po.OptFlowNoPool;
import com.centit.framework.system.po.OptFlowNoPoolId;
import com.centit.framework.system.service.OptFlowNoInfoManager;
import com.centit.support.algorithm.DatetimeOpt;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OptFlowNoInfoManagerImpl
implements OptFlowNoInfoManager {
    public static final Logger logger = LoggerFactory.getLogger(OptFlowNoInfoManager.class);
    @Resource
    @NotNull
    private OptFlowNoInfoDao optFlowNoInfoDao;
    @Resource
    @NotNull
    private OptFlowNoPoolDao optFlowNoPoolDao;

    public synchronized void setOptFlowNoPoolDao(OptFlowNoPoolDao baseDao) {
        this.optFlowNoPoolDao = baseDao;
    }

    @Override
    public synchronized long newNextLsh(String ownerCode, String codeCode, Date codeBaseDate) {
        Date codeDate = codeBaseDate;
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        long nextCode = 1L;
        if (noInfo == null) {
            noInfo = new OptFlowNoInfo(noId, Long.valueOf(1L), DatetimeOpt.currentUtilDate());
        } else {
            OptFlowNoPoolId poolId;
            OptFlowNoPool poolNo;
            nextCode = noInfo.getCurNo() + 1L;
            while ((poolNo = this.optFlowNoPoolDao.getObjectById(poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, Long.valueOf(nextCode)))) != null) {
                ++nextCode;
            }
            noInfo.setCurNo(Long.valueOf(nextCode));
            noInfo.setLastCodeDate(DatetimeOpt.currentUtilDate());
        }
        this.optFlowNoInfoDao.saveObject(noInfo);
        return nextCode;
    }

    @Override
    public long newNextLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate));
    }

    @Override
    public long newNextLsh(String codeCode) {
        return this.newNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public long newNextLsh(String ownerCode, String codeCode) {
        return this.newNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public synchronized long viewNextLsh(String ownerCode, String codeCode, Date codeBaseDate) {
        Date codeDate = codeBaseDate;
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        long nextCode = 1L;
        if (noInfo != null) {
            nextCode = noInfo.getCurNo() + 1L;
        }
        return nextCode;
    }

    @Override
    public long viewNextLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate));
    }

    @Override
    public long viewNextLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate));
    }

    @Override
    public long viewNextLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate));
    }

    @Override
    public long viewNextLsh(String codeCode) {
        return this.viewNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public long viewNextLsh(String ownerCode, String codeCode) {
        return this.viewNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public synchronized void recordNextLsh(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        Date codeDate = codeBaseDate;
        OptFlowNoPoolId poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, Long.valueOf(currCode));
        OptFlowNoPool poolNo = this.optFlowNoPoolDao.getObjectById(poolId);
        if (poolNo != null) {
            this.optFlowNoPoolDao.deleteObject(poolNo);
            return;
        }
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        if (noInfo == null) {
            noInfo = new OptFlowNoInfo(noId, Long.valueOf(currCode), DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveObject(noInfo);
        } else if (noInfo.getCurNo() < currCode) {
            noInfo.setCurNo(Long.valueOf(currCode));
            noInfo.setLastCodeDate(DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveObject(noInfo);
        }
    }

    @Override
    public void recordNextLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLsh(String codeCode, long currCode) {
        this.recordNextLsh("noowner", codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public void recordNextLsh(String ownerCode, String codeCode, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public synchronized long assignNextLsh(String ownerCode, String codeCode, Date codeBaseDate) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ownerCode", ownerCode);
        map.put("codeCode", codeCode);
        map.put("codeBaseDate", String.valueOf(codeBaseDate));
        long minPoolNo = this.optFlowNoPoolDao.fetchFirstLsh(ownerCode, codeCode, codeBaseDate);
        if (minPoolNo > 0L) {
            OptFlowNoPoolId obj = new OptFlowNoPoolId();
            obj.setOwnerCode(ownerCode);
            obj.setCodeDate(codeBaseDate);
            obj.setCodeCode(codeCode);
            obj.setCurNo(Long.valueOf(minPoolNo));
            this.optFlowNoPoolDao.deleteObjectById(obj);
            return minPoolNo;
        }
        return this.newNextLsh(ownerCode, codeCode, codeBaseDate);
    }

    @Override
    public long assignNextLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate));
    }

    @Override
    public long assignNextLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate));
    }

    @Override
    public long assignNextLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate));
    }

    @Override
    public long assignNextLsh(String ownerCode, String codeCode) {
        return this.assignNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public long assignNextLsh(String codeCode) {
        return this.assignNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public void releaseLsh(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        OptFlowNoPool obj = new OptFlowNoPool();
        obj.setOwnerCode(ownerCode);
        obj.setCodeDate(codeBaseDate);
        obj.setCodeCode(codeCode);
        obj.setCurNo(Long.valueOf(currCode));
        obj.setCreateDate(DatetimeOpt.currentUtilDate());
        this.optFlowNoPoolDao.saveObject(obj);
    }

    @Override
    public void releaseLshBaseDay(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLshBaseMonth(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLshBaseYear(String ownerCode, String codeCode, Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLsh(String ownerCode, String codeCode, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public void releaseLsh(String codeCode, long currCode) {
        this.releaseLsh("noowner", codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String ownerCode, String codeCode, Date codeBaseDate, PageDesc pageDesc) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("ownerCode", ownerCode);
        filterMap.put("codeDate", codeBaseDate);
        filterMap.put("codeCode", codeCode);
        return this.optFlowNoPoolDao.pageQuery(QueryParameterPrepare.prepPageParams(filterMap, (com.centit.support.database.utils.PageDesc)pageDesc, (int)this.optFlowNoPoolDao.pageCount(filterMap)));
    }

    @Override
    public List<OptFlowNoPool> listLshBaseDayInPool(String ownerCode, String codeCode, Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToDay((Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshBaseMonthInPool(String ownerCode, String codeCode, Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToMonth((Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshBaseYearInPool(String ownerCode, String codeCode, Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToYear((Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String ownerCode, String codeCode, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DefaultCodeDate, pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String codeCode, PageDesc pageDesc) {
        return this.listLshInPool("noowner", codeCode, DefaultCodeDate, pageDesc);
    }
}

