/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.system.dao.OptDataScopeDao;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.po.OptDataScope;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.service.OptInfoManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="functionManager")
public class OptInfoManagerImpl
implements OptInfoManager {
    @Resource
    @NotNull
    protected OptInfoDao optInfoDao;
    @Resource(name="optMethodDao")
    @NotNull
    protected OptMethodDao optMethodDao;
    @Resource(name="optDataScopeDao")
    @NotNull
    protected OptDataScopeDao dataScopeDao;
    @Resource(name="rolePowerDao")
    @NotNull
    protected RolePowerDao rolePowerDao;

    @Override
    @Transactional(readOnly=true)
    public Map<String, OptInfo> listObjectToOptRepo() {
        HashMap<String, OptInfo> optRepo = new HashMap<String, OptInfo>();
        List<OptInfo> optList = this.listObjects();
        if (optList != null) {
            for (OptInfo optinfo : optList) {
                optRepo.put(optinfo.getOptId(), optinfo);
            }
        }
        return optRepo;
    }

    @Override
    @CacheEvict(value={"OptInfo"}, allEntries=true)
    @Transactional
    public void updateOptInfoProperties(OptInfo optinfo) {
        this.optInfoDao.mergeObject(optinfo);
    }

    @Override
    @Transactional
    public boolean hasChildren(String optId) {
        return this.optInfoDao.countChildrenSum(optId) > 0;
    }

    @Override
    @CacheEvict(value={"OptInfo"}, allEntries=true)
    @Transactional
    public void saveNewOptInfo(OptInfo optInfo) {
        this.syncState(optInfo);
        OptInfo parentOpt = this.optInfoDao.getObjectById(optInfo.getPreOptId());
        if (null != parentOpt) {
            if (!"...".equals(parentOpt.getOptRoute())) {
                parentOpt.setOptRoute("...");
                this.optInfoDao.mergeObject(parentOpt);
            }
        } else {
            optInfo.setPreOptId("0");
        }
        this.optInfoDao.saveNewObject(optInfo);
        if (optInfo.getOptMethods() != null && optInfo.getOptMethods().size() > 0) {
            for (OptMethod o : optInfo.getOptMethods()) {
                o.setOptCode(this.optMethodDao.getNextOptCode());
                o.setOptId(optInfo.getOptId());
                this.optMethodDao.saveNewObject(o);
            }
        } else if (!"W".equals(optInfo.getOptType())) {
            OptMethod createDef = new OptMethod();
            createDef.setOptCode(this.optMethodDao.getNextOptCode());
            createDef.setOptId(optInfo.getOptId());
            createDef.setOptName("\u65b0\u5efa");
            createDef.setOptUrl("/");
            createDef.setOptReq("C");
            createDef.setOptDesc("\u65b0\u5efa\uff08\u7cfb\u7edf\u9ed8\u8ba4\uff09");
            this.optMethodDao.saveNewObject(createDef);
            OptMethod updateDef = new OptMethod();
            updateDef.setOptCode(this.optMethodDao.getNextOptCode());
            updateDef.setOptId(optInfo.getOptId());
            updateDef.setOptName("\u7f16\u8f91");
            updateDef.setOptUrl("/*");
            updateDef.setOptReq("U");
            updateDef.setOptDesc("\u7f16\u8f91\uff08\u7cfb\u7edf\u9ed8\u8ba4\uff09");
            this.optMethodDao.saveNewObject(updateDef);
            OptMethod deleteDef = new OptMethod();
            deleteDef.setOptCode(this.optMethodDao.getNextOptCode());
            deleteDef.setOptId(optInfo.getOptId());
            deleteDef.setOptName("\u5220\u9664");
            deleteDef.setOptUrl("/*");
            deleteDef.setOptReq("D");
            deleteDef.setOptDesc("\u5220\u9664\uff08\u7cfb\u7edf\u9ed8\u8ba4\uff09");
            this.optMethodDao.saveNewObject(deleteDef);
        }
    }

    @Override
    @CacheEvict(value={"OptInfo"}, allEntries=true)
    @Transactional
    public void updateOptInfo(OptInfo optInfo) {
        this.syncState(optInfo);
        this.optInfoDao.mergeObject(optInfo);
    }

    @Override
    @CacheEvict(value={"OptInfo"}, allEntries=true)
    @Transactional
    public Map<String, List> updateOperationPower(OptInfo optInfo) {
        HashMap<String, List> result = new HashMap<String, List>();
        List newOpts = optInfo.getOptMethods();
        if (newOpts.size() > 0) {
            for (OptMethod o : newOpts) {
                if (StringUtils.isBlank((CharSequence)o.getOptCode())) {
                    o.setOptCode(this.optMethodDao.getNextOptCode());
                }
                o.setOptId(optInfo.getOptId());
            }
        }
        List oldOpts = this.optMethodDao.listOptMethodByOptID(optInfo.getOptId());
        ArrayList<OptMethod> optMethods = new ArrayList<OptMethod>();
        for (Object o : oldOpts) {
            OptMethod optMethod = new OptMethod();
            BeanUtils.copyProperties((Object)o, (Object)optMethod);
            optMethods.add(optMethod);
        }
        result.put("methods", optMethods);
        if (oldOpts != null) {
            for (Object o : oldOpts) {
                if (newOpts.contains(o)) continue;
                this.optMethodDao.deleteObject((OptMethod)o);
                this.rolePowerDao.deleteRolePowersByOptCode(o.getOptCode());
            }
        }
        for (Object o : newOpts) {
            this.optMethodDao.mergeObject((OptMethod)o);
        }
        List newDataScopes = optInfo.getDataScopes();
        if (newDataScopes.size() > 0) {
            for (OptDataScope s : newDataScopes) {
                if (StringUtils.isBlank((CharSequence)s.getOptScopeCode())) {
                    s.setOptScopeCode(this.dataScopeDao.getNextOptCode());
                }
                s.setOptId(optInfo.getOptId());
            }
        }
        List oldDataScopes = this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId());
        ArrayList<OptDataScope> dataScopes = new ArrayList<OptDataScope>();
        for (OptDataScope o : oldDataScopes) {
            OptDataScope optDataScope = new OptDataScope();
            BeanUtils.copyProperties((Object)o, (Object)optDataScope);
            dataScopes.add(optDataScope);
        }
        result.put("scopes", dataScopes);
        if (oldDataScopes != null) {
            for (OptDataScope s : oldDataScopes) {
                if (newDataScopes.contains(s)) continue;
                this.dataScopeDao.deleteObject(s);
            }
        }
        for (OptDataScope s : newDataScopes) {
            this.dataScopeDao.mergeObject(s);
        }
        return result;
    }

    @Override
    @Transactional
    public OptInfo getOptInfoById(String optId) {
        OptInfo oinfo = this.optInfoDao.getObjectById(optId);
        if (oinfo != null) {
            oinfo.addAllOptMethods(this.optMethodDao.listOptMethodByOptID(optId));
            oinfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optId));
        }
        return oinfo;
    }

    @Override
    @CacheEvict(value={"OptInfo"}, allEntries=true)
    @Transactional
    public void deleteOptInfoById(String optId) {
        this.dataScopeDao.deleteDataScopeOfOptID(optId);
        this.optMethodDao.deleteOptMethodsByOptID(optId);
        this.optInfoDao.deleteObjectById(optId);
    }

    @Override
    @Transactional
    public void deleteOptInfo(OptInfo optinfo) {
        this.deleteOptInfoById(optinfo.getOptId());
    }

    @Override
    @Transactional
    public List<OptInfo> listSysAndOptPowerOpts() {
        return this.optInfoDao.listObjectsByCon("  (optType='S' or optType='O')");
    }

    @Override
    @Transactional
    public List<OptInfo> listItemPowerOpts() {
        return this.optInfoDao.listObjectsByCon("  optType='I'");
    }

    @Override
    @Transactional
    public List<String> listUserDataFiltersByOptIDAndMethod(String sUserCode, String sOptId, String sOptMethod) {
        List dataScopes = this.optInfoDao.listUserDataPowerByOptMethod(sUserCode, sOptId, sOptMethod);
        if (dataScopes == null || dataScopes.size() == 0) {
            return null;
        }
        HashSet<String> scopeCodes = new HashSet<String>();
        for (String scopes : dataScopes) {
            String[] codes;
            if (scopes == null || "null".equalsIgnoreCase(scopes) || "all".equalsIgnoreCase(scopes)) {
                return null;
            }
            for (String code : codes = scopes.split(",")) {
                if (code == null || "".equals(code.trim())) continue;
                scopeCodes.add(code.trim());
            }
        }
        if (scopeCodes.size() == 0) {
            return null;
        }
        return this.dataScopeDao.listDataFiltersByIds(scopeCodes);
    }

    @Override
    @Transactional
    public List<OptInfo> listObjectFormatTree(List<OptInfo> optInfos, boolean fillDefAndScope) {
        Iterator<OptInfo> menus = optInfos.iterator();
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (fillDefAndScope) {
                optInfo.addAllOptMethods(this.optMethodDao.listOptMethodByOptID(optInfo.getOptId()));
                optInfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId()));
            }
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        return parentMenu;
    }

    @Override
    @Transactional
    public List<OptInfo> listOptWithPowerUnderUnit(String sUnitCode) {
        List allOpts = this.optInfoDao.listObjectsByCon(" (optType='S' or optType='O')");
        List optDefs = this.optMethodDao.listOptMethodByRoleCode("G$" + sUnitCode);
        HashSet<OptInfo> roleOpts = new HashSet<OptInfo>();
        for (OptInfo optInfo : allOpts) {
            for (OptMethod def : optDefs) {
                if (!optInfo.getOptId().equals(def.getOptId())) continue;
                optInfo.addOptMethod(def);
            }
            if (optInfo.getOptMethods().size() <= 0) continue;
            optInfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId()));
            roleOpts.add(optInfo);
        }
        HashSet<OptInfo> preParents = new HashSet<OptInfo>();
        preParents.addAll(roleOpts);
        while (true) {
            int parents = 0;
            HashSet<OptInfo> parentMenu = new HashSet<OptInfo>();
            block3: for (OptInfo optInfo : preParents) {
                for (OptInfo opt : allOpts) {
                    if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                    parentMenu.add(opt);
                    roleOpts.add(opt);
                    ++parents;
                    continue block3;
                }
            }
            if (parents == 0) break;
            preParents = parentMenu;
        }
        ArrayList<OptInfo> roleOptInfos = new ArrayList<OptInfo>();
        roleOptInfos.addAll(roleOpts);
        return roleOptInfos;
    }

    @Override
    @Transactional
    public List<OptInfo> getFunctionsByRoleCode(String unitRoleCode) {
        return new ArrayList<OptInfo>();
    }

    @Override
    public List<OptInfo> listObjects() {
        return this.optInfoDao.listObjectsAll();
    }

    @Override
    public List<OptInfo> listObjects(Map<String, Object> filterMap) {
        return this.optInfoDao.listObjects(filterMap);
    }

    @Override
    public OptInfo getObjectById(String optId) {
        return this.optInfoDao.getObjectById(optId);
    }

    private List<OptInfo> findSubOptInfo(String optId) {
        ArrayList<OptInfo> result = new ArrayList<OptInfo>();
        List optInfos = this.optInfoDao.listObjectByProperty("preOptId", (Object)optId);
        if (optInfos != null && optInfos.size() > 0) {
            result.addAll(optInfos);
            for (OptInfo o : optInfos) {
                result.addAll(this.findSubOptInfo(o.getOptId()));
            }
        }
        return result;
    }

    private List<OptInfo> findPreOptInfo(String preId) {
        ArrayList<OptInfo> result = new ArrayList<OptInfo>();
        OptInfo optInfo = this.optInfoDao.getObjectById(preId);
        if (optInfo != null) {
            result.add(optInfo);
            result.addAll(this.findPreOptInfo(optInfo.getPreOptId()));
        }
        return result;
    }

    private void syncState(OptInfo optInfo) {
        if ("N".equals(optInfo.getIsInToolbar())) {
            List<OptInfo> optInfos = this.findSubOptInfo(optInfo.getOptId());
            for (OptInfo o : optInfos) {
                o.setIsInToolbar("N");
                this.optInfoDao.mergeObject(o);
            }
        } else {
            List<OptInfo> optInfos = this.findPreOptInfo(optInfo.getPreOptId());
            for (OptInfo o : optInfos) {
                o.setIsInToolbar("Y");
                this.optInfoDao.mergeObject(o);
            }
        }
    }
}

