/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.security.model.CentitSecurityMetadata;
import com.centit.framework.security.model.OptTreeNode;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.OptMethodUrlMap;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.VOptTree;
import com.centit.framework.system.service.SysRoleManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.security.access.SecurityConfig;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysRoleManager")
public class SysRoleManagerImpl
implements SysRoleManager {
    public static Logger logger = LoggerFactory.getLogger(SysRoleManagerImpl.class);
    @Resource
    @NotNull
    private OptInfoDao optInfoDao;
    @Resource
    @NotNull
    private OptMethodDao optMethodDao;
    @Resource
    @NotNull
    private RolePowerDao rolePowerDao;
    @Resource
    @NotNull
    protected RoleInfoDao roleInfoDao;

    @Override
    @Transactional(readOnly=true)
    public void loadRoleSecurityMetadata() {
        CentitSecurityMetadata.optMethodRoleMap.clear();
        List<RolePower> rplist = this.listAllRolePowers();
        if (rplist == null || rplist.size() == 0) {
            return;
        }
        for (RolePower rp : rplist) {
            ArrayList<SecurityConfig> roles = (ArrayList<SecurityConfig>)CentitSecurityMetadata.optMethodRoleMap.get(rp.getOptCode());
            if (roles == null) {
                roles = new ArrayList<SecurityConfig>();
            }
            roles.add(new SecurityConfig("R_" + StringUtils.trim((String)rp.getRoleCode())));
            CentitSecurityMetadata.optMethodRoleMap.put(rp.getOptCode(), roles);
        }
        CentitSecurityMetadata.sortOptMethodRoleMap();
        List<OptMethodUrlMap> oulist = this.listAllOptMethodUrlMap();
        CentitSecurityMetadata.optTreeNode.setChildList(null);
        CentitSecurityMetadata.optTreeNode.setOptCode(null);
        for (OptMethodUrlMap ou : oulist) {
            List sOpt = CentitSecurityMetadata.parseUrl((String)ou.getOptDefUrl(), (String)ou.getOptReq());
            for (List surls : sOpt) {
                OptTreeNode opt = CentitSecurityMetadata.optTreeNode;
                for (String surl : surls) {
                    opt = opt.setChildPath(surl);
                }
                opt.setOptCode(ou.getOptCode());
            }
        }
    }

    @Override
    @Transactional
    public List<RolePower> getRolePowers(String rolecode) {
        return this.rolePowerDao.listRolePowersByRoleCode(rolecode);
    }

    @Override
    @Transactional
    public List<RolePower> getRolePowersByDefCode(String optCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("optCode", optCode);
        return this.rolePowerDao.listObjects(filterMap);
    }

    @Override
    @CacheEvict(value={"RoleInfo"}, key="'roleCodeMap'")
    @Transactional
    public Serializable saveNewRoleInfo(RoleInfo o) {
        this.roleInfoDao.saveNewObject(o);
        return o.getRoleCode();
    }

    @Override
    @Transactional
    public List<VOptTree> getVOptTreeList() {
        return this.roleInfoDao.getVOptTreeList();
    }

    @Override
    @Transactional
    public List<RolePower> listAllRolePowers() {
        return this.rolePowerDao.listObjectsAll();
    }

    @Override
    @Transactional
    public List<OptMethod> listAllOptMethods() {
        return this.optMethodDao.listObjects();
    }

    @Transactional
    private List<OptMethodUrlMap> listAllOptMethodUrlMap() {
        return this.optInfoDao.listAllOptMethodUrlMap();
    }

    @Override
    @CacheEvict(value={"RoleInfo"}, allEntries=true)
    @Transactional
    public void updateRoleInfo(RoleInfo o) {
        this.roleInfoDao.mergeObject(o);
    }

    @Override
    @CacheEvict(value={"RoleInfo"}, allEntries=true)
    @Transactional
    public List<RolePower> updateRolePower(RoleInfo o) {
        this.roleInfoDao.mergeObject(o);
        List newRPs = o.getRolePowers();
        List rps = this.rolePowerDao.listRolePowersByRoleCode(o.getRoleCode());
        if (newRPs == null || newRPs.size() < 1) {
            return rps;
        }
        for (RolePower rp : newRPs) {
            rp.setRoleCode(o.getRoleCode());
        }
        if (rps != null) {
            for (RolePower rp : rps) {
                if (newRPs.contains(rp)) continue;
                this.rolePowerDao.deleteObject(rp);
            }
        }
        for (RolePower rp : newRPs) {
            this.rolePowerDao.mergeObject(rp);
        }
        return rps;
    }

    @Override
    @CacheEvict(value={"RoleInfo"}, allEntries=true)
    @Transactional
    public void deleteRoleInfo(String roleCode) {
        this.rolePowerDao.deleteRolePowersByRoleCode(roleCode);
        this.roleInfoDao.deleteObjectById(roleCode);
    }

    @Override
    @Transactional
    public RoleInfo getRoleInfo(String roleCode) {
        RoleInfo rf = this.roleInfoDao.getObjectById(roleCode);
        rf.addAllRolePowers(this.rolePowerDao.listRolePowersByRoleCode(roleCode));
        return rf;
    }

    @Override
    @Transactional
    public List<RoleInfo> listObjects(Map<String, Object> filterMap) {
        return this.roleInfoDao.listObjects(filterMap);
    }

    @Override
    @Transactional
    public List<RoleInfo> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.roleInfoDao.pageQuery(QueryParameterPrepare.prepPageParams(filterMap, (com.centit.support.database.utils.PageDesc)pageDesc, (int)this.roleInfoDao.pageCount(filterMap)));
    }

    @Override
    @Transactional
    public RoleInfo getObjectById(String roleCode) {
        return this.roleInfoDao.getObjectById(roleCode);
    }

    @Override
    @Transactional
    public int countRoleUserSum(String roleCode) {
        return this.roleInfoDao.countRoleUserSum(roleCode);
    }

    @Override
    @Transactional
    public boolean isRoleNameNotExist(String unitCode, String roleName, String roleCode) {
        boolean isEmpty;
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("publicUnitRole", unitCode + "-%");
        filterMap.put("roleNameEq", roleName);
        List roleInfos = this.roleInfoDao.listObjects(filterMap);
        boolean bl = isEmpty = roleInfos == null || roleInfos.size() == 0;
        return isEmpty ? true : roleCode != null && roleCode.equals(((RoleInfo)roleInfos.get(0)).getRoleCode());
    }
}

