/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUnitManager")
@Transactional
public class SysUnitManagerImpl
implements SysUnitManager {
    public static Logger logger = LoggerFactory.getLogger(SysUnitManagerImpl.class);
    @Resource
    @NotNull
    private UserUnitDao userUnitDao;
    @Resource
    @NotNull
    protected UnitInfoDao unitInfoDao;

    @Override
    public List<UnitInfo> listObjectsAsSort(Map<String, Object> searchColumn) {
        List listObjects = this.unitInfoDao.listObjects(searchColumn);
        block0: for (UnitInfo unitInfo : listObjects) {
            if (StringBaseOpt.isNvl((String)unitInfo.getParentUnit()) || "0".equals(unitInfo.getParentUnit())) continue;
            for (UnitInfo opt : listObjects) {
                if (!opt.getUnitCode().equals(unitInfo.getParentUnit())) continue;
                opt.getSubUnits().add(unitInfo);
                continue block0;
            }
        }
        ArrayList<UnitInfo> parentUnit = new ArrayList<UnitInfo>();
        for (UnitInfo unitInfo : listObjects) {
            if (!StringBaseOpt.isNvl((String)unitInfo.getParentUnit()) && !"0".equals(unitInfo.getParentUnit())) continue;
            parentUnit.add(unitInfo);
        }
        return parentUnit;
    }

    public UnitInfo getObject(UnitInfo object) {
        UnitInfo newObj = this.unitInfoDao.getObjectById(object.getUnitCode());
        if (newObj == null) {
            newObj = object;
            newObj.setUnitCode(this.unitInfoDao.getNextKey());
            newObj.setIsValid("T");
        }
        return newObj;
    }

    @Override
    public List<UserInfo> getUnitUsers(String unitCode) {
        return this.unitInfoDao.listUnitUsers(unitCode);
    }

    @Override
    public List<UserInfo> getRelationUsers(String unitCode) {
        return this.unitInfoDao.listRelationUsers(unitCode);
    }

    @Override
    public String getUnitCode(String depno) {
        return this.unitInfoDao.getUnitCode(depno);
    }

    @Override
    public UnitInfo getUnitByName(String name) {
        return this.unitInfoDao.getUnitByName(name);
    }

    @Override
    @CacheEvict(value={"UnitInfo"}, allEntries=true)
    @Transactional
    public void changeStatus(String unitCode, String isValid) {
        List allSubUnits = this.unitInfoDao.listAllSubUnits(unitCode);
        for (UnitInfo subUnit : allSubUnits) {
            subUnit.setIsValid(isValid);
            this.unitInfoDao.mergeObject(subUnit);
        }
    }

    @Override
    @CacheEvict(value={"UnitInfo", "UnitUsers", "UserUnits", "AllUserUnits"}, allEntries=true)
    @Transactional
    public void deleteUnitInfo(UnitInfo unitinfo) {
        String oldUnitPath = unitinfo.getUnitPath();
        List subUnits = this.unitInfoDao.listSubUnitsByUnitPaht(oldUnitPath);
        int noupl = oldUnitPath.length();
        for (UnitInfo ui : subUnits) {
            if (unitinfo.getUnitCode().equals(ui.getParentUnit())) {
                ui.setParentUnit("0");
            }
            ui.setParentUnit(ui.getUnitPath().substring(noupl));
            this.unitInfoDao.mergeObject(ui);
        }
        this.userUnitDao.deleteUserUnitByUnit(unitinfo.getUnitCode());
        this.unitInfoDao.deleteObjectById(unitinfo.getUnitCode());
    }

    @Override
    @CacheEvict(value={"UnitInfo"}, allEntries=true)
    @Transactional
    public String saveNewUnitInfo(UnitInfo unitinfo) {
        unitinfo.setUnitCode(this.unitInfoDao.getNextKey());
        UnitInfo parentUnit = this.unitInfoDao.getObjectById(unitinfo.getParentUnit());
        if (parentUnit == null) {
            unitinfo.setUnitPath("/" + unitinfo.getUnitCode());
        } else {
            unitinfo.setUnitPath(parentUnit.getUnitPath() + "/" + unitinfo.getUnitCode());
        }
        this.unitInfoDao.saveNewObject(unitinfo);
        return unitinfo.getUnitCode();
    }

    @Override
    @Transactional
    public boolean isUniqueName(UnitInfo unitInfo) {
        UnitInfo dbUnitInfo = this.unitInfoDao.getPeerUnitByName(unitInfo.getUnitName(), unitInfo.getParentUnit(), unitInfo.getUnitCode());
        return dbUnitInfo == null;
    }

    @Override
    @CacheEvict(value={"UnitInfo"}, allEntries=true)
    @Transactional
    public void updateUnitInfo(UnitInfo unitinfo) {
        UnitInfo dbUnitInfo = this.unitInfoDao.getObjectById(unitinfo.getUnitCode());
        String oldParentUnit = dbUnitInfo.getParentUnit();
        String oldUnitPath = dbUnitInfo.getUnitPath();
        BeanUtils.copyProperties((Object)unitinfo, (Object)dbUnitInfo, (String[])new String[]{"unitCode"});
        if (!StringUtils.equals((CharSequence)oldParentUnit, (CharSequence)unitinfo.getParentUnit())) {
            UnitInfo parentUnit = this.unitInfoDao.getObjectById(unitinfo.getParentUnit());
            if (parentUnit == null) {
                unitinfo.setUnitPath("/" + unitinfo.getUnitCode());
            } else {
                unitinfo.setUnitPath(parentUnit.getUnitPath() + "/" + unitinfo.getUnitCode());
            }
            List subUnits = this.unitInfoDao.listSubUnitsByUnitPaht(oldUnitPath);
            int noupl = oldUnitPath.length();
            for (UnitInfo ui : subUnits) {
                ui.setParentUnit(unitinfo.getUnitPath() + ui.getUnitPath().substring(noupl));
                this.unitInfoDao.mergeObject(ui);
            }
        }
        this.unitInfoDao.mergeObject(dbUnitInfo);
    }

    @Override
    @Transactional
    public List<UnitInfo> listAllSubObjects(String primaryUnit) {
        if (StringUtils.isBlank((CharSequence)primaryUnit)) {
            return null;
        }
        return this.unitInfoDao.listAllSubUnits(primaryUnit);
    }

    @Override
    @Transactional
    public List<UnitInfo> listAllSubObjectsAsSort(String primaryUnit) {
        List listObjects = this.unitInfoDao.listAllSubUnits(primaryUnit);
        block0: for (UnitInfo unitInfo : listObjects) {
            if (StringBaseOpt.isNvl((String)unitInfo.getParentUnit()) || "0".equals(unitInfo.getParentUnit())) continue;
            for (UnitInfo opt : listObjects) {
                if (!opt.getUnitCode().equals(unitInfo.getParentUnit())) continue;
                opt.getSubUnits().add(unitInfo);
                continue block0;
            }
        }
        ArrayList<UnitInfo> parentUnit = new ArrayList<UnitInfo>();
        for (UnitInfo unitInfo : listObjects) {
            if (!StringBaseOpt.isNvl((String)unitInfo.getParentUnit()) && !primaryUnit.equals(unitInfo.getUnitCode())) continue;
            parentUnit.add(unitInfo);
        }
        return parentUnit;
    }

    @Override
    @Transactional
    public boolean hasChildren(String unitCode) {
        return this.unitInfoDao.countChildrenSum(unitCode) > 0;
    }

    @Override
    @Transactional
    public List<UnitInfo> listObjects(Map<String, Object> filterMap) {
        return this.unitInfoDao.listObjects(filterMap);
    }

    @Override
    @Transactional
    public List<UnitInfo> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.unitInfoDao.pageQuery(QueryParameterPrepare.prepPageParams(filterMap, (com.centit.support.database.utils.PageDesc)pageDesc, (int)this.unitInfoDao.pageCount(filterMap)));
    }

    @Override
    @Transactional
    public UnitInfo getObjectById(String unitCode) {
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
        return unitInfo;
    }

    @Override
    @Transactional
    public void checkState(List<UnitInfo> listObjects) {
        List objs = this.unitInfoDao.getAllParentUnit();
        if (objs != null && objs.size() > 0) {
            for (UnitInfo u : listObjects) {
                if (objs.contains(u.getUnitCode())) {
                    u.setState("closed");
                    continue;
                }
                u.setState("opend");
            }
        } else {
            for (UnitInfo u : listObjects) {
                u.setState("opend");
            }
        }
    }
}

