/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.model.basedata.IDataDictionary;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserUnitManager")
@Transactional
public class SysUserUnitManagerImpl
implements SysUserUnitManager {
    @Resource
    @NotNull
    protected UserUnitDao userUnitDao;
    @Resource(name="userInfoDao")
    @NotNull
    private UserInfoDao userInfoDao;

    @Override
    @Transactional(readOnly=true)
    public List<UserUnit> listObjectByUserUnit(String userCode, String unitCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCode);
        map.put("unitCode", unitCode);
        List userUnits = this.userUnitDao.listObjectByUserUnit(userCode, unitCode);
        if (userUnits != null) {
            for (UserUnit uu : userUnits) {
                IDataDictionary dd;
                if (null == uu || (dd = CodeRepositoryUtil.getDataPiece((String)"RankType", (String)uu.getUserRank())) == null || dd.getExtraCode() == null || !StringRegularOpt.isNumber((String)dd.getExtraCode())) continue;
                try {
                    uu.setXzRank(Integer.valueOf(dd.getExtraCode()).intValue());
                }
                catch (Exception e) {
                    uu.setXzRank(CodeRepositoryUtil.MAXXZRANK.intValue());
                }
            }
        }
        return userUnits;
    }

    private static boolean isMultiToMulti() {
        IDataDictionary agencyMode = CodeRepositoryUtil.getDataPiece((String)"SYSPARAM", (String)"userUnitMode");
        if (agencyMode != null) {
            return "M".equalsIgnoreCase(agencyMode.getDataValue());
        }
        return true;
    }

    @Override
    @CacheEvict(value={"UnitUsers", "UserUnits", "AllUserUnits"}, allEntries=true)
    public String saveNewUserUnit(UserUnit userunit) {
        UserUnit pUserUnit;
        if (!SysUserUnitManagerImpl.isMultiToMulti() && null != (pUserUnit = this.userUnitDao.getPrimaryUnitByUserId(userunit.getUserCode()))) {
            this.userUnitDao.deleteObjectById(pUserUnit.getUserUnitId());
        }
        if (StringBaseOpt.isNvl((String)userunit.getUserUnitId())) {
            userunit.setUserUnitId(this.userUnitDao.getNextKey());
        }
        if ("T".equals(userunit.getIsPrimary())) {
            UserInfo user;
            UserUnit origPrimUnit = this.userUnitDao.getPrimaryUnitByUserId(userunit.getUserCode());
            if (origPrimUnit != null) {
                origPrimUnit.setIsPrimary("F");
                userunit.setIsPrimary("T");
                this.userUnitDao.mergeObject(origPrimUnit);
            }
            if ((user = this.userInfoDao.getObjectById(userunit.getUserCode())) != null) {
                user.setPrimaryUnit(userunit.getUnitCode());
                this.userInfoDao.mergeObject(user);
            }
        }
        this.userUnitDao.saveNewObject(userunit);
        return userunit.getUserUnitId();
    }

    @Override
    public UserUnit getPrimaryUnitByUserCode(String userCode) {
        UserUnit uu = this.userUnitDao.getPrimaryUnitByUserId(userCode);
        return uu;
    }

    @Override
    public boolean hasUserStation(String stationCode, String userCode) {
        HashMap<String, String> filterDesc = new HashMap<String, String>();
        filterDesc.put("userStation", stationCode);
        filterDesc.put("userCode", userCode);
        List list = this.userUnitDao.listObjects(filterDesc);
        return null != list && list.size() != 0;
    }

    @Override
    @CacheEvict(value={"UnitUsers", "UserUnits", "AllUserUnits"}, allEntries=true)
    public void updateUserUnit(UserUnit userunit) {
        this.userUnitDao.updateObject(userunit);
    }

    @Override
    public UserUnit getObjectById(String userUnitId) {
        return this.userUnitDao.getObjectById(userUnitId);
    }

    @Override
    public void deleteObject(UserUnit userUnit) {
        this.userUnitDao.deleteObject(userUnit);
    }

    @Override
    public List<UserUnit> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.userUnitDao.pageQuery(QueryParameterPrepare.prepPageParams(filterMap, (com.centit.support.database.utils.PageDesc)pageDesc, (int)this.userUnitDao.pageCount(filterMap)));
    }
}

