/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class CentitUserDetailsImpl
implements CentitUserDetails,
Serializable {
    private static final long serialVersionUID = 1L;
    private String currentStationId;
    protected UserInfo userInfo;
    private Map<String, String> userSettings;
    private Map<String, String> userOptList;
    private List<RoleInfo> userRoles;
    @JSONField(serialize=false)
    private List<GrantedAuthority> arrayAuths;

    public CentitUserDetailsImpl() {
        this.arrayAuths = null;
    }

    public CentitUserDetailsImpl(UserInfo userInfo) {
        this.userInfo = userInfo;
        this.arrayAuths = null;
    }

    @JSONField(serialize=false)
    public String getUserCode() {
        return this.getUserInfo().getUserCode();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public Map<String, String> getUserSettings() {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>();
        }
        return this.userSettings;
    }

    public void putUserSettingsParams(String paramCode, String paramValue) {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>();
        }
        this.userSettings.put(paramCode, paramValue);
    }

    public void setUserSettings(Map<String, String> userSettings) {
        this.userSettings = userSettings;
    }

    public Map<String, String> getUserOptList() {
        if (this.userOptList == null) {
            this.userOptList = new HashMap<String, String>();
        }
        return this.userOptList;
    }

    public void setUserOptList(Map<String, String> userOptList) {
        this.userOptList = userOptList;
    }

    public boolean checkOptPower(String optId, String optMethod) {
        String s = this.userOptList.get(optId + "-" + optMethod);
        if (s == null) {
            return false;
        }
        return "T".equals(s);
    }

    public List<RoleInfo> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(List<RoleInfo> userRoles) {
        this.userRoles = userRoles;
    }

    @JSONField(serialize=false)
    public UserUnit getCurrentStation() {
        List uus = this.getUserInfo().getUserUnits();
        if (uus != null) {
            for (UserUnit uu : uus) {
                if (StringUtils.equals((CharSequence)this.currentStationId, (CharSequence)uu.getUserUnitId())) {
                    return uu;
                }
                if (!StringUtils.isBlank((CharSequence)this.currentStationId) || !"T".equals(uu.getIsPrimary())) continue;
                return uu;
            }
        }
        return null;
    }

    public void setCurrentStationId(String userUnitId) {
        this.currentStationId = userUnitId;
    }

    public String getCurrentStationId() {
        return this.currentStationId;
    }

    @JSONField(serialize=false)
    public String getCurrentUnitCode() {
        UserUnit cs = this.getCurrentStation();
        return cs != null ? cs.getUnitCode() : this.getUserInfo().getPrimaryUnit();
    }

    private void makeUserAuthorities() {
        this.arrayAuths = new ArrayList<GrantedAuthority>();
        if (this.userRoles.size() < 1) {
            return;
        }
        boolean havePublicRole = false;
        for (RoleInfo role : this.userRoles) {
            this.arrayAuths.add((GrantedAuthority)new SimpleGrantedAuthority("R_" + StringUtils.trim((String)role.getRoleCode())));
            if (!"public".equalsIgnoreCase(role.getRoleCode())) continue;
            havePublicRole = true;
        }
        if (!havePublicRole) {
            this.arrayAuths.add((GrantedAuthority)new SimpleGrantedAuthority("R_public"));
        }
        Collections.sort(this.arrayAuths, Comparator.comparing(GrantedAuthority::getAuthority));
    }

    public void setAuthoritiesByRoles(List<RoleInfo> roles) {
        this.setUserRoles(roles);
        this.makeUserAuthorities();
    }

    @JSONField(serialize=false)
    public Collection<GrantedAuthority> getAuthorities() {
        return this.arrayAuths;
    }

    public void setLoginIp(String loginHost) {
        this.userInfo.setLoginIp(loginHost);
    }

    public void setActiveTime(Date loginTime) {
        this.userInfo.setActiveTime(loginTime);
    }

    public String getUsername() {
        return this.userInfo.getLoginName();
    }

    public boolean isAccountNonExpired() {
        return "T".equals(this.userInfo.getIsValid());
    }

    public boolean isAccountNonLocked() {
        return "T".equals(this.userInfo.getIsValid());
    }

    public boolean isCredentialsNonExpired() {
        return "T".equals(this.userInfo.getIsValid());
    }

    public boolean isEnabled() {
        return "T".equals(this.userInfo.getIsValid());
    }

    @JSONField(serialize=false)
    public String getPassword() {
        return this.userInfo.getUserPin();
    }

    public String getUserSettingValue(String paramCode) {
        if (this.userSettings == null) {
            return null;
        }
        return this.userSettings.get(paramCode);
    }

    public void setUserSettingValue(String paramCode, String paramValue) {
        if (this.userSettings == null) {
            this.userSettings = new HashMap<String, String>();
        }
        this.userSettings.put(paramCode, paramValue);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CentitUserDetail:");
        sb.append(super.toString());
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof CentitUserDetails) {
            return this.userInfo.getUserCode().equals(((CentitUserDetails)other).getUserInfo().getUserCode());
        }
        return false;
    }

    public int hashCode() {
        return this.userInfo.getUserCode().hashCode();
    }

    @JSONField(serialize=false)
    public Object getCredentials() {
        return this.userInfo.getUserPin();
    }

    @JSONField(serialize=false)
    public Object getDetails() {
        return this;
    }

    @JSONField(serialize=false)
    public Object getPrincipal() {
        return this;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public String getName() {
        return this.userInfo.getLoginName();
    }
}

