/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.model.adapter.MessageSender;
import com.centit.framework.system.dao.InnerMsgDao;
import com.centit.framework.system.dao.InnerMsgRecipientDao;
import com.centit.framework.system.po.InnerMsg;
import com.centit.framework.system.po.InnerMsgRecipient;
import com.centit.framework.system.service.InnerMsgManager;
import com.centit.support.database.utils.PageDesc;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="innerMessageManager")
@Transactional
public class InnerMsgManagerImpl
implements InnerMsgManager,
MessageSender {
    @Resource
    @NotNull
    protected InnerMsgDao innerMsgDao;
    @Resource(name="innerMsgRecipientDao")
    @NotNull
    private InnerMsgRecipientDao recipientDao;

    @Override
    public void updateInnerMsg(InnerMsg msg) {
        this.innerMsgDao.updateInnerMsg(msg);
    }

    public String sendMessage(String sender, String receiver, String msgSubject, String msgContent, String optId, String optMethod, String optTag) {
        InnerMsg msg = new InnerMsg(sender, msgSubject, msgContent);
        msg.setSendDate(new Date());
        msg.setMsgType("P");
        msg.setMailType("O");
        msg.setMsgState("U");
        msg.setOptId(optId);
        msg.setOptMethod(optMethod);
        msg.setOptTag(optTag);
        InnerMsgRecipient recipient = new InnerMsgRecipient();
        recipient.setMInnerMsg(msg);
        recipient.setReplyMsgCode(0);
        recipient.setReceiveType("P");
        recipient.setMailType("T");
        recipient.setMsgState("U");
        this.recipientDao.saveNewObject(recipient);
        return "OK";
    }

    public String sendMessage(String sender, String receiver, String msgSubject, String msgContent) {
        return this.sendMessage(sender, receiver, msgSubject, msgContent, "msg", "sender", "");
    }

    @Override
    public void deleteMsgById(String msgCode) {
        InnerMsg msg = this.innerMsgDao.getObjectById(msgCode);
        msg.setMsgState("D");
        this.innerMsgDao.updateInnerMsg(msg);
    }

    @Override
    public List<InnerMsg> listObjects(Map<String, Object> filterMap) {
        return this.innerMsgDao.listObjects(filterMap);
    }

    @Override
    public List<InnerMsg> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.innerMsgDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.innerMsgDao.pageCount(filterMap)), (Class[])new Class[]{InnerMsg.class}));
    }

    @Override
    public InnerMsg getObjectById(String msgCode) {
        return this.innerMsgDao.getObjectById(msgCode);
    }
}

