/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.common.ObjectException;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.model.adapter.MessageSender;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.system.dao.InnerMsgDao;
import com.centit.framework.system.dao.InnerMsgRecipientDao;
import com.centit.framework.system.po.InnerMsg;
import com.centit.framework.system.po.InnerMsgRecipient;
import com.centit.framework.system.service.InnerMsgRecipientManager;
import com.centit.support.database.utils.PageDesc;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="innerMsgRecipientManager")
public class InnerMsgRecipientManagerImpl
implements InnerMsgRecipientManager,
MessageSender {
    @Resource
    @NotNull
    protected InnerMsgRecipientDao innerMsgRecipientDao;
    @Resource
    private InnerMsgDao innerMsgDao;

    @Override
    @Transactional
    public void updateRecipient(InnerMsgRecipient recipient) {
        this.innerMsgRecipientDao.updateInnerMsgRecipient(recipient);
    }

    @Override
    @Transactional
    public void sendMsg(InnerMsgRecipient recipient, String sysUserCode) {
        String receive = recipient.getReceive();
        String[] receives = StringUtils.split((String)receive, (String)",");
        InnerMsg msg = recipient.getMInnerMsg();
        if (!StringUtils.isNotBlank((CharSequence)msg.getSender())) {
            msg.setSender(sysUserCode);
            if (null == msg.getSendDate()) {
                msg.setSendDate(new Date());
            }
        }
        this.sendToMany(receives, msg, recipient);
    }

    public void sendToMany(String[] receives, InnerMsg msg, InnerMsgRecipient recipient) {
        if (null != receives && receives.length > 0) {
            String receiveName = "";
            int bo = 0;
            for (String userCode : receives) {
                if (bo > 0) {
                    receiveName = receiveName + ",";
                }
                receiveName = receiveName + CodeRepositoryUtil.getUserInfoByCode((String)userCode).getUserName();
                ++bo;
            }
            msg.setReceiveName(receiveName);
            msg.setMsgCode(this.innerMsgDao.getNextKey());
            this.innerMsgDao.saveNewObject(msg);
            recipient.setMInnerMsg(msg);
            recipient.setMsgCode(msg.getMsgCode());
            for (String userCode : receives) {
                InnerMsgRecipient innerMsgRecipient = new InnerMsgRecipient();
                innerMsgRecipient.setId(this.innerMsgRecipientDao.getNextKey());
                innerMsgRecipient.copyNOtNUllProperties(recipient);
                innerMsgRecipient.setReceive(userCode);
                this.innerMsgRecipientDao.saveNewObject(innerMsgRecipient);
            }
        }
    }

    @Override
    @Transactional
    public List<InnerMsgRecipient> getExchangeMsgs(String sender, String receiver) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sender", sender);
        map.put("receiver", receiver);
        return this.innerMsgRecipientDao.getExchangeMsgs(sender, receiver);
    }

    @Override
    @Transactional
    public void noticeByUnitCode(String unitCode, InnerMsg msg) throws ObjectException {
        List unitList = CodeRepositoryUtil.getSubUnits((String)unitCode);
        Set userList = CodeRepositoryUtil.getUnitUsers((String)unitCode);
        for (IUnitInfo ui : unitList) {
            userList.addAll(CodeRepositoryUtil.getUnitUsers((String)ui.getUnitCode()));
        }
        if (userList.size() > 0) {
            String receiveName = CodeRepositoryUtil.getUnitName((String)unitCode);
            msg.setReceiveName(receiveName);
            msg.setMsgType("A");
            msg.setMsgCode(this.innerMsgDao.getNextKey());
            this.innerMsgDao.saveNewObject(msg);
            for (IUserInfo ui : userList) {
                if (Objects.equals(msg.getSender(), ui.getUserCode())) continue;
                InnerMsgRecipient recipient = new InnerMsgRecipient();
                recipient.setMsgState(msg.getMsgState());
                recipient.setMailType(msg.getMailType());
                recipient.setMInnerMsg(msg);
                recipient.setMsgCode(msg.getMsgCode());
                recipient.setReceive(ui.getUserCode());
                recipient.setId(this.innerMsgRecipientDao.getNextKey());
                this.innerMsgRecipientDao.saveNewObject(recipient);
            }
        } else {
            throw new ObjectException("\u8be5\u673a\u6784\u4e2d\u6682\u65e0\u7528\u6237");
        }
    }

    @Override
    @Transactional
    public void deleteOneRecipientById(String id) {
        InnerMsgRecipient re = this.innerMsgRecipientDao.getObjectById(id);
        re.setMsgState("D");
        this.innerMsgRecipientDao.updateInnerMsgRecipient(re);
    }

    @Override
    @Transactional
    public long getUnreadMessageCount(String userCode) {
        return this.innerMsgRecipientDao.getUnreadMessageCount(userCode);
    }

    @Override
    @Transactional
    public List<InnerMsgRecipient> listUnreadMessage(String userCode) {
        return this.innerMsgRecipientDao.listUnreadMessage(userCode);
    }

    @Transactional
    public String sendMessage(String sender, String receiver, String msgSubject, String msgContent, String optId, String optMethod, String optTag) {
        InnerMsg msg = new InnerMsg(sender, msgSubject, msgContent);
        msg.setSendDate(new Date());
        msg.setMsgType("P");
        msg.setMailType("O");
        msg.setMsgState("U");
        msg.setOptId(optId);
        msg.setReceiveName(CodeRepositoryUtil.getUserInfoByCode((String)receiver).getUserName());
        msg.setOptMethod(optMethod);
        msg.setOptTag(optTag);
        InnerMsgRecipient recipient = new InnerMsgRecipient();
        recipient.setMInnerMsg(msg);
        recipient.setReplyMsgCode(0);
        recipient.setReceiveType("P");
        recipient.setMailType("T");
        recipient.setMsgState("U");
        String[] receives = new String[]{receiver};
        this.sendToMany(receives, msg, recipient);
        return "OK";
    }

    @Transactional
    public String sendMessage(String sender, String receiver, String msgSubject, String msgContent) {
        return this.sendMessage(sender, receiver, msgSubject, msgContent, "msg", "sender", "");
    }

    @Override
    public List<InnerMsgRecipient> listObjects(Map<String, Object> filterMap) {
        return this.innerMsgRecipientDao.listObjects(filterMap);
    }

    @Override
    public List<InnerMsgRecipient> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.innerMsgRecipientDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.innerMsgRecipientDao.pageCount(filterMap)), (Class[])new Class[]{InnerMsgRecipient.class}));
    }

    @Override
    public InnerMsgRecipient getObjectById(String id) {
        return this.innerMsgRecipientDao.getObjectById(id);
    }

    @Override
    public List<InnerMsgRecipient> listObjectsCascade(Map<String, Object> filterMap) {
        List recipients = this.innerMsgRecipientDao.listObjects(filterMap);
        for (InnerMsgRecipient recipient : recipients) {
            recipient.setMInnerMsg(this.innerMsgDao.getObjectById(recipient.getMsgCode()));
        }
        return recipients;
    }

    @Override
    public List<InnerMsgRecipient> listObjectsCascade(Map<String, Object> filterMap, PageDesc pageDesc) {
        List recipients = this.innerMsgRecipientDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.innerMsgRecipientDao.pageCount(filterMap)), (Class[])new Class[]{InnerMsgRecipient.class}));
        for (InnerMsgRecipient recipient : recipients) {
            recipient.setMInnerMsg(this.innerMsgDao.getObjectById(recipient.getMsgCode()));
        }
        return recipients;
    }
}

