/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.system.dao.OptFlowNoInfoDao;
import com.centit.framework.system.dao.OptFlowNoPoolDao;
import com.centit.framework.system.po.OptFlowNoInfo;
import com.centit.framework.system.po.OptFlowNoInfoId;
import com.centit.framework.system.po.OptFlowNoPool;
import com.centit.framework.system.po.OptFlowNoPoolId;
import com.centit.framework.system.service.OptFlowNoInfoManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OptFlowNoInfoManagerImpl
implements OptFlowNoInfoManager {
    public static final Logger logger = LoggerFactory.getLogger(OptFlowNoInfoManager.class);
    @Resource
    @NotNull
    private OptFlowNoInfoDao optFlowNoInfoDao;
    @Resource
    @NotNull
    private OptFlowNoPoolDao optFlowNoPoolDao;

    public synchronized void setOptFlowNoPoolDao(OptFlowNoPoolDao baseDao) {
        this.optFlowNoPoolDao = baseDao;
    }

    @Override
    public synchronized long newNextLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        OptFlowNoPoolId poolId;
        OptFlowNoPool poolNo;
        long nextCode;
        Date codeDate = DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate);
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        long l = nextCode = noInfo == null ? 1L : noInfo.getCurNo() + 1L;
        while ((poolNo = this.optFlowNoPoolDao.getObjectById(poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, Long.valueOf(nextCode)))) != null) {
            ++nextCode;
        }
        if (noInfo == null) {
            noInfo = new OptFlowNoInfo(noId, Long.valueOf(nextCode), DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveNewOptFlowNoInfo(noInfo);
        } else {
            noInfo.setCurNo(Long.valueOf(nextCode));
            noInfo.setLastCodeDate(DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.updateOptFlowNoInfo(noInfo);
        }
        return nextCode;
    }

    @Override
    @Transactional
    public boolean reserveLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate, Long lsh) {
        Date codeDate = DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate);
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        Long cur = noInfo == null ? 0L : noInfo.getCurNo();
        if (lsh > cur) {
            OptFlowNoPoolId poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, lsh);
            OptFlowNoPool dbPool = this.optFlowNoPoolDao.getObjectById(poolId);
            if (dbPool != null) {
                return false;
            }
            OptFlowNoPool pool = new OptFlowNoPool(poolId, DatetimeOpt.currentUtilDate());
            this.optFlowNoPoolDao.saveNewOptFlowNoPool(pool);
            return true;
        }
        return false;
    }

    @Override
    public long newNextLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate));
    }

    @Override
    public long newNextLsh(String codeCode) {
        return this.newNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public long newNextLsh(String ownerCode, String codeCode) {
        return this.newNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public synchronized long viewNextLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        Date codeDate = DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate);
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        long nextCode = 1L;
        if (noInfo != null) {
            nextCode = noInfo.getCurNo() + 1L;
        }
        return nextCode;
    }

    @Override
    public long viewNextLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate));
    }

    @Override
    public long viewNextLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate));
    }

    @Override
    public long viewNextLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate));
    }

    @Override
    public long viewNextLsh(String codeCode) {
        return this.viewNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public long viewNextLsh(String ownerCode, String codeCode) {
        return this.viewNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public synchronized void recordNextLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        Date codeDate = DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate);
        OptFlowNoPoolId poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, Long.valueOf(currCode));
        OptFlowNoPool poolNo = this.optFlowNoPoolDao.getObjectById(poolId);
        if (poolNo != null) {
            this.optFlowNoPoolDao.deleteObject(poolNo);
            return;
        }
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        if (noInfo == null) {
            noInfo = new OptFlowNoInfo(noId, Long.valueOf(currCode), DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveNewOptFlowNoInfo(noInfo);
        } else if (noInfo.getCurNo() < currCode) {
            noInfo.setCurNo(Long.valueOf(currCode));
            noInfo.setLastCodeDate(DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.updateOptFlowNoInfo(noInfo);
        }
    }

    @Override
    public void recordNextLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLsh(String codeCode, long currCode) {
        this.recordNextLsh("noowner", codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public void recordNextLsh(String ownerCode, String codeCode, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public synchronized long assignNextLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        long minPoolNo = this.optFlowNoPoolDao.fetchFirstLsh(ownerCode, codeCode, codeBaseDate);
        if (minPoolNo > 0L) {
            OptFlowNoPoolId obj = new OptFlowNoPoolId();
            obj.setOwnerCode(ownerCode);
            obj.setCodeDate(DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate));
            obj.setCodeCode(codeCode);
            obj.setCurNo(Long.valueOf(minPoolNo));
            this.optFlowNoPoolDao.deleteObjectById(obj);
            return minPoolNo;
        }
        return this.newNextLsh(ownerCode, codeCode, codeBaseDate);
    }

    @Override
    public long assignNextLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate));
    }

    @Override
    public long assignNextLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate));
    }

    @Override
    public long assignNextLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate));
    }

    @Override
    public long assignNextLsh(String ownerCode, String codeCode) {
        return this.assignNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    public long assignNextLsh(String codeCode) {
        return this.assignNextLsh("noowner", codeCode, DefaultCodeDate);
    }

    @Override
    public void releaseLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        OptFlowNoPool obj = new OptFlowNoPool();
        obj.setOwnerCode(ownerCode);
        obj.setCodeDate(DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate));
        obj.setCodeCode(codeCode);
        obj.setCurNo(Long.valueOf(currCode));
        obj.setCreateDate(DatetimeOpt.currentUtilDate());
        this.optFlowNoPoolDao.saveNewOptFlowNoPool(obj);
    }

    @Override
    public void releaseLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLsh(String ownerCode, String codeCode, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public void releaseLsh(String codeCode, long currCode) {
        this.releaseLsh("noowner", codeCode, DefaultCodeDate, currCode);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("ownerCode", ownerCode);
        filterMap.put("codeDate", codeBaseDate);
        filterMap.put("codeCode", codeCode);
        return this.optFlowNoPoolDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.optFlowNoPoolDao.pageCount(filterMap)), (Class[])new Class[]{OptFlowNoPool.class}));
    }

    @Override
    public List<OptFlowNoPool> listLshBaseDayInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshBaseMonthInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshBaseYearInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String ownerCode, String codeCode, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DefaultCodeDate, pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshInPool(String codeCode, PageDesc pageDesc) {
        return this.listLshInPool("noowner", codeCode, DefaultCodeDate, pageDesc);
    }
}

