/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.system.dao.QueryFilterConditionDao;
import com.centit.framework.system.po.QueryFilterCondition;
import com.centit.framework.system.service.QueryFilterConditionManager;
import com.centit.support.database.utils.PageDesc;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QueryFilterConditionManagerImpl
implements QueryFilterConditionManager {
    public static final Logger logger = LoggerFactory.getLogger(QueryFilterConditionManager.class);
    @Resource
    @NotNull
    private QueryFilterConditionDao queryFilterConditionDao;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listQueryFilterConditionsAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        return DictionaryMapUtils.objectsToJSONArray(this.listObjects(filterMap, pageDesc), (String[])fields);
    }

    @Override
    @Transactional
    public List<QueryFilterCondition> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.queryFilterConditionDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.queryFilterConditionDao.pageCount(filterMap)), (Class[])new Class[]{QueryFilterCondition.class}));
    }

    @Override
    @Transactional
    public QueryFilterCondition getObjectById(Long filterNo) {
        return this.queryFilterConditionDao.getObjectById(filterNo);
    }

    @Override
    @Transactional
    public void mergeObject(QueryFilterCondition userQueryFilter) {
        this.queryFilterConditionDao.mergeObject(userQueryFilter);
    }

    @Override
    @Transactional
    public void deleteObjectById(Long filterNo) {
        this.queryFilterConditionDao.deleteObjectById(filterNo);
    }

    @Override
    public Long saveNewObject(QueryFilterCondition userQueryFilter) {
        return null;
    }
}

