/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.OptMethodUrlMap;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.framework.system.po.VOptTree;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysRoleManager")
public class SysRoleManagerImpl
implements SysRoleManager {
    public static Logger logger = LoggerFactory.getLogger(SysRoleManagerImpl.class);
    @Resource
    @NotNull
    private OptInfoDao optInfoDao;
    @Resource
    @NotNull
    private OptMethodDao optMethodDao;
    @Resource
    @NotNull
    private RolePowerDao rolePowerDao;
    @Resource
    @NotNull
    protected RoleInfoDao roleInfoDao;
    @Resource
    @NotNull
    private UserRoleDao userRoleDao;
    @Value(value="${framework.roleinfo.id.generator:}")
    protected String roleIdFormat;

    @Override
    @Transactional
    public List<RolePower> getRolePowers(String rolecode) {
        return this.rolePowerDao.listRolePowersByRoleCode(rolecode);
    }

    @Override
    @Transactional
    public List<RolePower> getRolePowersByDefCode(String optCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("optCode", optCode);
        return this.rolePowerDao.listObjects(filterMap);
    }

    @Override
    @CacheEvict(value={"RoleInfo"}, key="'roleCodeMap'")
    @Transactional
    public Serializable saveNewRoleInfo(RoleInfo o) {
        if (StringUtils.isBlank((CharSequence)o.getRoleCode())) {
            JSONObject idFormat;
            String roleCode = this.roleInfoDao.getNextKey();
            if (StringUtils.isNotBlank((CharSequence)this.roleIdFormat) && (idFormat = (JSONObject)JSON.parse((String)this.roleIdFormat)) != null) {
                roleCode = StringBaseOpt.midPad((String)roleCode, (int)NumberBaseOpt.castObjectToInteger((Object)idFormat.get((Object)"length"), (Integer)1), (String)idFormat.getString("prefix"), (String)idFormat.getString("pad"));
            }
            o.setRoleCode(roleCode);
        }
        this.roleInfoDao.saveNewObject(o);
        return o.getRoleCode();
    }

    @Override
    @Transactional
    public List<VOptTree> getVOptTreeList() {
        return this.roleInfoDao.getVOptTreeList();
    }

    @Override
    @Transactional
    public List<RolePower> listAllRolePowers() {
        return this.rolePowerDao.listObjectsAll();
    }

    @Override
    @Transactional
    public List<OptMethod> listAllOptMethods() {
        return this.optMethodDao.listObjects();
    }

    private List<OptMethodUrlMap> listAllOptMethodUrlMap() {
        return this.optInfoDao.listAllOptMethodUrlMap();
    }

    @Override
    @CacheEvict(value={"RoleInfo"}, allEntries=true)
    @Transactional
    public void updateRoleInfo(RoleInfo o) {
        this.roleInfoDao.updateRole(o);
    }

    @Override
    @CacheEvict(value={"RoleInfo"}, allEntries=true)
    @Transactional
    public List<RolePower> updateRolePower(RoleInfo o) {
        this.roleInfoDao.updateRole(o);
        List newRPs = o.getRolePowers();
        List rps = this.rolePowerDao.listRolePowersByRoleCode(o.getRoleCode());
        if (newRPs == null || newRPs.size() < 1) {
            this.rolePowerDao.deleteRolePowersByRoleCode(o.getRoleCode());
            return rps;
        }
        for (RolePower rp : newRPs) {
            rp.setRoleCode(o.getRoleCode());
        }
        Triple forUpdate = ListOpt.compareTwoList((List)rps, (List)newRPs, Comparator.comparing(RolePower::getOptCode));
        if (forUpdate.getRight() != null) {
            for (RolePower rp : (List)forUpdate.getRight()) {
                this.rolePowerDao.deleteObjectById(new RolePowerId(rp.getRoleCode(), rp.getOptCode()));
                if (!rp.getRoleCode().startsWith("G$")) continue;
                String optCode = rp.getOptCode();
                String unitCode = rp.getRoleCode().substring(2);
                List roleInfos = this.roleInfoDao.listObjects(QueryUtils.createSqlParamsMap((Object[])new Object[]{"unitCode", unitCode, "roleType", "D"}));
                for (RoleInfo roleInfo : roleInfos) {
                    this.rolePowerDao.deleteObjectById(new RolePowerId(roleInfo.getRoleCode(), optCode));
                }
            }
        }
        if (forUpdate.getLeft() != null) {
            for (RolePower rp : (List)forUpdate.getLeft()) {
                this.rolePowerDao.saveNewRolePower(rp);
            }
        }
        if (forUpdate.getMiddle() != null) {
            for (RolePower rp : (List)forUpdate.getMiddle()) {
                RolePower oldRolePower = (RolePower)rp.getLeft();
                RolePower newRolePower = (RolePower)rp.getRight();
                oldRolePower.copyNotNullProperty(newRolePower);
                this.rolePowerDao.updateRolePower(oldRolePower);
            }
        }
        return rps;
    }

    @Override
    @CacheEvict(value={"RoleInfo"}, allEntries=true)
    @Transactional
    public void deleteRoleInfo(String roleCode) {
        this.rolePowerDao.deleteRolePowersByRoleCode(roleCode);
        this.roleInfoDao.deleteObjectById(roleCode);
    }

    @Override
    @Transactional
    public RoleInfo getRoleInfo(String roleCode) {
        RoleInfo rf = this.roleInfoDao.getObjectById(roleCode);
        rf.addAllRolePowers(this.rolePowerDao.listRolePowersByRoleCode(roleCode));
        return rf;
    }

    @Override
    @Transactional
    public List<RoleInfo> listObjects(Map<String, Object> filterMap) {
        return this.roleInfoDao.listObjects(filterMap);
    }

    @Override
    @Transactional
    public List<RoleInfo> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.roleInfoDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.roleInfoDao.pageCount(filterMap)), (Class[])new Class[]{RoleInfo.class}));
    }

    @Override
    @Transactional
    public RoleInfo getObjectById(String roleCode) {
        return this.roleInfoDao.getObjectById(roleCode);
    }

    @Override
    @Transactional
    public int countRoleUserSum(String roleCode) {
        return this.userRoleDao.pageCount(QueryUtils.createSqlParamsMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Override
    @Transactional
    public boolean judgeSysRoleNameExist(String roleName, String roleCode, String unitCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        if (unitCode == null) {
            filterMap.put("NP_ALL", "true");
        } else {
            filterMap.put("roleType", "D");
            filterMap.put("unitCode", unitCode);
        }
        filterMap.put("roleNameEq", roleName);
        List roleInfos = this.roleInfoDao.listObjects(filterMap);
        return roleInfos == null || roleInfos.size() == 0 || roleCode != null && roleCode.equals(((RoleInfo)roleInfos.get(0)).getRoleCode());
    }
}

