/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ObjectException;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.FVUserOptList;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserManager;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserManager")
public class SysUserManagerImpl
implements SysUserManager {
    public static Logger logger = LoggerFactory.getLogger(SysUserManagerImpl.class);
    @Resource
    @NotNull
    private CentitPasswordEncoder passwordEncoder;
    @Resource
    @NotNull
    private UserUnitDao userUnitDao;
    @Resource
    @NotNull
    private UserRoleDao userRoleDao;
    @Resource
    protected UserInfoDao userInfoDao;
    @Value(value="${framework.userinfo.id.generator:}")
    protected String userIdFormat;

    private String getDefaultPassword(String userCode) {
        return this.passwordEncoder.createPassword("000000", (Object)userCode);
    }

    @Override
    @Transactional
    public List<RoleInfo> listUserValidRoles(String userCode) {
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        roles.add(new RoleInfo("public", "general public", "G", "G", "T", "general public"));
        List ls = this.userRoleDao.listUserRolesByUserCode(userCode);
        if (ls != null) {
            for (FVUserRoles l : ls) {
                RoleInfo roleInfo = new RoleInfo();
                BeanUtils.copyProperties((Object)l, (Object)roleInfo);
                roles.add(roleInfo);
            }
        }
        return roles;
    }

    @Override
    @Transactional
    public void resetPwd(String userCode) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        user.setUserPin(this.getDefaultPassword(user.getUserCode()));
        this.userInfoDao.updateUser(user);
    }

    @Override
    @Transactional
    public void resetPwd(String[] userCodes) {
        for (String userCode : userCodes) {
            this.resetPwd(userCode);
        }
    }

    @Override
    @Transactional
    public void setNewPassword(String userCode, String oldPassword, String newPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        if (!this.passwordEncoder.isPasswordValid(user.getUserPin(), oldPassword, (Object)user.getUserCode())) {
            throw new ObjectException("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e\uff01");
        }
        if (user.getUserPin().equals(this.passwordEncoder.encodePassword(newPassword, (Object)user.getUserCode()))) {
            throw new ObjectException("\u65b0\u5bc6\u7801\u548c\u65e7\u5bc6\u7801\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u65b0\u5bc6\u7801\uff01");
        }
        user.setUserPin(this.passwordEncoder.encodePassword(newPassword, (Object)user.getUserCode()));
        this.userInfoDao.updateUser(user);
    }

    @Override
    @Transactional
    public void forceSetPassword(String userCode, String newPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        user.setUserPin(this.passwordEncoder.createPassword(newPassword, (Object)user.getUserCode()));
        this.userInfoDao.updateUser(user);
    }

    @Override
    @Transactional
    public boolean checkIfUserExists(UserInfo user) {
        return this.isLoginNameExist(user.getUserCode(), user.getLoginName());
    }

    @Override
    @Transactional
    public boolean isLoginNameExist(String userCode, String loginName) {
        return this.userInfoDao.isLoginNameExist(userCode, loginName) > 0;
    }

    @Override
    @Transactional
    public boolean isCellPhoneExist(String userCode, String regPhone) {
        return this.userInfoDao.isCellPhoneExist(userCode, regPhone) > 0;
    }

    @Override
    @Transactional
    public boolean isEmailExist(String userCode, String regEmail) {
        return this.userInfoDao.isEmailExist(userCode, regEmail) > 0;
    }

    @Override
    @Transactional
    public boolean isAnyOneExist(String userCode, String loginName, String regPhone, String regEmail) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", StringUtils.isBlank((CharSequence)userCode) ? "null" : userCode);
        map.put("loginName", StringUtils.isBlank((CharSequence)loginName) ? "null" : loginName);
        map.put("regCellPhone", StringUtils.isBlank((CharSequence)regPhone) ? "null" : regPhone);
        map.put("regEmail", StringUtils.isBlank((CharSequence)regEmail) ? "null" : regEmail);
        return this.userInfoDao.isAnyOneExist(userCode, loginName, regPhone, regEmail) > 0;
    }

    @Override
    @CacheEvict(value={"UserInfo", "UnitUsers", "UserUnits", "AllUserUnits"}, allEntries=true)
    @Transactional
    public void saveNewUserInfo(UserInfo userInfo, UserUnit userUnit) {
        String userCode = this.userInfoDao.getNextKey();
        if (StringUtils.isBlank((CharSequence)this.userIdFormat)) {
            userCode = StringBaseOpt.midPad((String)userCode, (int)8, (String)"U", (char)'0');
        } else {
            JSONObject idFormat = (JSONObject)JSON.parse((String)this.userIdFormat);
            if (idFormat != null) {
                userCode = StringBaseOpt.midPad((String)userCode, (int)NumberBaseOpt.castObjectToInteger((Object)idFormat.get((Object)"length"), (Integer)1), (String)idFormat.getString("prefix"), (String)idFormat.getString("pad"));
            }
        }
        userInfo.setUserCode(userCode);
        userInfo.setUserPin(this.getDefaultPassword(userInfo.getUserCode()));
        this.userInfoDao.saveNewObject(userInfo);
        userUnit.setUserUnitId(this.userUnitDao.getNextKey());
        userUnit.setUserCode(userInfo.getUserCode());
        userUnit.setUnitCode(userInfo.getPrimaryUnit());
        userUnit.setIsPrimary("T");
        this.userUnitDao.saveNewObject(userUnit);
        if (null != userInfo.listUserRoles()) {
            for (UserRole ur : userInfo.listUserRoles()) {
                this.userRoleDao.saveNewObject(ur);
            }
        }
    }

    @Override
    @CacheEvict(value={"UserInfo", "UnitUsers", "UserUnits", "AllUserUnits"}, allEntries=true)
    @Transactional
    public void updateUserInfo(UserInfo userinfo) {
        this.userInfoDao.updateUser(userinfo);
    }

    @Override
    @CacheEvict(value={"UserInfo"}, allEntries=true)
    @Transactional
    public void updateUserProperities(UserInfo userinfo) {
        this.userInfoDao.updateUser(userinfo);
    }

    @Override
    @CacheEvict(value={"UserInfo", "UnitUsers", "UserUnits", "AllUserUnits"}, allEntries=true)
    @Transactional
    public void deleteUserInfo(String userCode) {
        this.userUnitDao.deleteUserUnitByUser(userCode);
        this.userRoleDao.deleteByUserId(userCode);
        this.userInfoDao.deleteObjectById(userCode);
    }

    @Override
    @Transactional
    public UserInfo loadUserByLoginname(String userCode) {
        return this.userInfoDao.getUserByLoginName(userCode);
    }

    @Override
    @Transactional
    public List<FVUserOptList> getAllOptMethodByUser(String userCode) {
        return this.userInfoDao.getAllOptMethodByUser(userCode);
    }

    @Override
    @Transactional
    public boolean checkUserPassword(String userCode, String oldPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        return this.passwordEncoder.isPasswordValid(user.getUserPin(), oldPassword, (Object)user.getUserCode());
    }

    @Override
    @Transactional
    public List<UserInfo> listObjects(Map<String, Object> filterMap) {
        return this.userInfoDao.listObjects(filterMap);
    }

    @Override
    @Transactional
    public List<UserInfo> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.userInfoDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.userInfoDao.pageCount(filterMap)), (Class[])new Class[]{UserInfo.class}));
    }

    @Override
    @Transactional
    public UserInfo getObjectById(String userCode) {
        return this.userInfoDao.getUserByCode(userCode);
    }

    @Override
    @Transactional
    public UserInfo getUserByRegEmail(String regEmail) {
        return this.userInfoDao.getUserByRegEmail(regEmail);
    }

    @Override
    @Transactional
    public UserInfo getUserByRegCellPhone(String regCellPhone) {
        return this.userInfoDao.getUserByRegCellPhone(regCellPhone);
    }

    @Override
    @Transactional
    public UserInfo getUserByUserWord(String userWord) {
        return this.userInfoDao.getUserByUserWord(userWord);
    }
}

