/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.framework.system.service.SysUserRoleManager;
import com.centit.support.database.utils.PageDesc;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysUserRoleManagerImpl
implements SysUserRoleManager {
    @Resource
    @NotNull
    protected UserRoleDao userRoleDao;
    @Resource
    private UserInfoDao userInfoDao;

    @Override
    public void mergeObject(UserRole dbUserRole, UserRole userRole) {
        this.userRoleDao.deleteObject(dbUserRole);
        this.userRoleDao.mergeObject(userRole);
    }

    @Override
    public JSONArray listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        List userRoles = this.userRoleDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.userRoleDao.pageCount(filterMap)), (Class[])new Class[]{UserRole.class}));
        return DictionaryMapUtils.objectsToJSONArray((Collection)userRoles);
    }

    @Override
    public UserRole getObjectById(UserRoleId id) {
        return this.userRoleDao.getObjectById(id);
    }

    @Override
    public void mergeObject(UserRole dbUserRole) {
        this.userRoleDao.mergeObject(dbUserRole);
    }

    @Override
    public void deleteObjectById(UserRoleId id) {
        this.userRoleDao.deleteObjectById(id);
    }

    @Override
    @Transactional
    public List<UserInfo> listUsersByRole(String roleCode) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("queryByRole", roleCode);
        return this.userInfoDao.listObjects(map);
    }

    @Override
    @Transactional
    public List<FVUserRoles> listUserRolesByUserCode(String userCode) {
        return this.userRoleDao.listUserRolesByUserCode(userCode);
    }

    @Override
    @Transactional
    public List<FVUserRoles> listRoleUsersByRoleCode(String roleCode) {
        return this.userRoleDao.listRoleUsersByRoleCode(roleCode);
    }

    @Override
    @Transactional
    public JSONArray pageQueryUserRole(Map<String, Object> filterMap, PageDesc pageDesc) {
        return DictionaryMapUtils.objectsToJSONArray((Collection)this.userRoleDao.pageQueryUserRole(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.userRoleDao.pageCountUserRole(filterMap)), (Class[])new Class[]{FVUserRoles.class})));
    }

    @Override
    @Transactional
    public List<UserRole> listUserRoles(String userCode) {
        return this.userRoleDao.listRoleUsers(userCode);
    }

    @Override
    @Transactional
    public List<UserRole> listRoleUsers(String roleCode) {
        return this.userRoleDao.listRoleUsers(roleCode);
    }
}

