/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.system.dao.OptDataScopeDao;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.po.OptDataScope;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.service.OptInfoManager;
import com.centit.framework.system.service.impl.DBPlatformEnvironment;
import com.centit.support.algorithm.CollectionsOpt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="functionManager")
public class OptInfoManagerImpl
implements OptInfoManager {
    @Resource
    @NotNull
    private OptInfoDao optInfoDao;
    @Resource(name="optMethodDao")
    @NotNull
    private OptMethodDao optMethodDao;
    @Resource(name="optDataScopeDao")
    @NotNull
    private OptDataScopeDao dataScopeDao;
    @Resource(name="rolePowerDao")
    @NotNull
    private RolePowerDao rolePowerDao;

    @Override
    @Transactional
    public boolean hasChildren(String optId) {
        return this.optInfoDao.countChildrenSum(optId) > 0;
    }

    @Override
    @Transactional
    public void saveNewOptInfo(OptInfo optInfo) {
        this.syncState(optInfo);
        OptInfo parentOpt = this.optInfoDao.getObjectById(optInfo.getPreOptId());
        if (parentOpt == null) {
            optInfo.setPreOptId("0");
        }
        this.optInfoDao.saveNewObject(optInfo);
        if (optInfo.getOptMethods() != null && optInfo.getOptMethods().size() > 0) {
            for (OptMethod o : optInfo.getOptMethods()) {
                o.setOptCode(this.optMethodDao.getNextOptCode());
                o.setOptId(optInfo.getOptId());
                this.optMethodDao.saveNewObject(o);
            }
        } else if (!"W".equals(optInfo.getOptType())) {
            OptMethod createDef = new OptMethod();
            createDef.setOptCode(this.optMethodDao.getNextOptCode());
            createDef.setOptId(optInfo.getOptId());
            createDef.setOptName("\u67e5\u770b");
            createDef.setOptMethod("search");
            createDef.setOptUrl("/changeme");
            createDef.setOptReq("CRUD");
            createDef.setOptDesc("\u67e5\u770b\uff08\u7cfb\u7edf\u9ed8\u8ba4\uff09");
            this.optMethodDao.saveNewObject(createDef);
        }
        CodeRepositoryCache.evictCache((String)"OptInfo");
        CodeRepositoryCache.evictCache((String)"OptMethod");
    }

    @Override
    @Transactional
    public void updateOptInfo(OptInfo optInfo) {
        this.syncState(optInfo);
        this.optInfoDao.updateOptInfo(optInfo);
        CodeRepositoryCache.evictCache((String)"OptInfo");
    }

    @Override
    @Transactional
    public void updateOperationPower(OptInfo optInfo) {
        List oldDataScopes;
        Triple compareScope;
        List newDataScopes;
        List oldOptMethods;
        Triple compareMethod;
        this.optInfoDao.updateOptInfo(optInfo);
        List newOptMethods = optInfo.getOptMethods();
        if (newOptMethods == null || newOptMethods.size() < 1) {
            this.optMethodDao.deleteOptMethodsByOptID(optInfo.getOptId());
        }
        if ((compareMethod = CollectionsOpt.compareTwoList((List)(oldOptMethods = this.optMethodDao.listOptMethodByOptID(optInfo.getOptId())), (List)newOptMethods, Comparator.comparing(OptMethod::getOptId))).getRight() != null) {
            for (OptMethod optMethod : (List)compareMethod.getRight()) {
                this.optMethodDao.deleteObject(optMethod);
            }
        }
        if (compareMethod.getLeft() != null) {
            for (OptMethod optMethod : (List)compareMethod.getLeft()) {
                optMethod.setOptCode(this.optMethodDao.getNextOptCode());
                optMethod.setOptId(optInfo.getOptId());
                this.optMethodDao.saveNewObject(optMethod);
            }
        }
        if (compareMethod.getMiddle() != null) {
            for (Pair pair : (List)compareMethod.getMiddle()) {
                ((OptMethod)pair.getLeft()).copyNotNullProperty((OptMethod)pair.getRight());
                this.optMethodDao.updateOptMethod((OptMethod)pair.getLeft());
            }
        }
        if ((newDataScopes = optInfo.getDataScopes()) == null || newDataScopes.size() < 1) {
            this.dataScopeDao.deleteDataScopeOfOptID(optInfo.getOptId());
        }
        if ((compareScope = CollectionsOpt.compareTwoList((List)(oldDataScopes = this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId())), (List)newDataScopes, Comparator.comparing(OptDataScope::getOptId))).getRight() != null) {
            for (OptDataScope optDataScope : (List)compareScope.getRight()) {
                this.dataScopeDao.deleteObject(optDataScope);
            }
        }
        if (compareScope.getLeft() != null) {
            for (OptDataScope optDataScope : (List)compareScope.getLeft()) {
                optDataScope.setOptScopeCode(this.dataScopeDao.getNextOptCode());
                optDataScope.setOptId(optInfo.getOptId());
                this.dataScopeDao.saveNewOPtDataScope(optDataScope);
            }
        }
        if (compareScope.getMiddle() != null) {
            for (Pair pair : (List)compareScope.getMiddle()) {
                ((OptDataScope)pair.getLeft()).copyNotNullProperty((OptDataScope)pair.getRight());
                this.dataScopeDao.updateOptDataScope((OptDataScope)pair.getLeft());
            }
        }
        CodeRepositoryCache.evictCache((String)"OptInfo");
        CodeRepositoryCache.evictCache((String)"OptMethod");
    }

    @Override
    @Transactional
    public OptInfo getOptInfoById(String optId) {
        OptInfo oinfo = this.optInfoDao.getObjectById(optId);
        if (oinfo != null) {
            oinfo.addAllOptMethods(this.optMethodDao.listOptMethodByOptID(optId));
            oinfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optId));
        }
        return oinfo;
    }

    @Override
    @Transactional
    public void deleteOptInfoById(String optId) {
        this.dataScopeDao.deleteDataScopeOfOptID(optId);
        this.optMethodDao.deleteOptMethodsByOptID(optId);
        this.optInfoDao.deleteObjectById(optId);
        CodeRepositoryCache.evictCache((String)"OptInfo");
    }

    @Override
    @Transactional
    public void deleteOptInfo(OptInfo optinfo) {
        this.deleteOptInfoById(optinfo.getOptId());
    }

    @Override
    @Transactional
    public List<OptInfo> listSysAndOptPowerOpts() {
        return this.optInfoDao.listMenuByTypes(new String[]{"S", "O"});
    }

    @Override
    @Transactional
    public List<OptInfo> listItemPowerOpts() {
        return this.optInfoDao.listMenuByTypes(new String[]{"I"});
    }

    @Override
    @Transactional
    public List<String> listUserDataFiltersByOptIDAndMethod(String sUserCode, String sOptId, String sOptMethod) {
        List dataScopes = this.optInfoDao.listUserDataPowerByOptMethod(sUserCode, sOptId, sOptMethod);
        if (dataScopes == null || dataScopes.size() == 0) {
            return null;
        }
        HashSet<String> scopeCodes = new HashSet<String>();
        for (String scopes : dataScopes) {
            String[] codes;
            if (scopes == null || "null".equalsIgnoreCase(scopes) || "all".equalsIgnoreCase(scopes)) {
                return null;
            }
            for (String code : codes = scopes.split(",")) {
                if (code == null || "".equals(code.trim())) continue;
                scopeCodes.add(code.trim());
            }
        }
        if (scopeCodes.size() == 0) {
            return null;
        }
        return this.dataScopeDao.listDataFiltersByIds(scopeCodes);
    }

    @Override
    @Transactional
    public List<OptInfo> listObjectFormatTree(List<OptInfo> optInfos, boolean fillDefAndScope) {
        Iterator<OptInfo> menus = optInfos.iterator();
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (fillDefAndScope) {
                optInfo.addAllOptMethods(this.optMethodDao.listOptMethodByOptID(optInfo.getOptId()));
                optInfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId()));
            }
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        return parentMenu;
    }

    @Override
    @Transactional
    public List<OptInfo> listOptWithPowerUnderUnit(String sUnitCode) {
        List allOpts = this.optInfoDao.listMenuByTypes(new String[]{"S", "O"});
        List optDefs = this.optMethodDao.listOptMethodByRoleCode("G$" + sUnitCode);
        HashSet<OptInfo> roleOpts = new HashSet<OptInfo>();
        for (OptInfo optInfo : allOpts) {
            for (OptMethod def : optDefs) {
                if (!optInfo.getOptId().equals(def.getOptId())) continue;
                optInfo.addOptMethod(def);
            }
            if (optInfo.getOptMethods().size() <= 0) continue;
            optInfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId()));
            roleOpts.add(optInfo);
        }
        HashSet<OptInfo> preParents = new HashSet<OptInfo>();
        preParents.addAll(roleOpts);
        while (true) {
            int parents = 0;
            HashSet<OptInfo> parentMenu = new HashSet<OptInfo>();
            block3: for (OptInfo optInfo : preParents) {
                for (OptInfo opt : allOpts) {
                    if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                    parentMenu.add(opt);
                    roleOpts.add(opt);
                    ++parents;
                    continue block3;
                }
            }
            if (parents == 0) break;
            preParents = parentMenu;
        }
        ArrayList<OptInfo> roleOptInfos = new ArrayList<OptInfo>();
        roleOptInfos.addAll(roleOpts);
        return roleOptInfos;
    }

    @Override
    public List<OptInfo> listObjects() {
        return this.optInfoDao.listObjectsAll();
    }

    @Override
    public List<OptInfo> listObjects(Map<String, Object> filterMap) {
        return this.optInfoDao.listObjects(filterMap);
    }

    @Override
    public OptInfo getObjectById(String optId) {
        return this.optInfoDao.getObjectById(optId);
    }

    private List<OptInfo> findSubOptInfo(String optId) {
        ArrayList<OptInfo> result = new ArrayList<OptInfo>();
        List optInfos = this.optInfoDao.listObjectByParentOptid(optId);
        if (optInfos != null && optInfos.size() > 0) {
            result.addAll(optInfos);
            for (OptInfo o : optInfos) {
                result.addAll(this.findSubOptInfo(o.getOptId()));
            }
        }
        return result;
    }

    private List<OptInfo> findPreOptInfo(String preId) {
        ArrayList<OptInfo> result = new ArrayList<OptInfo>();
        OptInfo optInfo = this.optInfoDao.getObjectById(preId);
        if (optInfo != null) {
            result.add(optInfo);
            result.addAll(this.findPreOptInfo(optInfo.getPreOptId()));
        }
        return result;
    }

    private void syncState(OptInfo optInfo) {
        List<OptInfo> optInfos;
        if ("N".equals(optInfo.getIsInToolbar())) {
            optInfos = this.findSubOptInfo(optInfo.getOptId());
            for (OptInfo o : optInfos) {
                o.setIsInToolbar("N");
                this.optInfoDao.updateOptInfo(o);
            }
        } else {
            optInfos = this.findPreOptInfo(optInfo.getPreOptId());
            for (OptInfo o : optInfos) {
                o.setIsInToolbar("Y");
                this.optInfoDao.updateOptInfo(o);
            }
        }
        optInfos = this.findSubOptInfo(optInfo.getOptId());
        optInfos.addAll(this.findPreOptInfo(optInfo.getPreOptId()));
        for (OptInfo o : optInfos) {
            o.setOptType(optInfo.getOptType());
            this.optInfoDao.updateOptInfo(o);
        }
    }

    @Override
    @Transactional
    public List<OptInfo> listUserAllPower(String userCode, boolean asAdmin) {
        List preOpts = this.optInfoDao.getMenuFuncByOptUrl();
        String optType = asAdmin ? "S" : "O";
        List ls = this.optInfoDao.listUserAllSubMenu(userCode, optType);
        List<OptInfo> menuFunsByUser = DBPlatformEnvironment.getMenuFuncs(preOpts, ls);
        return menuFunsByUser;
    }
}

