/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.service.OptMethodManager;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="optMethodManager")
@Transactional
public class OptMethodManagerImpl
implements OptMethodManager {
    @Resource
    @NotNull
    protected OptMethodDao optMethodDao;

    @Override
    public void updateOptMethod(OptMethod o) {
        this.optMethodDao.updateOptMethod(o);
        CodeRepositoryCache.evictCache((String)"OptMethod");
    }

    @Override
    public List<OptMethod> listOptMethodByOptID(String sOptID) {
        return this.optMethodDao.listOptMethodByOptID(sOptID);
    }

    @Override
    public String getNextOptCode() {
        return this.optMethodDao.getNextOptCode();
    }

    @Override
    public List<OptMethod> listObjects() {
        return this.optMethodDao.listObjectsAll();
    }

    @Override
    public OptMethod getObjectById(String optCode) {
        return this.optMethodDao.getObjectById(optCode);
    }

    @Override
    public void deleteObjectById(String optCode) {
        this.optMethodDao.deleteObjectById(optCode);
        CodeRepositoryCache.evictCache((String)"OptMethod");
    }

    @Override
    public String saveNewObject(OptMethod optMethod) {
        this.optMethodDao.saveNewObject(optMethod);
        CodeRepositoryCache.evictCache((String)"OptMethod");
        return optMethod.getOptCode();
    }
}

