/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.system.dao.OptLogDao;
import com.centit.framework.system.po.OptLog;
import com.centit.framework.system.service.OptLogManager;
import com.centit.support.database.utils.PageDesc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="optLogManager")
public class OptLogManagerImpl
implements OptLogManager,
OperationLogWriter {
    public static final Logger logger = LoggerFactory.getLogger(OptLogManager.class);
    private OptLogDao optLogDao;

    @Resource(name="optLogDao")
    @NotNull
    public void setOptLogDao(OptLogDao optLogDao) {
        this.optLogDao = optLogDao;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void saveBatchObjects(List<OptLog> optLogs) {
        if (CollectionUtils.isEmpty(optLogs)) {
            return;
        }
        for (OptLog optLog : optLogs) {
            optLog.setLogId(this.optLogDao.createNewLogId());
            this.optLogDao.saveNewObject(optLog);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(Date begin, Date end) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("beginDate", String.valueOf(begin));
        map.put("endDate", String.valueOf(end));
        this.optLogDao.delete(begin, end);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<String> listOptIds() {
        return this.optLogDao.listOptIds();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteMany(Long[] logIds) {
        for (Long logId : logIds) {
            this.optLogDao.deleteObjectById(logId);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void save(OperationLog optLog) {
        OptLog optlog = new OptLog();
        optlog.copy(optLog);
        optlog.setLogId(this.optLogDao.createNewLogId());
        this.optLogDao.saveNewObject(optlog);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void save(List<OperationLog> optLogs) {
        ArrayList<OptLog> optlogs = new ArrayList<OptLog>();
        for (OperationLog ol : optLogs) {
            OptLog optlog = new OptLog();
            optlog.copy(ol);
            optlogs.add(optlog);
        }
        this.saveBatchObjects(optlogs);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listObjectsAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        return DictionaryMapUtils.objectsToJSONArray((Collection)this.optLogDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.optLogDao.pageCount(filterMap)), (Class[])new Class[]{OptLog.class})));
    }

    @Override
    @Transactional
    public OptLog getObjectById(Long logId) {
        return this.optLogDao.getObjectById(logId);
    }

    @Override
    @Transactional
    public void deleteObjectById(Long logId) {
        this.optLogDao.deleteObjectById(logId);
    }
}

