/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.system.dao.UnitRoleDao;
import com.centit.framework.system.po.UnitRole;
import com.centit.framework.system.po.UnitRoleId;
import com.centit.framework.system.service.SysUnitRoleManager;
import com.centit.support.database.utils.PageDesc;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUnitRoleManager")
public class SysUnitRoleManagerImpl
implements SysUnitRoleManager {
    @Resource
    @NotNull
    protected UnitRoleDao unitRoleDao;

    @Override
    @Transactional
    public JSONArray listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        List unitRoles = this.unitRoleDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.unitRoleDao.pageCount(filterMap)), (Class[])new Class[]{UnitRole.class}));
        return DictionaryMapUtils.objectsToJSONArray((Collection)unitRoles);
    }

    @Override
    @Transactional
    public JSONArray listUnitRoles(String unitCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(5);
        filterMap.put("unitCode", unitCode);
        List unitRoles = this.unitRoleDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.unitRoleDao.pageCount(filterMap)), (Class[])new Class[]{UnitRole.class}));
        return DictionaryMapUtils.objectsToJSONArray((Collection)unitRoles);
    }

    @Override
    @Transactional
    public JSONArray listRoleUnits(String roleCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(5);
        filterMap.put("roleCode", roleCode);
        List unitRoles = this.unitRoleDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.unitRoleDao.pageCount(filterMap)), (Class[])new Class[]{UnitRole.class}));
        return DictionaryMapUtils.objectsToJSONArray((Collection)unitRoles);
    }

    @Override
    @Transactional
    public UnitRole getUnitRoleById(String unitCode, String roleCode) {
        return this.unitRoleDao.getUnitRoleById(new UnitRoleId(unitCode, roleCode));
    }

    @Override
    @Transactional
    public void saveNewUnitRole(UnitRole dbUnitRole) {
        this.unitRoleDao.saveNewObject(dbUnitRole);
    }

    @Override
    @Transactional
    public void deleteUnitRole(String unitCode, String roleCode) {
        this.unitRoleDao.deleteUnitRoleById(new UnitRoleId(unitCode, roleCode));
    }

    @Override
    @Transactional
    public void updateUnitRole(UnitRole unitRole) {
        this.unitRoleDao.updateUnitRole(unitRole);
    }

    @Override
    @Transactional
    public void mergeUnitRole(UnitRole unitRole) {
        this.unitRoleDao.mergeUnitRole(unitRole);
    }

    @Override
    @Transactional
    public JSONArray listRoleSubUnits(String roleCode, String unitPathPrefix, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("roleCode", roleCode);
        filterMap.put("unitPathPrefix", unitPathPrefix);
        List unitRoles = this.unitRoleDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.unitRoleDao.pageCount(filterMap)), (Class[])new Class[]{UnitRole.class}));
        return DictionaryMapUtils.objectsToJSONArray((Collection)unitRoles);
    }

    @Override
    @Transactional
    public JSONArray listCurrentUnitRoles(String unitCode, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        filterMap.put("unitCode", unitCode);
        filterMap.put("currentUnitCode", unitCode);
        List unitRoles = this.unitRoleDao.pageQuery(QueryParameterPrepare.makeMybatisOrderByParam((Map)QueryParameterPrepare.prepPageParams(filterMap, (PageDesc)pageDesc, (int)this.unitRoleDao.pageCount(filterMap)), (Class[])new Class[]{UnitRole.class}));
        return DictionaryMapUtils.objectsToJSONArray((Collection)unitRoles);
    }
}

